/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.ExecutorState$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.FileAppender$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tEa!B\u0001\u0003\u0001\u0011a!AD#yK\u000e,Ho\u001c:Sk:tWM\u001d\u0006\u0003\u0007\u0011\taa^8sW\u0016\u0014(BA\u0003\u0007\u0003\u0019!W\r\u001d7ps*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0006CB\u0004\u0018\nZ\u0002\u0001+\u0005Y\u0002C\u0001\u000f \u001d\tqQ$\u0003\u0002\u001f\u001f\u00051\u0001K]3eK\u001aL!\u0001I\u0011\u0003\rM#(/\u001b8h\u0015\tqr\u0002\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u0019\t\u0007\u000f]%eA!AQ\u0005\u0001BC\u0002\u0013\u0005a%\u0001\u0004fq\u0016\u001c\u0017\nZ\u000b\u0002OA\u0011a\u0002K\u0005\u0003S=\u00111!\u00138u\u0011!Y\u0003A!A!\u0002\u00139\u0013aB3yK\u000eLE\r\t\u0005\t[\u0001\u0011)\u0019!C\u0001]\u00059\u0011\r\u001d9EKN\u001cW#A\u0018\u0011\u0005A\nT\"\u0001\u0003\n\u0005I\"!AF!qa2L7-\u0019;j_:$Um]2sSB$\u0018n\u001c8\t\u0011Q\u0002!\u0011!Q\u0001\n=\n\u0001\"\u00199q\t\u0016\u001c8\r\t\u0005\tm\u0001\u0011)\u0019!C\u0001M\u0005)1m\u001c:fg\"A\u0001\b\u0001B\u0001B\u0003%q%\u0001\u0004d_J,7\u000f\t\u0005\tu\u0001\u0011)\u0019!C\u0001M\u00051Q.Z7pefD\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006IaJ\u0001\b[\u0016lwN]=!\u0011!\u0019\u0001A!b\u0001\n\u0003qT#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0011a\u0001:qG&\u0011A)\u0011\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0011!1\u0005A!A!\u0002\u0013y\u0014aB<pe.,'\u000f\t\u0005\t\u0011\u0002\u0011)\u0019!C\u00015\u0005Aqo\u001c:lKJLE\r\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003\u001c\u0003%9xN]6fe&#\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u0011Awn\u001d;\t\u00119\u0003!\u0011!Q\u0001\nm\tQ\u0001[8ti\u0002B\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\tAJ\u0001\no\u0016\u0014W+\u001b)peRD\u0001B\u0015\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u000bo\u0016\u0014W+\u001b)peR\u0004\u0003\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u001bA,(\r\\5d\u0003\u0012$'/Z:t\u0011!1\u0006A!A!\u0002\u0013Y\u0012A\u00049vE2L7-\u00113ee\u0016\u001c8\u000f\t\u0005\t1\u0002\u0011)\u0019!C\u00013\u0006I1\u000f]1sW\"{W.Z\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0003S>T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\n!a)\u001b7f\u0011!\u0019\u0007A!A!\u0002\u0013Q\u0016AC:qCJ\\\u0007j\\7fA!AQ\r\u0001BC\u0002\u0013\u0005\u0011,A\u0006fq\u0016\u001cW\u000f^8s\t&\u0014\b\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\u0002\u0019\u0015DXmY;u_J$\u0015N\u001d\u0011\t\u0011%\u0004!Q1A\u0005\u0002i\t\u0011b^8sW\u0016\u0014XK\u001d7\t\u0011-\u0004!\u0011!Q\u0001\nm\t!b^8sW\u0016\u0014XK\u001d7!\u0011!i\u0007A!A!\u0002\u0013q\u0017\u0001B2p]\u001a\u0004\"\u0001F8\n\u0005A4!!C*qCJ\\7i\u001c8g\u0011!\u0011\bA!b\u0001\n\u0003\u0019\u0018\u0001D1qa2{7-\u00197ESJ\u001cX#\u0001;\u0011\u0007Ul8D\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u00110G\u0001\u0007yI|w\u000e\u001e \n\u0003AI!\u0001`\b\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?\u0010\u0011%\t\u0019\u0001\u0001B\u0001B\u0003%A/A\u0007baBdunY1m\t&\u00148\u000f\t\u0005\u000b\u0003\u000f\u0001!\u00111A\u0005\u0002\u0005%\u0011!B:uCR,WCAA\u0006!\u0011\ti!a\u0005\u000f\u0007A\ny!C\u0002\u0002\u0012\u0011\tQ\"\u0012=fGV$xN]*uCR,\u0017\u0002BA\u000b\u0003/\u0011QAV1mk\u0016L1!!\u0007\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u0015\u0005u\u0001A!a\u0001\n\u0003\ty\"A\u0005ti\u0006$Xm\u0018\u0013fcR!\u0011\u0011EA\u0014!\rq\u00111E\u0005\u0004\u0003Ky!\u0001B+oSRD!\"!\u000b\u0002\u001c\u0005\u0005\t\u0019AA\u0006\u0003\rAH%\r\u0005\u000b\u0003[\u0001!\u0011!Q!\n\u0005-\u0011AB:uCR,\u0007\u0005\u000b\u0003\u0002,\u0005E\u0002c\u0001\b\u00024%\u0019\u0011QG\b\u0003\u0011Y|G.\u0019;jY\u0016Dq!!\u000f\u0001\t\u0003\tY$\u0001\u0004=S:LGO\u0010\u000b#\u0003{\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013qKA-\u00037\ni&a\u0018\u0011\u0007\u0005}\u0002!D\u0001\u0003\u0011\u0019A\u0012q\u0007a\u00017!1Q%a\u000eA\u0002\u001dBa!LA\u001c\u0001\u0004y\u0003B\u0002\u001c\u00028\u0001\u0007q\u0005\u0003\u0004;\u0003o\u0001\ra\n\u0005\u0007\u0007\u0005]\u0002\u0019A \t\r!\u000b9\u00041\u0001\u001c\u0011\u0019a\u0015q\u0007a\u00017!1\u0001+a\u000eA\u0002\u001dBa\u0001VA\u001c\u0001\u0004Y\u0002B\u0002-\u00028\u0001\u0007!\f\u0003\u0004f\u0003o\u0001\rA\u0017\u0005\u0007S\u0006]\u0002\u0019A\u000e\t\r5\f9\u00041\u0001o\u0011\u0019\u0011\u0018q\u0007a\u0001i\"A\u0011qAA\u001c\u0001\u0004\tY\u0001C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f\u00051a-\u001e7m\u0013\u0012,\"!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001c_\u0003\u0011a\u0017M\\4\n\u0007\u0001\nY\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA4\u0003\u001d1W\u000f\u001c7JI\u0002B\u0011\"a\u001e\u0001\u0001\u0004%I!!\u001f\u0002\u0019]|'o[3s)\"\u0014X-\u00193\u0016\u0005\u0005m\u0004\u0003BA5\u0003{JA!a \u0002l\t1A\u000b\u001b:fC\u0012D\u0011\"a!\u0001\u0001\u0004%I!!\"\u0002!]|'o[3s)\"\u0014X-\u00193`I\u0015\fH\u0003BA\u0011\u0003\u000fC!\"!\u000b\u0002\u0002\u0006\u0005\t\u0019AA>\u0011!\tY\t\u0001Q!\n\u0005m\u0014!D<pe.,'\u000f\u00165sK\u0006$\u0007\u0005C\u0005\u0002\u0010\u0002\u0001\r\u0011\"\u0003\u0002\u0012\u00069\u0001O]8dKN\u001cXCAAJ!\u0011\tI'!&\n\t\u0005]\u00151\u000e\u0002\b!J|7-Z:t\u0011%\tY\n\u0001a\u0001\n\u0013\ti*A\u0006qe>\u001cWm]:`I\u0015\fH\u0003BA\u0011\u0003?C!\"!\u000b\u0002\u001a\u0006\u0005\t\u0019AAJ\u0011!\t\u0019\u000b\u0001Q!\n\u0005M\u0015\u0001\u00039s_\u000e,7o\u001d\u0011\t\u0013\u0005\u001d\u0006\u00011A\u0005\n\u0005%\u0016AD:uI>,H/\u00119qK:$WM]\u000b\u0003\u0003W\u0003B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,A\u0004m_\u001e<\u0017N\\4\u000b\u0007\u0005Uf!\u0001\u0003vi&d\u0017\u0002BA]\u0003_\u0013ABR5mK\u0006\u0003\b/\u001a8eKJD\u0011\"!0\u0001\u0001\u0004%I!a0\u0002%M$Hm\\;u\u0003B\u0004XM\u001c3fe~#S-\u001d\u000b\u0005\u0003C\t\t\r\u0003\u0006\u0002*\u0005m\u0016\u0011!a\u0001\u0003WC\u0001\"!2\u0001A\u0003&\u00111V\u0001\u0010gR$w.\u001e;BaB,g\u000eZ3sA!I\u0011\u0011\u001a\u0001A\u0002\u0013%\u0011\u0011V\u0001\u000fgR$WM\u001d:BaB,g\u000eZ3s\u0011%\ti\r\u0001a\u0001\n\u0013\ty-\u0001\nti\u0012,'O]!qa\u0016tG-\u001a:`I\u0015\fH\u0003BA\u0011\u0003#D!\"!\u000b\u0002L\u0006\u0005\t\u0019AAV\u0011!\t)\u000e\u0001Q!\n\u0005-\u0016aD:uI\u0016\u0014(/\u00119qK:$WM\u001d\u0011\t\u0013\u0005e\u0007\u00011A\u0005\n\u0005m\u0017\u0001D:ikR$wn\u001e8I_>\\W#A\u0007\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\u0018\u0001E:ikR$wn\u001e8I_>\\w\fJ3r)\u0011\t\t#a9\t\u0013\u0005%\u0012Q\\A\u0001\u0002\u0004i\u0001bBAt\u0001\u0001\u0006K!D\u0001\u000eg\",H\u000fZ8x]\"{wn\u001b\u0011\t\u0011\u0005-\b\u0001\"\u0001\u0003\u0003[\fQa\u001d;beR$\"!!\t\t\u000f\u0005E\b\u0001\"\u0003\u0002t\u0006Y1.\u001b7m!J|7-Z:t)\u0011\t\t#!>\t\u0011\u0005]\u0018q\u001ea\u0001\u0003s\fq!\\3tg\u0006<W\r\u0005\u0003\u000f\u0003w\\\u0012bAA\u007f\u001f\t1q\n\u001d;j_:D\u0001B!\u0001\u0001\t\u0003\u0011\u0011Q^\u0001\u0005W&dG\u000e\u0003\u0005\u0003\u0006\u0001!\tA\u0001B\u0004\u0003M\u0019XOY:uSR,H/\u001a,be&\f'\r\\3t)\rY\"\u0011\u0002\u0005\b\u0005\u0017\u0011\u0019\u00011\u0001\u001c\u0003!\t'oZ;nK:$\bb\u0002B\b\u0001\u0011%\u0011Q^\u0001\u0014M\u0016$8\r[!oIJ+h.\u0012=fGV$xN\u001d")
public class ExecutorRunner
implements Logging {
    private final String appId;
    private final int execId;
    private final ApplicationDescription appDesc;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef worker;
    private final String workerId;
    private final String host;
    private final int webUiPort;
    private final String publicAddress;
    private final File sparkHome;
    private final File executorDir;
    private final String workerUrl;
    private final SparkConf conf;
    private final Seq<String> appLocalDirs;
    private volatile Enumeration.Value state;
    private final String org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    private Thread workerThread;
    private Process process;
    private FileAppender stdoutAppender;
    private FileAppender stderrAppender;
    private Object shutdownHook;
    private transient Logger org$apache$spark$Logging$$log_;

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String appId() {
        return this.appId;
    }

    public int execId() {
        return this.execId;
    }

    public ApplicationDescription appDesc() {
        return this.appDesc;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerId() {
        return this.workerId;
    }

    public String host() {
        return this.host;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public File executorDir() {
        return this.executorDir;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public Seq<String> appLocalDirs() {
        return this.appLocalDirs;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public String org$apache$spark$deploy$worker$ExecutorRunner$$fullId() {
        return this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private FileAppender stdoutAppender() {
        return this.stdoutAppender;
    }

    private void stdoutAppender_$eq(FileAppender x$1) {
        this.stdoutAppender = x$1;
    }

    private FileAppender stderrAppender() {
        return this.stderrAppender;
    }

    private void stderrAppender_$eq(FileAppender x$1) {
        this.stderrAppender = x$1;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private void shutdownHook_$eq(Object x$1) {
        this.shutdownHook = x$1;
    }

    public void start() {
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ ExecutorRunner $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(new StringBuilder().append((Object)"ExecutorRunner for ").append((Object)$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).toString());
            }
        });
        this.workerThread().start();
        this.shutdownHook_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorRunner $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$killProcess((Option<String>)new Some((Object)"Worker shutting down"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public void org$apache$spark$deploy$worker$ExecutorRunner$$killProcess(Option<String> message) {
        None$ exitCode = None$.MODULE$;
        if (this.process() != null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Killing process!";
                }
            });
            if (this.stdoutAppender() != null) {
                this.stdoutAppender().stop();
            }
            if (this.stderrAppender() != null) {
                this.stderrAppender().stop();
            }
            this.process().destroy();
            exitCode = new Some((Object)BoxesRunTime.boxToInteger((int)this.process().waitFor()));
        }
        this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), message, (Option<Object>)exitCode));
    }

    public void kill() {
        if (this.workerThread() != null) {
            this.workerThread().interrupt();
            this.workerThread_$eq(null);
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            try {
                ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook());
            }
            catch (IllegalStateException illegalStateException) {
            }
        }
    }

    public String substituteVariables(String argument) {
        String string;
        String string2;
        String string3 = string2 = argument;
        if (!("{{WORKER_URL}}" != null ? !"{{WORKER_URL}}".equals(string3) : string3 != null)) {
            string = this.workerUrl();
        } else {
            String string4 = string2;
            if (!("{{EXECUTOR_ID}}" != null ? !"{{EXECUTOR_ID}}".equals(string4) : string4 != null)) {
                string = ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString();
            } else {
                String string5 = string2;
                if (!("{{HOSTNAME}}" != null ? !"{{HOSTNAME}}".equals(string5) : string5 != null)) {
                    string = this.host();
                } else {
                    String string6 = string2;
                    if (!("{{CORES}}" != null ? !"{{CORES}}".equals(string6) : string6 != null)) {
                        string = ((Object)BoxesRunTime.boxToInteger((int)this.cores())).toString();
                    } else {
                        String string7 = string2;
                        string = !("{{APP_ID}}" != null ? !"{{APP_ID}}".equals(string7) : string7 != null) ? this.appId() : string2;
                    }
                }
            }
        }
        return string;
    }

    public void org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor() {
        try {
            ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(this.appDesc().command(), new SecurityManager(this.conf), this.memory(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorRunner $outer;

                public final String apply(String argument) {
                    return this.$outer.substituteVariables(argument);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Seq<String>)((Seq)((TraversableLike)this.conf.getExecutorEnv().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> p) {
                    return ((String)p._1()).startsWith("extraClassPath");
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String b;
                        String string = b = (String)tuple2._2();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
            List<String> command = builder.command();
            String formattedCommand = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala()).mkString("\"", "\" \"", "\"");
            this.logInfo((Function0<String>)new Serializable(this, formattedCommand){
                public static final long serialVersionUID = 0L;
                private final String formattedCommand$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Launch command: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formattedCommand$1}));
                }
                {
                    this.formattedCommand$1 = formattedCommand$1;
                }
            });
            builder.directory(this.executorDir());
            builder.environment().put("SPARK_EXECUTOR_DIRS", this.appLocalDirs().mkString(File.pathSeparator));
            builder.environment().put("SPARK_LAUNCH_WITH_SCALA", "0");
            String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", ":", "/logPage/?appId=", "&executorId=", "&logType="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.publicAddress(), BoxesRunTime.boxToInteger((int)this.webUiPort()), this.appId(), BoxesRunTime.boxToInteger((int)this.execId())}));
            builder.environment().put("SPARK_LOG_URL_STDERR", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "stderr"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            builder.environment().put("SPARK_LOG_URL_STDOUT", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "stdout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
            this.process_$eq(builder.start());
            String header = new StringOps(Predef$.MODULE$.augmentString("Spark Executor Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formattedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
            File stdout = new File(this.executorDir(), "stdout");
            this.stdoutAppender_$eq(FileAppender$.MODULE$.apply(this.process().getInputStream(), stdout, this.conf));
            File stderr = new File(this.executorDir(), "stderr");
            Files.write((CharSequence)header, (File)stderr, (Charset)Charsets.UTF_8);
            this.stderrAppender_$eq(FileAppender$.MODULE$.apply(this.process().getErrorStream(), stderr, this.conf));
            int exitCode = this.process().waitFor();
            this.state_$eq(ExecutorState$.MODULE$.EXITED());
            String message = new StringBuilder().append((Object)"Command exited with code ").append((Object)BoxesRunTime.boxToInteger((int)exitCode)).toString();
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), (Option<String>)new Some((Object)message), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)exitCode))));
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error running executor";
                }
            }, exception2);
            this.state_$eq(ExecutorState$.MODULE$.FAILED());
            this.org$apache$spark$deploy$worker$ExecutorRunner$$killProcess((Option<String>)new Some((Object)exception2.toString()));
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorRunner $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Runner thread for executor ").append((Object)this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).append((Object)" interrupted").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            this.org$apache$spark$deploy$worker$ExecutorRunner$$killProcess((Option<String>)None$.MODULE$);
        }
    }

    public ExecutorRunner(String appId, int execId, ApplicationDescription appDesc, int cores, int memory, RpcEndpointRef worker, String workerId, String host, int webUiPort, String publicAddress, File sparkHome, File executorDir, String workerUrl, SparkConf conf, Seq<String> appLocalDirs, Enumeration.Value state) {
        this.appId = appId;
        this.execId = execId;
        this.appDesc = appDesc;
        this.cores = cores;
        this.memory = memory;
        this.worker = worker;
        this.workerId = workerId;
        this.host = host;
        this.webUiPort = webUiPort;
        this.publicAddress = publicAddress;
        this.sparkHome = sparkHome;
        this.executorDir = executorDir;
        this.workerUrl = workerUrl;
        this.conf = conf;
        this.appLocalDirs = appLocalDirs;
        this.state = state;
        Logging$class.$init$(this);
        this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId = new StringBuilder().append((Object)appId).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)execId)).toString();
        this.workerThread = null;
        this.process = null;
        this.stdoutAppender = null;
        this.stderrAppender = null;
        this.shutdownHook = null;
    }
}

