/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.r.BufferedStreamThread;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class RRDD$
implements Serializable {
    public static final RRDD$ MODULE$;
    private BufferedStreamThread errThread;
    private DataOutputStream daemonChannel;

    static {
        new RRDD$();
    }

    public JavaSparkContext createSparkContext(String master, String appName, String sparkHome, String[] jars, Map<Object, Object> sparkEnvirMap, Map<Object, Object> sparkExecutorEnvMap) {
        SparkConf sparkConf = new SparkConf().setAppName(appName).setSparkHome(sparkHome);
        String string = master;
        String string2 = "";
        SparkConf sparkConf2 = !(string != null ? !string.equals(string2) : string2 != null) ? sparkConf.setIfMissing("spark.master", "local") : sparkConf.setMaster(master);
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sparkEnvirMap).asScala()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;

            public final SparkConf apply(Tuple2<Object, Object> x$1) {
                Tuple2<Object, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    Object name = tuple2._1();
                    Object value = tuple2._2();
                    SparkConf sparkConf = this.sparkConf$1.set(name.toString(), value.toString());
                    return sparkConf;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
            }
        });
        ((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sparkExecutorEnvMap).asScala()).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;

            public final SparkConf apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    Object name = tuple2._1();
                    Object value = tuple2._2();
                    SparkConf sparkConf = this.sparkConf$1.setExecutorEnv(name.toString(), value.toString());
                    return sparkConf;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
            }
        });
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        Predef$.MODULE$.refArrayOps((Object[])jars).foreach((Function1)new Serializable(jsc){
            public static final long serialVersionUID = 0L;
            private final JavaSparkContext jsc$1;

            public final void apply(String jar) {
                this.jsc$1.addJar(jar);
            }
            {
                this.jsc$1 = jsc$1;
            }
        });
        return jsc;
    }

    /*
     * WARNING - void declaration
     */
    private BufferedStreamThread startStdoutThread(Process proc) {
        void var3_3;
        int BUFFER_SIZE = 100;
        BufferedStreamThread thread = new BufferedStreamThread(proc.getInputStream(), "stdout reader for R", BUFFER_SIZE);
        thread.setDaemon(true);
        thread.start();
        return var3_3;
    }

    private BufferedStreamThread createRProcess(int port, String script) {
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        String rCommand = sparkConf.get("spark.sparkr.r.command", "Rscript");
        rCommand = sparkConf.get("spark.r.command", rCommand);
        String rOptions = "--vanilla";
        String rLibDir = RUtils$.MODULE$.sparkRPackagePath(false);
        String rExecScript = new StringBuilder().append((Object)rLibDir).append((Object)"/SparkR/worker/").append((Object)script).toString();
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{rCommand, rOptions, rExecScript}));
        pb.environment().put("R_TESTS", "");
        pb.environment().put("SPARKR_RLIBDIR", rLibDir);
        pb.environment().put("SPARKR_WORKER_PORT", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedStreamThread errThread = this.startStdoutThread(proc);
        return errThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedStreamThread createRWorker(int port) {
        BufferedStreamThread bufferedStreamThread;
        boolean useDaemon = SparkEnv$.MODULE$.get().conf().getBoolean("spark.sparkr.use.daemon", true);
        if (!Utils$.MODULE$.isWindows() && useDaemon) {
            RRDD$ rRDD$ = this;
            synchronized (rRDD$) {
                if (this.daemonChannel == null) {
                    ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
                    int daemonPort = serverSocket.getLocalPort();
                    this.errThread = this.createRProcess(daemonPort, "daemon.R");
                    serverSocket.setSoTimeout(10000);
                    Socket sock = serverSocket.accept();
                    this.daemonChannel = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                    serverSocket.close();
                }
                this.liftedTree1$1(port);
                BufferedStreamThread bufferedStreamThread2 = this.errThread;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : rRDD$
                bufferedStreamThread = bufferedStreamThread2;
                return bufferedStreamThread;
            }
        }
        bufferedStreamThread = this.createRProcess(port, "worker.R");
        return bufferedStreamThread;
    }

    public JavaRDD<byte[]> createRDDFromArray(JavaSparkContext jsc, byte[][] arr) {
        return JavaRDD$.MODULE$.fromRDD(jsc.sc().parallelize(Predef$.MODULE$.wrapRefArray((Object[])arr), arr.length, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void liftedTree1$1(int port$1) {
        try {
            this.daemonChannel.writeInt(port$1);
            this.daemonChannel.flush();
            return;
        }
        catch (IOException iOException) {
            this.daemonChannel.close();
            this.daemonChannel = null;
            this.errThread = null;
            throw iOException;
        }
    }

    private RRDD$() {
        MODULE$ = this;
    }
}

