/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class JDBCExample$ {
    public static final JDBCExample$ MODULE$;

    static {
        new JDBCExample$();
    }

    public void doOperationsUsingJDBC(String hostPort) {
        Predef$.MODULE$.println((Object)"****JDBCExample****");
        Predef$.MODULE$.println((Object)"Initializing a JDBC connection");
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:snappydata://", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostPort}));
        Connection conn1 = DriverManager.getConnection(url);
        Statement stmt1 = conn1.createStatement();
        Predef$.MODULE$.println((Object)"Creating a table (PARTSUPP) using JDBC connection");
        stmt1.execute("DROP TABLE IF EXISTS APP.PARTSUPP");
        stmt1.execute("CREATE TABLE APP.PARTSUPP ( PS_PARTKEY     INTEGER NOT NULL PRIMARY KEY,PS_SUPPKEY     INTEGER NOT NULL,PS_AVAILQTY    INTEGER NOT NULL,PS_SUPPLYCOST  DECIMAL(15,2)  NOT NULL)USING ROW OPTIONS (PARTITION_BY 'PS_PARTKEY')");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Inserting a record in PARTSUPP table via batch inserts");
        PreparedStatement preparedStmt1 = conn1.prepareStatement("INSERT INTO APP.PARTSUPP VALUES(?, ?, ?, ?)");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)new Serializable(preparedStmt1){
            public static final long serialVersionUID = 0L;
            private final PreparedStatement preparedStmt1$1;

            public final void apply(int x) {
                this.apply$mcVI$sp(x);
            }

            public void apply$mcVI$sp(int x) {
                this.preparedStmt1$1.setInt(1, x * 100);
                this.preparedStmt1$1.setInt(2, x);
                this.preparedStmt1$1.setInt(3, x * 1000);
                this.preparedStmt1$1.setBigDecimal(4, BigDecimal.valueOf(100.2));
                this.preparedStmt1$1.addBatch();
            }
            {
                this.preparedStmt1$1 = preparedStmt1$1;
            }
        });
        preparedStmt1.executeBatch();
        preparedStmt1.close();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Inserting data in PARTSUPP table using statement");
        stmt1.execute("INSERT INTO APP.PARTSUPP VALUES(2000, 2, 50, 10)");
        stmt1.execute("INSERT INTO APP.PARTSUPP VALUES(3000, 3, 1000, 20)");
        stmt1.execute("INSERT INTO APP.PARTSUPP VALUES(4000, 4, 200, 30)");
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"The contents of PARTSUPP are");
        ResultSet rs1 = stmt1.executeQuery("SELECT * FROM APP.PARTSUPP");
        while (rs1.next()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append(rs1.getInt(1)).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs1.getInt(2))).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs1.getInt(3))).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs1.getInt(4))).toString());
        }
        rs1.close();
        stmt1.close();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Initializing another JDBC connection");
        Connection conn2 = DriverManager.getConnection(url);
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Displaying the the list of tables using second JDBC connection");
        DatabaseMetaData md = conn2.getMetaData();
        ResultSet rs2 = md.getTables(null, "APP", "%", null);
        while (rs2.next()) {
            Predef$.MODULE$.println((Object)rs2.getString(3));
        }
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"Selecting records of PARTSUPP from the second JDBC connection");
        Predef$.MODULE$.println((Object)"The contents of PARTSUPP are");
        ResultSet rs3 = conn2.createStatement().executeQuery("SELECT * FROM APP.PARTSUPP");
        while (rs3.next()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append(rs3.getInt(1)).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs3.getInt(2))).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs3.getInt(3))).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)rs3.getInt(4))).toString());
        }
        rs3.close();
        stmt1.close();
        conn1.close();
        conn2.close();
        Predef$.MODULE$.println((Object)"****Done****");
    }

    public void main(String[] args) {
        if (args.length > 1) {
            this.printUsage();
        } else if (args.length == 0) {
            Predef$.MODULE$.println((Object)"Using localhost:1527 for JDBC connection");
            this.doOperationsUsingJDBC("localhost:1527");
        } else if (args[0].split(":").length != 2) {
            this.printUsage();
        } else {
            this.doOperationsUsingJDBC(args[0]);
        }
    }

    public void printUsage() {
        String usage = "Usage: bin/run-example JDBCExample host:port\n\thost - SnappyData host that accepts JDBC connection\n\tport - port on which SnappyData host accepts JDBC connections\nIf host:port is not specified default host:port is assumed to be localhost:1527";
        Predef$.MODULE$.println((Object)usage);
    }

    private JDBCExample$() {
        MODULE$ = this;
    }
}

