/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import spark.jobserver.SparkJobValidation;

public final class CollocatedJoinExample$
implements SnappySQLJob {
    public static final CollocatedJoinExample$ MODULE$;

    static {
        new CollocatedJoinExample$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    public String getCurrentDirectory() {
        return new File(".").getCanonicalPath();
    }

    public Object runSnappyJob(SnappySession snSession, Config jobConfig) {
        PrintWriter pw = new PrintWriter("CollocatedJoinExample.out");
        this.runCollocatedJoinQuery(snSession, pw);
        pw.close();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check ", "/CollocatedJoinExample.out for output of this job"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory()}));
    }

    public SnappyJobValidation isValidJob(SnappySession sc, Config config) {
        return new SnappyJobValid();
    }

    public void runCollocatedJoinQuery(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Collocated Join Example****");
        pw.println("Creating a column table(CUSTOMER)");
        snSession.sql("DROP TABLE IF EXISTS CUSTOMER");
        snSession.sql("CREATE TABLE CUSTOMER ( C_CUSTKEY     INTEGER NOT NULL,C_NAME        VARCHAR(25) NOT NULL,C_ADDRESS     VARCHAR(40) NOT NULL,C_NATIONKEY   INTEGER NOT NULL,C_PHONE       VARCHAR(15) NOT NULL,C_ACCTBAL     DECIMAL(15,2)   NOT NULL,C_MKTSEGMENT  VARCHAR(10) NOT NULL,C_COMMENT     VARCHAR(117) NOT NULL)USING COLUMN OPTIONS (PARTITION_BY 'C_CUSTKEY')");
        snSession.sql("INSERT INTO CUSTOMER VALUES(20000, 'Customer20000', 'Chicago, IL', 1, '555-101-782', 3500, 'MKTSEGMENT', '')");
        snSession.sql("INSERT INTO CUSTOMER VALUES(30000, 'Customer30000', 'Boston, MA', 1, '555-151-678', 4500, 'MKTSEGMENT', '')");
        snSession.sql("INSERT INTO CUSTOMER VALUES(40000, 'Customer40000', 'San Jose, CA', 1, '555-532-345', 5500, 'MKTSEGMENT', '')");
        pw.println();
        pw.println("Creating a ORDERS table collocated with CUSTOMER");
        snSession.sql("DROP TABLE IF EXISTS ORDERS");
        snSession.sql("CREATE TABLE ORDERS  ( O_ORDERKEY       INTEGER NOT NULL,O_CUSTKEY        INTEGER NOT NULL,O_ORDERSTATUS    CHAR(1) NOT NULL,O_TOTALPRICE     DECIMAL(15,2) NOT NULL,O_ORDERDATE      DATE NOT NULL,O_ORDERPRIORITY  CHAR(15) NOT NULL,O_CLERK          CHAR(15) NOT NULL,O_SHIPPRIORITY   INTEGER NOT NULL,O_COMMENT        VARCHAR(79) NOT NULL) USING COLUMN OPTIONS (PARTITION_BY 'O_CUSTKEY', COLOCATE_WITH 'CUSTOMER' )");
        snSession.sql("INSERT INTO ORDERS VALUES (1, 20000, 'O', 100.50, '2016-04-04', 'LOW', 'Clerk#001', 3, '')");
        snSession.sql("INSERT INTO ORDERS VALUES (2, 20000, 'F', 1000, '2016-04-04', 'HIGH', 'Clerk#002', 1, '')");
        snSession.sql("INSERT INTO ORDERS VALUES (3, 30000, 'F', 400, '2016-04-04', 'MEDIUM', 'Clerk#003', 2, '')");
        snSession.sql("INSERT INTO ORDERS VALUES (4, 30000, 'O', 500, '2016-04-04', 'LOW', 'Clerk#002', 3, '')");
        pw.println("Selecting orders for all customers");
        Row[] result = snSession.sql("SELECT C_CUSTKEY, C_NAME, O_ORDERKEY, O_ORDERSTATUS, O_ORDERDATE, O_TOTALPRICE FROM CUSTOMER, ORDERS WHERE C_CUSTKEY = O_CUSTKEY").collect();
        pw.println("CUSTKEY, NAME, ORDERKEY, ORDERSTATUS, ORDERDATE, ORDERDATE");
        pw.println("____________________________________________________________");
        Predef$.MODULE$.refArrayOps((Object[])result).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        snSession.sql("DROP TABLE ORDERS");
        snSession.sql("DROP TABLE CUSTOMER");
        pw.println("****Done****");
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        Predef$.MODULE$.println((Object)"Creating a SnappySession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("CollocatedJoinExample").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        PrintWriter pw = new PrintWriter(System.out, true);
        this.runCollocatedJoinQuery(snSession, pw);
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private CollocatedJoinExample$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
    }
}

