/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.examples.snappydata.Address;
import org.apache.spark.examples.snappydata.Person;
import org.apache.spark.examples.snappydata.WorkingWithObjects$;
import org.apache.spark.sql.CachedDataFrame;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import spark.jobserver.SparkJobValidation;

public final class WorkingWithObjects$
implements SnappySQLJob {
    public static final WorkingWithObjects$ MODULE$;

    static {
        new WorkingWithObjects$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    public SnappyJobValidation isValidJob(SnappySession snSession, Config config) {
        return new SnappyJobValid();
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("WorkingWithObjects").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        Config config = ConfigFactory.parseString((String)"");
        this.runSnappyJob(snSession, config);
    }

    public Object runSnappyJob(SnappySession snSession, Config jobConfig) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.snappydata.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator2$1() {
            }
        }
        Dataset people = snSession.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Person[]{new Person("Tom", new Address("Columbus", "Ohio"), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frnd1"), (Object)"8998797979"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frnd2"), (Object)"09878786886")})))), new Person("Ned", new Address("San Diego", "California"), (Map<String, String>)Map$.MODULE$.empty())})), snSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator2$1()))).toDS();
        snSession.dropTable("Persons", true);
        snSession.sql("CREATE table Persons(name String, address Struct<city: String, state:String>, emergencyContacts Map<String,String>) using column options()");
        people.write().insertInto("Persons");
        Predef$.MODULE$.println((Object)"Print Schema of the table\n################");
        Predef$.MODULE$.println((Object)snSession.table("Persons").schema());
        Predef$.MODULE$.println();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.snappydata.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator4$1() {
            }
        }
        Dataset morePeople = snSession.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Person[]{new Person("Jon Snow", new Address("Columbus", "Ohio"), (Map<String, String>)Map$.MODULE$.empty()), new Person("Rob Stark", new Address("San Diego", "California"), (Map<String, String>)Map$.MODULE$.empty()), new Person("Michael", new Address("Null", "California"), (Map<String, String>)Map$.MODULE$.empty())})), snSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator4$1()))).toDS();
        morePeople.write().insertInto("Persons");
        CachedDataFrame nameAndAddress = snSession.sql("SELECT name, address, emergencyContacts FROM Persons");
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.snappydata.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator5$1() {
            }
        }
        Dataset allPersons = nameAndAddress.as(snSession.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_snappydata_WorkingWithObjects$$typecreator5$1())));
        allPersons.show();
        return BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private WorkingWithObjects$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
    }
}

