/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.examples.snappydata.CreateReplicatedRowTable;
import org.apache.spark.examples.snappydata.CreateReplicatedRowTable$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import spark.jobserver.SparkJobValidation;

public final class CreateReplicatedRowTable$
implements SnappySQLJob {
    public static final CreateReplicatedRowTable$ MODULE$;

    static {
        new CreateReplicatedRowTable$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    public String getCurrentDirectory() {
        return new File(".").getCanonicalPath();
    }

    public Object runSnappyJob(SnappySession snappySession, Config jobConfig) {
        PrintWriter pw = new PrintWriter("CreateReplicatedRowTable.out");
        this.createReplicatedRowTableUsingSQL(snappySession, pw);
        this.createReplicatedRowTableUsingAPI(snappySession, pw);
        pw.close();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check ", "/CreateReplicatedRowTable.out file for output of this job"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory()}));
    }

    public SnappyJobValidation isValidJob(SnappySession sc, Config config) {
        return new SnappyJobValid();
    }

    public void createReplicatedRowTableUsingAPI(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a row table(SUPPLIER) using API****");
        pw.println();
        snSession.dropTable("SUPPLIER", true);
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("S_SUPPKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_NAME", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_ADDRESS", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_NATIONKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_PHONE", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_ACCTBAL", (DataType)new DecimalType(15, 2), false, StructField$.MODULE$.apply$default$4()), new StructField("S_COMMENT", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
        Map props1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PERSISTENT"), (Object)"asynchronous")}));
        snSession.createTable("SUPPLIER", "row", schema, props1, snSession.createTable$default$5());
        pw.println("Inserting data in SUPPLIER table");
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "SUPPLIER1", "CHICAGO, IL", BoxesRunTime.boxToInteger((int)0), "555-543-789", package$.MODULE$.BigDecimal().apply(10000), " "})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "SUPPLIER2", "BOSTON, MA", BoxesRunTime.boxToInteger((int)0), "555-234-489", package$.MODULE$.BigDecimal().apply(20000), " "})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "SUPPLIER3", "NEWYORK, NY", BoxesRunTime.boxToInteger((int)0), "555-743-785", package$.MODULE$.BigDecimal().apply(34000), " "})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "SUPPLIER4", "SANHOSE, CA", BoxesRunTime.boxToInteger((int)0), "555-321-098", package$.MODULE$.BigDecimal().apply(1000), " "}))}));
        RDD rdd = snSession.sparkContext().parallelize(data, data.length(), ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CreateReplicatedRowTable.Data apply(Seq<Object> s) {
                return new CreateReplicatedRowTable.Data(BoxesRunTime.unboxToInt((Object)s.apply(0)), (String)s.apply(1), (String)s.apply(2), BoxesRunTime.unboxToInt((Object)s.apply(3)), (String)s.apply(4), (BigDecimal)s.apply(5), (String)s.apply(6));
            }
        }, ClassTag$.MODULE$.apply(CreateReplicatedRowTable.Data.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_snappydata_CreateReplicatedRowTable$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.snappydata.CreateReplicatedRowTable.Data").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_snappydata_CreateReplicatedRowTable$$typecreator1$1() {
            }
        }
        Dataset dataDF = snSession.createDataFrame(rdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_snappydata_CreateReplicatedRowTable$$typecreator1$1()));
        dataDF.write().insertInto("SUPPLIER");
        pw.println("Printing the contents of the SUPPLIER table");
        Row[] tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println();
        pw.println("Update the table account balance for SUPPLIER4");
        snSession.update("SUPPLIER", "S_NAME = 'SUPPLIER4'", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigDecimal().apply(50000)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"S_ACCTBAL"}));
        pw.println("Printing the contents of the SUPPLIER table after update");
        tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println();
        pw.println("Delete the records for SUPPLIER2 and SUPPLIER3");
        snSession.delete("SUPPLIER", "S_NAME = 'SUPPLIER2' OR S_NAME = 'SUPPLIER3'");
        pw.println("Printing the contents of the SUPPLIER table after delete");
        tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println("****Done****");
    }

    public void createReplicatedRowTableUsingSQL(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a row table using SQL****");
        pw.println();
        pw.println("Creating a row table(SUPPLIER) using SQL");
        snSession.sql("DROP TABLE IF EXISTS SUPPLIER");
        snSession.sql("CREATE TABLE SUPPLIER ( S_SUPPKEY INTEGER NOT NULL PRIMARY KEY, S_NAME STRING NOT NULL, S_ADDRESS STRING NOT NULL, S_NATIONKEY INTEGER NOT NULL, S_PHONE STRING NOT NULL, S_ACCTBAL DECIMAL(15, 2) NOT NULL, S_COMMENT STRING NOT NULL ) USING ROW OPTIONS (PERSISTENT 'asynchronous')");
        pw.println();
        pw.println("Inserting data in SUPPLIER table");
        snSession.sql("INSERT INTO SUPPLIER VALUES(1, 'SUPPLIER1', 'CHICAGO, IL', 0, '555-543-789', 10000, ' ')");
        snSession.sql("INSERT INTO SUPPLIER VALUES(2, 'SUPPLIER2', 'BOSTON, MA', 0, '555-234-489', 20000, ' ')");
        snSession.sql("INSERT INTO SUPPLIER VALUES(3, 'SUPPLIER3', 'NEWYORK, NY', 0, '555-743-785', 34000, ' ')");
        snSession.sql("INSERT INTO SUPPLIER VALUES(4, 'SUPPLIER4', 'SANHOSE, CA', 0, '555-321-098', 1000, ' ')");
        pw.println("Printing the contents of the SUPPLIER table");
        Row[] tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Update the table account balance for SUPPLIER4");
        snSession.sql("UPDATE SUPPLIER SET S_ACCTBAL = 50000 WHERE S_NAME = 'SUPPLIER4'");
        pw.println("Printing the contents of the SUPPLIER table after update");
        tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Delete the records for SUPPLIER2 and SUPPLIER3");
        snSession.sql("DELETE FROM SUPPLIER WHERE S_NAME = 'SUPPLIER2' OR S_NAME = 'SUPPLIER3'");
        pw.println("Printing the contents of the SUPPLIER table after delete");
        tableData = snSession.sql("SELECT * FROM SUPPLIER").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println("****Done****");
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        Predef$.MODULE$.println((Object)"Creating a SnappySession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("CreateReplicatedRowTable").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        PrintWriter pw = new PrintWriter(System.out, true);
        this.createReplicatedRowTableUsingSQL(snSession, pw);
        this.createReplicatedRowTableUsingAPI(snSession, pw);
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private CreateReplicatedRowTable$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
    }
}

