/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.examples.snappydata.CreatePartitionedRowTable;
import org.apache.spark.examples.snappydata.CreatePartitionedRowTable$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import spark.jobserver.SparkJobValidation;

public final class CreatePartitionedRowTable$
implements SnappySQLJob {
    public static final CreatePartitionedRowTable$ MODULE$;

    static {
        new CreatePartitionedRowTable$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    public String getCurrentDirectory() {
        return new File(".").getCanonicalPath();
    }

    public Object runSnappyJob(SnappySession snSession, Config jobConfig) {
        PrintWriter pw = new PrintWriter("CreatePartitionedRowTable.out");
        this.createPartitionedRowTableUsingSQL(snSession, pw);
        this.createPartitionedRowTableUsingAPI(snSession, pw);
        pw.close();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check ", "/CreatePartitionedRowTable.out file for output of this job"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory()}));
    }

    public SnappyJobValidation isValidJob(SnappySession sc, Config config) {
        return new SnappyJobValid();
    }

    public void createPartitionedRowTableUsingAPI(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a partitioned row table using API****");
        pw.println();
        pw.println("Creating a partitioned row table(PARTSUPP) using API");
        snSession.dropTable("PARTSUPP", true);
        StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("PS_PARTKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("S_SUPPKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("PS_AVAILQTY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("PS_SUPPLYCOST", (DataType)new DecimalType(15, 2), false, StructField$.MODULE$.apply$default$4())}));
        Map props1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PARTITION_BY"), (Object)"PS_PARTKEY")}));
        snSession.createTable("PARTSUPP", "row", schema, props1, snSession.createTable$default$5());
        pw.println("Inserting data in PARTSUPP table");
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)5000), package$.MODULE$.BigDecimal().apply(100)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)200), BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)50), package$.MODULE$.BigDecimal().apply(10)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)300), BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)1000), package$.MODULE$.BigDecimal().apply(20)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)400), BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)200), package$.MODULE$.BigDecimal().apply(30)}))}));
        RDD rdd = snSession.sparkContext().parallelize(data, data.length(), ClassTag$.MODULE$.apply(Seq.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CreatePartitionedRowTable.Data apply(Seq<Object> s) {
                return new CreatePartitionedRowTable.Data(BoxesRunTime.unboxToInt((Object)s.apply(0)), BoxesRunTime.unboxToInt((Object)s.apply(1)), BoxesRunTime.unboxToInt((Object)s.apply(2)), (BigDecimal)s.apply(3));
            }
        }, ClassTag$.MODULE$.apply(CreatePartitionedRowTable.Data.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_snappydata_CreatePartitionedRowTable$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.snappydata.CreatePartitionedRowTable.Data").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_snappydata_CreatePartitionedRowTable$$typecreator1$1() {
            }
        }
        Dataset dataDF = snSession.createDataFrame(rdd, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_snappydata_CreatePartitionedRowTable$$typecreator1$1()));
        dataDF.write().insertInto("PARTSUPP");
        pw.println("Printing the contents of the PARTSUPP table");
        Row[] tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println();
        pw.println("Update the available quantity for PARTKEY 100");
        snSession.update("PARTSUPP", "PS_PARTKEY = 100", Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)50000)})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PS_AVAILQTY"}));
        pw.println("Printing the contents of the PARTSUPP table after update");
        tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println();
        pw.println("Delete the records for PARTKEY 400");
        snSession.sql("DELETE FROM PARTSUPP WHERE PS_PARTKEY = 400");
        snSession.delete("PARTSUPP", "PS_PARTKEY = 400");
        pw.println("Printing the contents of the PARTSUPP table after delete");
        tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$2;

            public final void apply(Object x$1) {
                this.pw$2.println(x$1);
            }
            {
                this.pw$2 = pw$2;
            }
        });
        pw.println("****Done****");
    }

    public void createPartitionedRowTableUsingSQL(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Creating a partitioned row table(PARTSUPP) using SQL****");
        snSession.sql("DROP TABLE IF EXISTS PARTSUPP");
        snSession.sql("CREATE TABLE PARTSUPP ( PS_PARTKEY     INTEGER NOT NULL PRIMARY KEY,PS_SUPPKEY     INTEGER NOT NULL,PS_AVAILQTY    INTEGER NOT NULL,PS_SUPPLYCOST  DECIMAL(15,2)  NOT NULL)USING ROW OPTIONS (PARTITION_BY 'PS_PARTKEY' )");
        pw.println();
        pw.println("Inserting data in PARTSUPP table");
        snSession.sql("INSERT INTO PARTSUPP VALUES(100, 1, 5000, 100)");
        snSession.sql("INSERT INTO PARTSUPP VALUES(200, 2, 50, 10)");
        snSession.sql("INSERT INTO PARTSUPP VALUES(300, 3, 1000, 20)");
        snSession.sql("INSERT INTO PARTSUPP VALUES(400, 4, 200, 30)");
        pw.println("Printing the contents of the PARTSUPP table");
        Row[] tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Update the available quantity for PARTKEY 100");
        snSession.sql("UPDATE PARTSUPP SET PS_AVAILQTY = 50000 WHERE PS_PARTKEY = 100");
        pw.println("Printing the contents of the PARTSUPP table after update");
        tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Delete the records for PARTKEY 400");
        snSession.sql("DELETE FROM PARTSUPP WHERE PS_PARTKEY = 400");
        pw.println("Printing the contents of the PARTSUPP table after delete");
        tableData = snSession.sql("SELECT * FROM PARTSUPP").collect();
        Predef$.MODULE$.refArrayOps((Object[])tableData).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Object x$1) {
                this.pw$1.println(x$1);
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println("****Done****");
    }

    public void main(String[] args) {
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        Predef$.MODULE$.println((Object)"Creating a SnappySession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("CreatePartitionedRowTable").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        PrintWriter pw = new PrintWriter(System.out, true);
        this.createPartitionedRowTableUsingSQL(snSession, pw);
        this.createPartitionedRowTableUsingAPI(snSession, pw);
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private CreatePartitionedRowTable$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
    }
}

