/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.JavaSnappySQLJob;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappyJobInvalid;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaCreateAndLoadAirlineDataJob
extends JavaSnappySQLJob {
    private String airlinefilePath = null;
    private String airlinereftablefilePath = null;
    private static final String colTable = "AIRLINE";
    private static final String rowTable = "AIRLINEREF";
    private static final String sampleTable = "AIRLINE_SAMPLE";
    private static final String stagingAirline = "STAGING_AIRLINE";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object runSnappyJob(SnappySession snc, Config jobConfig) {
        try (PrintWriter pw = new PrintWriter("JavaCreateAndLoadAirlineDataJob.out");){
            String currentDirectory = new File(".").getCanonicalPath();
            snc.dropTable(sampleTable, true);
            snc.dropTable(colTable, true);
            snc.dropTable(rowTable, true);
            snc.dropTable(stagingAirline, true);
            pw.println("****** JavaCreateAndLoadAirlineDataJob ******");
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("path", this.airlinefilePath);
            Dataset airlineDF = snc.catalog().createExternalTable(stagingAirline, "parquet", props);
            StructType updatedSchema = JavaCreateAndLoadAirlineDataJob.replaceReservedWords(airlineDF.schema());
            HashMap<String, String> columnTableProps = new HashMap<String, String>();
            columnTableProps.put("buckets", "16");
            snc.createTable(colTable, "column", updatedSchema, columnTableProps, false);
            airlineDF.write().mode(SaveMode.Append).saveAsTable(colTable);
            pw.println("Created and imported data in $colTable table.");
            Dataset airlinerefDF = snc.read().load(this.airlinereftablefilePath);
            snc.createTable(rowTable, "row", airlinerefDF.schema(), Collections.emptyMap(), false);
            airlinerefDF.write().mode(SaveMode.Append).saveAsTable(rowTable);
            pw.println("Created and imported data in $rowTable table");
            HashMap<String, String> sampleTableProps = new HashMap<String, String>();
            sampleTableProps.put("buckets", "8");
            sampleTableProps.put("qcs", "UniqueCarrier, Year_, Month_");
            sampleTableProps.put("fraction", "0.03");
            sampleTableProps.put("strataReservoirSize", "50");
            snc.createSampleTable(sampleTable, "Airline", sampleTableProps, false);
            snc.table(colTable).write().mode(SaveMode.Append).saveAsTable(sampleTable);
            pw.println("Created and imported data in $sampleTable table.");
            pw.println("****** Job finished ******");
            String string = String.format("See %s/JavaCreateAndLoadAirlineDataJob.out", currentDirectory);
            return string;
        }
        catch (IOException ioe) {
            StringWriter sw = new StringWriter();
            PrintWriter spw = new PrintWriter(sw);
            spw.println("ERROR: failed with " + ioe);
            ioe.printStackTrace(spw);
            return spw.toString();
        }
    }

    public SnappyJobValidation isValidJob(SnappySession snc, Config config) {
        this.airlinefilePath = config.hasPath("airline_file") ? config.getString("airline_file") : "../../quickstart/data/airlineParquetData";
        if (!new File(this.airlinefilePath).exists()) {
            return new SnappyJobInvalid("Incorrect airline path. Specify airline_file property in APP_PROPS");
        }
        this.airlinereftablefilePath = config.hasPath("airlineref_file") ? config.getString("airlineref_file") : "../../quickstart/data/airportcodeParquetData";
        if (!new File(this.airlinereftablefilePath).exists()) {
            return new SnappyJobInvalid("Incorrect airline ref path. Specify airlineref_file property in APP_PROPS");
        }
        return new SnappyJobValid();
    }

    private static StructType replaceReservedWords(StructType airlineSchema) {
        StructField[] fields = airlineSchema.fields();
        StructField[] newFields = new StructField[fields.length];
        for (StructField s : fields) {
            StructField newField = s.name().equals("Year") ? new StructField("Year_", s.dataType(), s.nullable(), s.metadata()) : (s.name().equals("Month") ? new StructField("Month_", s.dataType(), s.nullable(), s.metadata()) : s);
            newFields[airlineSchema.indexOf((Object)s)] = newField;
        }
        return new StructType(newFields);
    }
}

