/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappyContext;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaAirlineDataJob {
    private static String airlinefilePath = "quickstart/data/airlineParquetData";
    private static String airlinereftablefilePath = "quickstart/data/airportcodeParquetData";
    private static final String colTable = "AIRLINE";
    private static final String rowTable = "AIRLINEREF";
    private static final String sampleTable = "AIRLINE_SAMPLE";
    private static final String stagingAirline = "STAGING_AIRLINE";

    public static void main(String[] args) throws Exception {
        SparkConf sparkConf = new SparkConf().setAppName("JavaSparkSQL").setMaster("local[2]");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        SnappyContext snc = SnappyContext.apply((JavaSparkContext)jsc);
        snc.dropTable(colTable, true);
        snc.dropTable(rowTable, true);
        snc.dropTable(sampleTable, true);
        snc.dropTable(stagingAirline, true);
        System.out.println("****** CreateAndLoadAirlineDataJob ******");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", airlinefilePath);
        Dataset airlineDF = snc.createExternalTable(stagingAirline, "parquet", options);
        StructType updatedSchema = JavaAirlineDataJob.replaceReservedWords(airlineDF.schema());
        options.clear();
        options.put("buckets", "16");
        snc.createTable(colTable, "column", updatedSchema, options, false);
        airlineDF.write().mode(SaveMode.Append).saveAsTable(colTable);
        System.out.println("Created and imported data in AIRLINE table.");
        Dataset airlinerefDF = snc.read().load(airlinereftablefilePath);
        snc.createTable(rowTable, "row", airlinerefDF.schema(), Collections.emptyMap(), false);
        airlinerefDF.write().mode(SaveMode.Append).saveAsTable(rowTable);
        System.out.println(String.format("Created and imported data in %s table", rowTable));
        options.clear();
        options.put("buckets", "8");
        options.put("qcs", "UniqueCarrier, Year_, Month_");
        options.put("fraction", "0.03");
        options.put("strataReservoirSize", "50");
        snc.createSampleTable(sampleTable, "Airline", options, false);
        snc.table(colTable).write().insertInto(sampleTable);
        System.out.println(String.format("Created and imported data in %s table.", sampleTable));
        System.out.println("****** Job finished ******");
    }

    private static StructType replaceReservedWords(StructType airlineSchema) {
        StructField[] fields = airlineSchema.fields();
        StructField[] newFields = new StructField[fields.length];
        for (StructField s : fields) {
            StructField newField = null;
            newField = s.name().equals("Year") ? new StructField("Year_", s.dataType(), s.nullable(), s.metadata()) : (s.name().equals("Month") ? new StructField("Month_", s.dataType(), s.nullable(), s.metadata()) : s);
            newFields[airlineSchema.indexOf((Object)s)] = newField;
        }
        return new StructType(newFields);
    }
}

