/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SnappyJobInvalid;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.util.Try$;
import spark.jobserver.SparkJobValidation;

public final class SynopsisDataExample$
implements SnappySQLJob {
    public static final SynopsisDataExample$ MODULE$;
    private String dataFolder;

    static {
        new SynopsisDataExample$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    private String dataFolder() {
        return this.dataFolder;
    }

    private void dataFolder_$eq(String x$1) {
        this.dataFolder = x$1;
    }

    public String getCurrentDirectory() {
        return new File(".").getCanonicalPath();
    }

    public Object runSnappyJob(SnappySession snappySession, Config jobConfig) {
        PrintWriter pw = new PrintWriter("SynopsisDataExample.out");
        this.dataFolder_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobConfig.getString("data_resource_folder")})));
        this.runSynopsisDataExample(snappySession, pw);
        pw.close();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check ", "/SynopsisDataExample.out file for output of this job"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory()}));
    }

    public SnappyJobValidation isValidJob(SnappySession snappySession, Config config) {
        return (SnappyJobValidation)Try$.MODULE$.apply((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply() {
                return this.config$1.getString("data_resource_folder");
            }
            {
                this.config$1 = config$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobValid apply(String x) {
                return new SnappyJobValid();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobInvalid apply() {
                return new SnappyJobInvalid("No data_resource_folder config param");
            }
        });
    }

    public void runSynopsisDataExample(SnappySession snSession, PrintWriter pw) {
        pw.println("****Synopsis Data Example****");
        snSession.sql("DROP TABLE IF EXISTS STAGING_AIRLINE");
        snSession.sql("DROP TABLE IF EXISTS AIRLINE_SAMPLE");
        snSession.sql("DROP TABLE IF EXISTS AIRLINE");
        snSession.sql(new StringBuilder().append((Object)"CREATE EXTERNAL TABLE STAGING_AIRLINE USING parquet OPTIONS(path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "/airlineParquetData')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()}))).toString());
        pw.println("Create a column table AIRLINE");
        snSession.sql("CREATE TABLE AIRLINE USING column AS (SELECT Year AS Year_, Month AS Month_ , DayOfMonth, DayOfWeek, DepTime, CRSDepTime, ArrTime, CRSArrTime, UniqueCarrier, FlightNum, TailNum, ActualElapsedTime, CRSElapsedTime, AirTime, ArrDelay, DepDelay, Origin, Dest, Distance, TaxiIn, TaxiOut, Cancelled, CancellationCode, Diverted, CarrierDelay, WeatherDelay, NASDelay, SecurityDelay, LateAircraftDelay, ArrDelaySlot FROM STAGING_AIRLINE)");
        pw.println("Creating a sample table from AIRLINE table");
        snSession.sql("CREATE SAMPLE TABLE AIRLINE_SAMPLE ON AIRLINE OPTIONS(qcs 'UniqueCarrier, Year_, Month_', fraction '0.03')  AS (SELECT Year_, Month_ , DayOfMonth, DayOfWeek, DepTime, CRSDepTime, ArrTime, CRSArrTime, UniqueCarrier, FlightNum, TailNum, ActualElapsedTime, CRSElapsedTime, AirTime, ArrDelay, DepDelay, Origin, Dest, Distance, TaxiIn, TaxiOut, Cancelled, CancellationCode, Diverted, CarrierDelay, WeatherDelay, NASDelay, SecurityDelay, LateAircraftDelay, ArrDelaySlot FROM AIRLINE)");
        pw.println();
        pw.println("Creating a reference table AIRLINEREF");
        snSession.sql("DROP TABLE IF EXISTS STAGING_AIRLINEREF");
        snSession.sql("DROP TABLE IF EXISTS AIRLINEREF");
        snSession.sql(new StringBuilder().append((Object)"CREATE EXTERNAL TABLE STAGING_AIRLINEREF USING parquet OPTIONS(path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "/airportcodeParquetData')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()}))).toString());
        snSession.sql("CREATE TABLE AIRLINEREF USING row AS (SELECT CODE, DESCRIPTION FROM STAGING_AIRLINEREF)");
        pw.println();
        pw.println("Executing approaximate queries");
        pw.println();
        pw.println("Which airline had the most flights each year?");
        Row[] result = snSession.sql("select  count(*) flightRecCount, description AirlineName, UniqueCarrier carrierCode ,Year_ from airline , airlineref where airline.UniqueCarrier = airlineref.code group by UniqueCarrier,description, Year_ order by flightRecCount desc limit 10 with error 0.20").collect();
        pw.println("FlightRecCount, AirlineName, Carrier, Year");
        pw.println("-----------------------------------------------");
        Predef$.MODULE$.refArrayOps((Object[])result).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Row r) {
                this.pw$1.println(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(r.apply(0)), ", ")).append(r.apply(1)).append((Object)", ").append(r.apply(2)).append((Object)", ").append(r.apply(3)).toString());
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Which Airlines Arrive On Schedule?");
        result = snSession.sql("select AVG(ArrDelay) arrivalDelay, relative_error(arrivalDelay) rel_err, UniqueCarrier carrier from airline group by UniqueCarrier order by arrivalDelay with error").collect();
        pw.println("ArrivalDelay, Relative_error, Carrier");
        pw.println("-------------------------------------");
        Predef$.MODULE$.refArrayOps((Object[])result).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Row r) {
                this.pw$1.println(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(r.apply(0)), ", ")).append(r.apply(1)).append((Object)", ").append(r.apply(2)).toString());
            }
            {
                this.pw$1 = pw$1;
            }
        });
        pw.println();
        pw.println("Which Airlines Arrive On Schedule? JOIN with reference table?");
        result = snSession.sql("select AVG(ArrDelay) arrivalDelay, relative_error(arrivalDelay) rel_err, description AirlineName, UniqueCarrier carrier from airline, airlineref where airline.UniqueCarrier = airlineref.Code group by UniqueCarrier, description order by arrivalDelay with error").collect();
        pw.println("ArrivalDelay,  Relative_error,  AirlineName,  Carrier");
        pw.println("-----------------------------------------------------");
        Predef$.MODULE$.refArrayOps((Object[])result).foreach((Function1)new Serializable(pw){
            public static final long serialVersionUID = 0L;
            private final PrintWriter pw$1;

            public final void apply(Row r) {
                this.pw$1.println(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(r.apply(0)), ", ")).append(r.apply(1)).append((Object)", ").append(r.apply(2)).append((Object)", ").append(r.apply(3)).toString());
            }
            {
                this.pw$1 = pw$1;
            }
        });
    }

    public void main(String[] args) {
        this.parseArgs(args);
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        Predef$.MODULE$.println((Object)"Creating a SnappySession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("SynopsisDataExample").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        PrintWriter pw = new PrintWriter(System.out, true);
        this.runSynopsisDataExample(snSession, pw);
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private void parseArgs(String[] args) {
        if (args.length != 1) {
            this.printUsage();
            System.exit(1);
        }
        this.dataFolder_$eq(args[0]);
    }

    private void printUsage() {
        String usage = "Usage: SynopsisDataExample <dataFolderPath> \n\ndataFolderPath - (string) local folder where data files airlineParquetData and airportcodeParquetData are located\n";
        Predef$.MODULE$.println((Object)usage);
    }

    private SynopsisDataExample$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
        this.dataFolder = "";
    }
}

