/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import com.typesafe.config.Config;
import io.snappydata.examples.AirlineDataJob$;
import java.io.File;
import java.io.PrintWriter;
import org.apache.spark.sql.AQPDataFrame;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.snappy$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spark.jobserver.SparkJobValidation;

public final class AirlineDataJob$
implements SnappySQLJob {
    public static final AirlineDataJob$ MODULE$;

    static {
        new AirlineDataJob$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    /*
     * WARNING - void declaration
     */
    public Object runSnappyJob(SnappySession snc, Config jobConfig) {
        String colTable = "AIRLINE";
        String parquetTable = "STAGING_AIRLINE";
        String rowTable = "AIRLINEREF";
        String sampleTable = "AIRLINE_SAMPLE";
        PrintWriter pw = new PrintWriter("AirlineDataJob.out");
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(snc, colTable, parquetTable, rowTable, sampleTable, pw){
            public static final long serialVersionUID = 0L;
            private final SnappySession snc$1;
            private final String colTable$1;
            private final String parquetTable$1;
            private final String rowTable$1;
            private final String sampleTable$1;
            public final PrintWriter pw$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.snc$1.sql("set spark.sql.shuffle.partitions=6");
                Dataset airlineDF = this.snc$1.table(this.colTable$1);
                Dataset airlineCodeDF = this.snc$1.table(this.rowTable$1);
                Dataset airlineParquetDF = this.snc$1.table(this.parquetTable$1);
                Dataset sampleDF = this.snc$1.table(this.sampleTable$1);
                airlineParquetDF.cache();
                airlineParquetDF.count();
                Dataset actualResult = airlineDF.join(airlineCodeDF, airlineDF.col("UniqueCarrier").equalTo((Object)airlineCodeDF.apply("CODE"))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{airlineDF.apply("UniqueCarrier"), airlineCodeDF.apply("DESCRIPTION")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("avg(ArrDelay)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                long start = System.currentTimeMillis();
                Row[] result = (Row[])actualResult.collect();
                long totalTime = System.currentTimeMillis() - start;
                this.pw$1.println(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"****** Query Execution on Airline Snappy "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table took ", "ms ******"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTime)}))).toString());
                Predef$.MODULE$.refArrayOps((Object[])result).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final void apply(Row rs) {
                        this.$outer.pw$1.println(rs.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Dataset parquetResult = airlineParquetDF.join(airlineCodeDF, airlineParquetDF.col("UniqueCarrier").equalTo((Object)airlineCodeDF.apply("CODE"))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{airlineParquetDF.apply("UniqueCarrier"), airlineCodeDF.apply("DESCRIPTION")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("avg(ArrDelay)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                long startP = System.currentTimeMillis();
                Row[] resultP = (Row[])parquetResult.collect();
                long totalTimeP = System.currentTimeMillis() - startP;
                this.pw$1.println(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n****** Query Execution on Airline Spark "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table took ", "ms******"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTimeP)}))).toString());
                Predef$.MODULE$.refArrayOps((Object[])resultP).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final void apply(Row rs) {
                        this.$outer.pw$1.println(rs.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Dataset sampleResult = sampleDF.join(airlineCodeDF, sampleDF.col("UniqueCarrier").equalTo((Object)airlineCodeDF.apply("CODE"))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{sampleDF.apply("UniqueCarrier"), airlineCodeDF.apply("DESCRIPTION")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("avg(ArrDelay)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                long startS = System.currentTimeMillis();
                Row[] resultS = (Row[])sampleResult.collect();
                long totalTimeS = System.currentTimeMillis() - startS;
                this.pw$1.println(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n****** Query Execution on Airline Sample "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table took ", "ms******"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTimeS)}))).toString());
                Predef$.MODULE$.refArrayOps((Object[])resultS).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final void apply(Row rs) {
                        this.$outer.pw$1.println(rs.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                AQPDataFrame qual$1 = snappy$.MODULE$.convertToAQPFrame(airlineDF.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{airlineDF.apply("Year_")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("Year_", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
                double x$1 = 0.2;
                double x$2 = 0.8;
                String x$3 = qual$1.withError$default$3();
                Dataset sampleBaseTableResult = qual$1.withError(x$1, x$2, x$3);
                long startSB = System.currentTimeMillis();
                Row[] resultSB = (Row[])sampleBaseTableResult.collect();
                long totalTimeSB = System.currentTimeMillis() - startSB;
                this.pw$1.println(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n****** Query Execution with sampling on "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Airline table took ", "ms******"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTimeSB)}))).toString());
                Predef$.MODULE$.refArrayOps((Object[])resultSB).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final void apply(Row rs) {
                        this.$outer.pw$1.println(rs.toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.snc$1 = snc$1;
                this.colTable$1 = colTable$1;
                this.parquetTable$1 = parquetTable$1;
                this.rowTable$1 = rowTable$1;
                this.sampleTable$1 = sampleTable$1;
                this.pw$1 = pw$1;
            }
        });
        if (try_ instanceof Success) {
            pw.close();
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"See ", "/AirlineDataJob.out"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory$1()}));
            return string;
        }
        if (try_ instanceof Failure) {
            void var7_7;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            var7_7.close();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public SnappyJobValidation isValidJob(SnappySession sc, Config config) {
        return new SnappyJobValid();
    }

    private final String getCurrentDirectory$1() {
        return new File(".").getCanonicalPath();
    }

    private AirlineDataJob$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
    }
}

