/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.CachedDataFrame;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SnappyJobInvalid;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.util.Try$;
import spark.jobserver.SparkJobValidation;

public final class WorkingWithJson$
implements SnappySQLJob {
    public static final WorkingWithJson$ MODULE$;
    private final int NPARAMS;
    private String jsonFolder;

    static {
        new WorkingWithJson$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    private int NPARAMS() {
        return this.NPARAMS;
    }

    private String jsonFolder() {
        return this.jsonFolder;
    }

    private void jsonFolder_$eq(String x$1) {
        this.jsonFolder = x$1;
    }

    public SnappyJobValidation isValidJob(SnappySession sc, Config config) {
        return (SnappyJobValidation)Try$.MODULE$.apply((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply() {
                return this.config$1.getString("json_resource_folder");
            }
            {
                this.config$1 = config$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobValid apply(String x) {
                return new SnappyJobValid();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobInvalid apply() {
                return new SnappyJobInvalid("No json_resource_folder config param");
            }
        });
    }

    public Object runSnappyJob(SnappySession snSession, Config jobConfig) {
        String some_people_path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/some_people.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobConfig.getString("json_resource_folder")}));
        Dataset people = snSession.read().json(some_people_path);
        people.printSchema();
        snSession.dropTable("people", true);
        snSession.createTable("people", "column", people.schema(), Predef$.MODULE$.Map().empty(), false);
        people.write().insertInto("people");
        String more_people_path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/more_people.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobConfig.getString("json_resource_folder")}));
        Dataset morePeople = snSession.read().schema(people.schema()).json(more_people_path);
        morePeople.write().insertInto("people");
        Predef$.MODULE$.println((Object)"Print Schema of the table\n################");
        Predef$.MODULE$.println((Object)snSession.table("people").schema());
        Predef$.MODULE$.println();
        CachedDataFrame nameAndAddress = snSession.sql("SELECT name, address.city, address.state, address.district, address.lane FROM people");
        StringBuilder builder = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])nameAndAddress.collect()).map((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final StringBuilder builder$1;

            public final StringBuilder apply(Row row) {
                this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.apply(0)})));
                this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.apply(1)})));
                this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.apply(2)})));
                this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.apply(3)})));
                return this.builder$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " \\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.apply(4)})));
            }
            {
                this.builder$1 = builder$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StringBuilder.class)));
        return builder.toString();
    }

    public void main(String[] args) {
        this.parseArgs(args);
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("WorkingWithJson").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"json_resource_folder=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonFolder()})));
        Object results = this.runSnappyJob(snSession, config);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Printing All People \n################## \n").append(results).toString());
        spark.stop();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private void parseArgs(String[] args) {
        if (args.length != this.NPARAMS()) {
            this.printUsage();
            System.exit(1);
        }
        this.jsonFolder_$eq(args[0]);
    }

    private void printUsage() {
        String usage = "Usage: WorkingWithJson <jsonFolderPath> \n\njsonFolderPath - (string) local folder where some_people.json & more_people.json are located\n";
        Predef$.MODULE$.println((Object)usage);
    }

    private WorkingWithJson$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
        this.NPARAMS = 1;
        this.jsonFolder = "";
    }
}

