/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.pivotal.gemfirexd.snappy.ComplexTypeSerializer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.Try$;

public final class JDBCWithComplexTypes$ {
    public static final JDBCWithComplexTypes$ MODULE$;
    private final String tableName;

    static {
        new JDBCWithComplexTypes$();
    }

    public String tableName() {
        return this.tableName;
    }

    public void createTableWithComplexType(Connection conn) {
        Statement stmt = conn.createStatement();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a table ", " using JDBC connection"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})));
        stmt.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})));
        stmt.execute(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        CREATE TABLE ", " (\n          col1 Int,\n          col2 Array<Decimal>\n        ) USING column options()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})));
    }

    public void doInsertComplexType(Connection conn) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inserting a single row having a a complex type ..."})).s((Seq)Nil$.MODULE$));
        Decimal[] arrDecimal = (Decimal[])((Object[])new Decimal[]{Decimal$.MODULE$.apply("4.92"), Decimal$.MODULE$.apply("51.98")});
        PreparedStatement pstmt = conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"insert into ", " values (?, ?)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})));
        ComplexTypeSerializer serializer1 = ComplexTypeSerializer.create((String)this.tableName(), (String)"col2", (Connection)conn);
        pstmt.setInt(1, 1);
        pstmt.setBytes(2, serializer1.serialize((Object)arrDecimal));
        pstmt.execute();
        pstmt.close();
    }

    public void readComplexType(Connection conn) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading results as  BLOB and Bytes ..."})).s((Seq)Nil$.MODULE$));
        Statement stmt = conn.createStatement();
        ComplexTypeSerializer serializer = ComplexTypeSerializer.create((String)this.tableName(), (String)"col2", (Connection)conn);
        ResultSet rs = stmt.executeQuery(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})));
        while (rs.next()) {
            Object res1 = serializer.deserialize(rs.getBytes(2));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"res1 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res1})));
            Object res2 = serializer.deserialize(rs.getBytes("col2"));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"res2 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res2})));
            Object res3 = serializer.deserialize((Blob)rs.getObject("col2"));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"res3 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res3})));
            Object res4 = serializer.deserialize(rs.getBlob("col2"));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"res4 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res4})));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doOperationsUsingJDBC(String clientPort) {
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:snappydata://localhost:", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientPort}));
        Connection conn = DriverManager.getConnection(url);
        try {
            this.createTableWithComplexType(conn);
            this.doInsertComplexType(conn);
            this.readComplexType(conn);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        conn.close();
    }

    public void main(String[] args) {
        if (args.length > 1) {
            this.printUsage();
        } else if (args.length == 0) {
            Predef$.MODULE$.println((Object)"Using default client port 1527 for JDBC connection");
            this.doOperationsUsingJDBC("1527");
        } else if (Try$.MODULE$.apply((Function0)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.args$1[0])).toInt();
            }
            {
                this.args$1 = args$1;
            }
        }).isFailure()) {
            this.printUsage();
        } else {
            this.doOperationsUsingJDBC(args[0]);
        }
    }

    public void printUsage() {
        String usage = "Usage: bin/run-example JDBCWithComplexTypes <clientPort>\n\nclientPort - client port number for SnappyData on which JDBC connections are accepted \n";
        Predef$.MODULE$.println((Object)usage);
    }

    private JDBCWithComplexTypes$() {
        MODULE$ = this;
        this.tableName = "TABLE_WITH_COMPLEX_TYPES";
    }
}

