/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.snappydata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.PrintWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SnappyJobInvalid;
import org.apache.spark.sql.SnappyJobValid;
import org.apache.spark.sql.SnappyJobValidation;
import org.apache.spark.sql.SnappySQLJob;
import org.apache.spark.sql.SnappySession;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.util.Try$;
import spark.jobserver.SparkJobValidation;

public final class CreateColumnTable$
implements SnappySQLJob {
    public static final CreateColumnTable$ MODULE$;
    private String dataFolder;

    static {
        new CreateColumnTable$();
    }

    public final SparkJobValidation validate(Object sc, Config config) {
        return SnappySQLJob.class.validate((SnappySQLJob)this, (Object)sc, (Config)config);
    }

    public final Object runJob(Object sc, Config jobConfig) {
        return SnappySQLJob.class.runJob((SnappySQLJob)this, (Object)sc, (Config)jobConfig);
    }

    private String dataFolder() {
        return this.dataFolder;
    }

    private void dataFolder_$eq(String x$1) {
        this.dataFolder = x$1;
    }

    public String getCurrentDirectory() {
        return new File(".").getCanonicalPath();
    }

    public Object runSnappyJob(SnappySession snappySession, Config jobConfig) {
        PrintWriter pw = new PrintWriter("CreateColumnTable.out");
        this.dataFolder_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobConfig.getString("data_resource_folder")})));
        this.createColumnTableUsingAPI(snappySession, pw);
        this.createColumnTableUsingSQL(snappySession, pw);
        this.createColumnTableInferredSchema(snappySession, pw);
        pw.close();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check ", "/CreateColumnTable.out for output of this job"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getCurrentDirectory()}));
    }

    public SnappyJobValidation isValidJob(SnappySession snappySession, Config config) {
        return (SnappyJobValidation)Try$.MODULE$.apply((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply() {
                return this.config$1.getString("data_resource_folder");
            }
            {
                this.config$1 = config$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobValid apply(String x) {
                return new SnappyJobValid();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SnappyJobInvalid apply() {
                return new SnappyJobInvalid("No data_resource_folder config param");
            }
        });
    }

    public void createColumnTableUsingAPI(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a column table using API****");
        pw.println();
        pw.println("Creating a column table(CUSTOMER) using API");
        snSession.dropTable("CUSTOMER", true);
        StructType tableSchema = new StructType((StructField[])((Object[])new StructField[]{new StructField("C_CUSTKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_NAME", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_ADDRESS", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_NATIONKEY", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_PHONE", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_ACCTBAL", (DataType)new DecimalType(15, 2), false, StructField$.MODULE$.apply$default$4()), new StructField("C_MKTSEGMENT", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("C_COMMENT", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
        scala.collection.immutable.Map props1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PARTITION_BY"), (Object)"C_CUSTKEY")}));
        snSession.createTable("CUSTOMER", "column", tableSchema, props1, snSession.createTable$default$5());
        pw.println();
        pw.println("Loading data in CUSTOMER table from a text file with delimited columns");
        Dataset customerDF = snSession.read().format("com.databricks.spark.csv").schema(tableSchema).load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/customer.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()})));
        customerDF.write().insertInto("CUSTOMER");
        pw.println();
        Row[] result = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table after loading data are ").append(result[0].get(0)).toString());
        pw.println();
        pw.println("Inserting a row using INSERT SQL");
        snSession.sql("INSERT INTO CUSTOMER VALUES(20000, 'Customer20000', 'Chicago, IL', 1, '555-101-782', 3500, 'MKTSEGMENT', '')");
        pw.println();
        result = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table are ").append(result[0].get(0)).toString());
        pw.println("****Done****");
    }

    public void createColumnTableUsingSQL(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a column table using SQL****");
        pw.println();
        pw.println("Creating a column table(CUSTOMER) using SQL");
        snSession.sql("DROP TABLE IF EXISTS CUSTOMER");
        snSession.sql("CREATE TABLE CUSTOMER ( C_CUSTKEY     INTEGER NOT NULL,C_NAME        VARCHAR(25) NOT NULL,C_ADDRESS     VARCHAR(40) NOT NULL,C_NATIONKEY   INTEGER NOT NULL,C_PHONE       VARCHAR(15) NOT NULL,C_ACCTBAL     DECIMAL(15,2)   NOT NULL,C_MKTSEGMENT  VARCHAR(10) NOT NULL,C_COMMENT     VARCHAR(117) NOT NULL)USING COLUMN OPTIONS (PARTITION_BY 'C_CUSTKEY', BUCKETS '11' )");
        pw.println();
        pw.println("Loading data in CUSTOMER table from a text file with delimited columns");
        StructType tableSchema = snSession.table("CUSTOMER").schema();
        Dataset customerDF = snSession.read().schema(tableSchema).csv(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/customer.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()})));
        customerDF.write().insertInto("CUSTOMER");
        pw.println();
        Row[] result = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table after loading data are ").append(result[0].get(0)).toString());
        pw.println();
        pw.println("Inserting a row using INSERT SQL");
        snSession.sql("INSERT INTO CUSTOMER VALUES(20000, 'Customer20000', 'Chicago, IL', 1, '555-101-782', 3500, 'MKTSEGMENT', '')");
        pw.println();
        result = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table are ").append(result[0].get(0)).toString());
        pw.println("****Done****");
    }

    public void createColumnTableInferredSchema(SnappySession snSession, PrintWriter pw) {
        pw.println();
        pw.println("****Create a column table using API where schema is inferred from parquet file****");
        snSession.dropTable("CUSTOMER", true);
        Dataset customerDF = snSession.read().parquet(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/customerparquet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()})));
        scala.collection.immutable.Map props1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PARTITION_BY"), (Object)"C_CUSTKEY")}));
        customerDF.write().format("column").mode("append").options((Map)props1).saveAsTable("CUSTOMER");
        pw.println();
        Row[] result = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table after loading data are ").append(result[0].get(0)).toString());
        pw.println("****Create a column table using API where schema is inferred from CSV file****");
        snSession.dropTable("CUSTOMER", true);
        Dataset customer_csv_DF = snSession.read().option("header", "true").option("inferSchema", "true").csv(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/customer_with_headers.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataFolder()})));
        customer_csv_DF.write().format("column").mode("append").options((Map)props1).saveAsTable("CUSTOMER");
        pw.println();
        Row[] result2 = snSession.sql("SELECT COUNT(*) FROM CUSTOMER").collect();
        pw.println(new StringBuilder().append((Object)"Number of records in CUSTOMER table after loading data are ").append(result2[0].get(0)).toString());
        pw.println("****Done****");
    }

    public void main(String[] args) {
        this.parseArgs(args);
        Logger.getLogger((String)"org").setLevel(Level.ERROR);
        Logger.getLogger((String)"akka").setLevel(Level.ERROR);
        String dataDirAbsolutePath = this.createAndGetDataDir();
        Predef$.MODULE$.println((Object)"Creating a SnappySession");
        SparkSession spark = SparkSession$.MODULE$.builder().appName("CreateColumnTable").master("local[*]").config("snappydata.store.sys-disk-dir", dataDirAbsolutePath).config("snappydata.store.log-file", new StringBuilder().append((Object)dataDirAbsolutePath).append((Object)"/SnappyDataExample.log").toString()).getOrCreate();
        SnappySession snSession = new SnappySession(spark.sparkContext());
        PrintWriter pw = new PrintWriter(System.out, true);
        this.createColumnTableUsingAPI(snSession, pw);
        this.createColumnTableUsingSQL(snSession, pw);
        this.createColumnTableInferredSchema(snSession, pw);
        pw.close();
    }

    /*
     * WARNING - void declaration
     */
    public String createAndGetDataDir() {
        void var2_2;
        String dataDir = "./snappydata_examples_data";
        new File(dataDir).mkdir();
        String dataDirAbsolutePath = new File(dataDir).getAbsolutePath();
        return var2_2;
    }

    private void parseArgs(String[] args) {
        if (args.length != 1) {
            this.printUsage();
            System.exit(1);
        }
        this.dataFolder_$eq(args[0]);
    }

    private void printUsage() {
        String usage = "Usage: CreateColumnTable <dataFolderPath> \n\ndataFolderPath - (string) local folder where customer.csv is located\n";
        Predef$.MODULE$.println((Object)usage);
    }

    private CreateColumnTable$() {
        MODULE$ = this;
        SnappySQLJob.class.$init$((SnappySQLJob)this);
        this.dataFolder = "";
    }
}

