/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import com.typesafe.config.Config;
import io.snappydata.examples.TwitterSchema;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.json.JSONArray;
import org.json.JSONObject;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import twitter4j.HashtagEntity;
import twitter4j.Status;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.ConfigurationBuilder;

public final class StreamingUtils$ {
    public static final StreamingUtils$ MODULE$;

    static {
        new StreamingUtils$();
    }

    public Seq<Row> convertTweetToRow(Object message, StructType schema) {
        JSONObject json = null;
        ObjectRef arr = new ObjectRef(null);
        if (message instanceof String) {
            json = new JSONObject((String)message);
            JSONArray hashArray = (JSONArray)json.get("hashtagEntities");
            arr.elem = new GenericRowWithSchema[hashArray.length()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), hashArray.length()).foreach$mVc$sp((Function1)new Serializable(schema, arr, hashArray){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;
                private final ObjectRef arr$1;
                private final JSONArray hashArray$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    JSONObject a = this.hashArray$1.getJSONObject(i);
                    String b = a.getString("text");
                    ((GenericRowWithSchema[])this.arr$1.elem)[i] = new GenericRowWithSchema((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)b)}), ClassTag$.MODULE$.Any()), this.schema$1);
                }
                {
                    this.schema$1 = schema$1;
                    this.arr$1 = arr$1;
                    this.hashArray$1 = hashArray$1;
                }
            });
        } else {
            Status status = (Status)message;
            HashtagEntity[] hashArray = status.getHashtagEntities();
            arr.elem = new GenericRowWithSchema[hashArray.length];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), hashArray.length).foreach$mVc$sp((Function1)new Serializable(schema, arr, hashArray){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;
                private final ObjectRef arr$1;
                private final HashtagEntity[] hashArray$2;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    String b = this.hashArray$2[i].getText();
                    ((GenericRowWithSchema[])this.arr$1.elem)[i] = new GenericRowWithSchema((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)b)}), ClassTag$.MODULE$.Any()), this.schema$1);
                }
                {
                    this.schema$1 = schema$1;
                    this.arr$1 = arr$1;
                    this.hashArray$2 = hashArray$2;
                }
            });
        }
        return Predef$.MODULE$.refArrayOps((Object[])((GenericRowWithSchema[])arr.elem)).toSeq();
    }

    public TwitterSchema[] convertPopularTweetsToRow(Object message) {
        JSONObject json = null;
        int retweetCnt = 0;
        String retweetTxt = null;
        if (message instanceof String) {
            json = new JSONObject((String)message);
            if (json != null && json.has("retweetedStatus")) {
                JSONObject retweetedSts = json.getJSONObject("retweetedStatus");
                retweetTxt = (String)retweetedSts.get("text");
                retweetCnt = BoxesRunTime.unboxToInt((Object)retweetedSts.get("retweetCount"));
            }
        } else {
            Status status = (Status)message;
            if (status.getRetweetedStatus() != null) {
                retweetTxt = status.getRetweetedStatus().getText();
                retweetCnt = status.getRetweetedStatus().getRetweetCount();
            }
        }
        TwitterSchema[] sampleRow = new TwitterSchema[]{new TwitterSchema(retweetCnt, retweetTxt)};
        return sampleRow;
    }

    public OAuthAuthorization getTwitterAuth(Config jobConfig) {
        return new OAuthAuthorization(new ConfigurationBuilder().setOAuthConsumerKey(jobConfig.getString("consumerKey")).setOAuthConsumerSecret(jobConfig.getString("consumerSecret")).setOAuthAccessToken(jobConfig.getString("accessToken")).setOAuthAccessTokenSecret(jobConfig.getString("accessTokenSecret")).setJSONStoreEnabled(true).build());
    }

    private StreamingUtils$() {
        MODULE$ = this;
    }
}

