/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SnappyContext;
import org.apache.spark.sql.SnappyContext$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class AirlineDataSparkApp$ {
    public static final AirlineDataSparkApp$ MODULE$;

    static {
        new AirlineDataSparkApp$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("Airline Data Application");
        SparkContext sc = new SparkContext(conf);
        SnappyContext snc = SnappyContext$.MODULE$.apply(sc);
        snc.sql("set spark.sql.shuffle.partitions=6");
        String colTableName = "airline";
        String rowTableName = "airlineref";
        DataFrame airlineDF = snc.table(colTableName);
        DataFrame airlineCodeDF = snc.table(rowTableName);
        DataFrame colResult = airlineDF.join(airlineCodeDF, airlineDF.col("UniqueCarrier").equalTo((Object)airlineCodeDF.apply("CODE"))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{airlineDF.apply("UniqueCarrier"), airlineCodeDF.apply("DESCRIPTION")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("avg(ArrDelay)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Predef$.MODULE$.println((Object)"Airline arrival schedule");
        long start = System.currentTimeMillis();
        colResult.show();
        long totalTimeCol = System.currentTimeMillis() - start;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query time:", "ms\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTimeCol)})));
        String query = " CODE ='DL'";
        Row newColumnValues = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Delta America"}));
        snc.update(rowTableName, query, newColumnValues, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESCRIPTION"}));
        DataFrame colResultAftUpd = airlineDF.join(airlineCodeDF, airlineDF.col("UniqueCarrier").equalTo((Object)airlineCodeDF.apply("CODE"))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{airlineDF.apply("UniqueCarrier"), airlineCodeDF.apply("DESCRIPTION")})).agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"ArrDelay"), (Object)"avg"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).orderBy("avg(ArrDelay)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Predef$.MODULE$.println((Object)"Airline arrival schedule after Updated values:");
        long startColUpd = System.currentTimeMillis();
        colResultAftUpd.show();
        long totalTimeColUpd = System.currentTimeMillis() - startColUpd;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Query time:", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)totalTimeColUpd)})));
    }

    private AirlineDataSparkApp$() {
        MODULE$ = this;
    }
}

