/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.examples;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.JSparkJobInvalid;
import org.apache.spark.sql.JSparkJobValid;
import org.apache.spark.sql.JSparkJobValidation;
import org.apache.spark.sql.JavaSnappySQLJob;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SnappyContext;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaCreateAndLoadAirlineDataJob
extends JavaSnappySQLJob {
    private String airlinefilePath = null;
    private String airlinereftablefilePath = null;
    private static final String colTable = "AIRLINE";
    private static final String rowTable = "AIRLINEREF";
    private static final String sampleTable = "AIRLINE_SAMPLE";
    private static final String stagingAirline = "STAGING_AIRLINE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runJavaJob(SnappyContext snc, Config jobConfig) {
        PrintWriter pw;
        block5: {
            pw = null;
            String currentDirectory = null;
            boolean success = false;
            try {
                currentDirectory = new File(".").getCanonicalPath();
                pw = new PrintWriter("JavaCreateAndLoadAirlineDataJob.out");
                snc.dropTable(sampleTable, true);
                snc.dropTable(colTable, true);
                snc.dropTable(rowTable, true);
                snc.dropTable(stagingAirline, true);
                pw.println("****** JavaCreateAndLoadAirlineDataJob ******");
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("path", this.airlinefilePath);
                DataFrame airlineDF = snc.createExternalTable(stagingAirline, "parquet", props);
                StructType updatedSchema = JavaCreateAndLoadAirlineDataJob.replaceReservedWords(airlineDF.schema());
                HashMap<String, String> columnTableProps = new HashMap<String, String>();
                columnTableProps.put("buckets", "11");
                snc.createTable(colTable, "column", updatedSchema, columnTableProps, false);
                airlineDF.write().mode(SaveMode.Append).saveAsTable(colTable);
                pw.println("Created and imported data in $colTable table.");
                DataFrame airlinerefDF = snc.read().load(this.airlinereftablefilePath);
                snc.createTable(rowTable, "row", airlinerefDF.schema(), Collections.emptyMap(), false);
                airlinerefDF.write().mode(SaveMode.Append).saveAsTable(rowTable);
                pw.println("Created and imported data in $rowTable table");
                HashMap<String, String> sampleTableProps = new HashMap<String, String>();
                sampleTableProps.put("buckets", "7");
                sampleTableProps.put("qcs", "UniqueCarrier, Year_, Month_");
                sampleTableProps.put("fraction", "0.03");
                sampleTableProps.put("strataReservoirSize", "50");
                sampleTableProps.put("basetable", "Airline");
                snc.createSampleTable(sampleTable, sampleTableProps, false);
                snc.table(colTable).write().mode(SaveMode.Append).saveAsTable(sampleTable);
                pw.println("Created and imported data in $sampleTable table.");
                pw.println("****** Job finished ******");
                success = true;
                if (!success) break block5;
            }
            catch (IOException e) {
                block6: {
                    try {
                        pw.close();
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            String returnValue = String.format("See %s/JavaCreateAndLoadAirlineDataJob.out", currentDirectory);
                            return returnValue;
                        }
                        pw.close();
                        throw throwable;
                    }
                    String returnValue = String.format("See %s/JavaCreateAndLoadAirlineDataJob.out", currentDirectory);
                    return returnValue;
                }
                pw.close();
            }
            String returnValue = String.format("See %s/JavaCreateAndLoadAirlineDataJob.out", currentDirectory);
            return returnValue;
        }
        pw.close();
        return null;
    }

    public JSparkJobValidation isValidJob(SnappyContext snc, Config config) {
        this.airlinefilePath = config.hasPath("airline_file") ? config.getString("airline_file") : "../../quickstart/data/airlineParquetData";
        if (!new File(this.airlinefilePath).exists()) {
            return new JSparkJobInvalid("Incorrect airline path. Specify airline_file property in APP_PROPS");
        }
        this.airlinereftablefilePath = config.hasPath("airlineref_file") ? config.getString("airlineref_file") : "../../quickstart/data/airportcodeParquetData";
        if (!new File(this.airlinereftablefilePath).exists()) {
            return new JSparkJobInvalid("Incorrect airline ref path. Specify airlineref_file property in APP_PROPS");
        }
        return new JSparkJobValid();
    }

    private static StructType replaceReservedWords(StructType airlineSchema) {
        StructField[] fields = airlineSchema.fields();
        StructField[] newFields = new StructField[fields.length];
        for (StructField s : fields) {
            StructField newField = null;
            newField = s.name().equals("Year") ? new StructField("Year_", s.dataType(), s.nullable(), s.metadata()) : (s.name().equals("Month") ? new StructField("Month_", s.dataType(), s.nullable(), s.metadata()) : s);
            newFields[airlineSchema.indexOf((Object)s)] = newField;
        }
        return new StructType(newFields);
    }
}

