/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.streaming.StreamToRowsConverter;
import org.json.JSONObject;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import twitter4j.Status;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\t\tBk^3fiR{'+\u001a;xK\u0016$(k\\<\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u000bTiJ,\u0017-\u001c+p%><8oQ8om\u0016\u0014H/\u001a:\u0011\u0005=I\u0012B\u0001\u000e\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u0016\u0001!)\u0001\u0005\u0001C!C\u00051Ao\u001c*poN$\"A\t\u001a\u0011\u0007\rZcF\u0004\u0002%S9\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!A\u000b\t\u0002\u000fA\f7m[1hK&\u0011A&\f\u0002\u0004'\u0016\f(B\u0001\u0016\u0011!\ty\u0003'D\u0001\u0005\u0013\t\tDAA\u0002S_^DQaM\u0010A\u0002Q\nq!\\3tg\u0006<W\r\u0005\u0002\u0010k%\u0011a\u0007\u0005\u0002\u0004\u0003:L\b")
public class TweetToRetweetRow
implements StreamToRowsConverter {
    @Override
    public Seq<Row> toRows(Object message) {
        JSONObject json = null;
        int retweetCnt = 0;
        String retweetTxt = null;
        long retweetId = 0L;
        if (message instanceof String) {
            json = new JSONObject((String)message);
            if (json != null && json.has("retweetedStatus")) {
                JSONObject retweetedSts = json.getJSONObject("retweetedStatus");
                retweetTxt = retweetedSts.getString("text");
                retweetCnt = retweetedSts.getInt("retweetCount");
                retweetId = retweetedSts.getLong("id");
            }
        } else {
            Status status = (Status)message;
            if (status.getRetweetedStatus() != null) {
                retweetTxt = status.getRetweetedStatus().getText();
                retweetCnt = status.getRetweetedStatus().getRetweetCount();
                retweetId = status.getRetweetedStatus().getId();
            }
        }
        Row[] sampleRow = new Row[]{Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)retweetId), BoxesRunTime.boxToInteger((int)retweetCnt), retweetTxt})))};
        return Predef$.MODULE$.refArrayOps((Object[])sampleRow).toSeq();
    }
}

