/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.JavaTypeInference$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.RDDConversions$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.streaming.LogicalDStreamPlan;
import org.apache.spark.sql.streaming.SchemaDStream;
import org.apache.spark.sql.streaming.StreamBaseRelation$;
import org.apache.spark.sql.streaming.StreamPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.streaming.SnappyStreamingContext;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;

public final class StreamSqlHelper$ {
    public static final StreamSqlHelper$ MODULE$;

    static {
        new StreamSqlHelper$();
    }

    public void registerRelationDestroy() {
        SnappyStoreHiveCatalog$.MODULE$.registerRelationDestroy();
    }

    public void clearStreams() {
        StreamBaseRelation$.MODULE$.clearStreams();
    }

    public Seq<AttributeReference> getSchema(Class<?> beanClass) {
        Tuple2 tuple2 = JavaTypeInference$.MODULE$.inferDataType(beanClass);
        if (tuple2 != null) {
            DataType dataType;
            DataType dataType2;
            DataType dataType3 = dataType2 = (dataType = (DataType)tuple2._1());
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])((StructType)dataType3).fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final AttributeReference apply(StructField f) {
                    String x$5 = f.name();
                    DataType x$6 = f.dataType();
                    boolean x$7 = f.nullable();
                    Metadata x$8 = AttributeReference$.MODULE$.apply$default$4();
                    ExprId x$9 = AttributeReference$.MODULE$.apply$default$5(x$5, x$6, x$7, x$8);
                    Seq x$10 = AttributeReference$.MODULE$.apply$default$6(x$5, x$6, x$7, x$8);
                    return new AttributeReference(x$5, x$6, x$7, x$8, x$9, x$10);
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterator<InternalRow> org$apache$spark$sql$streaming$StreamSqlHelper$$beansToRows(Iterator<Object> data, BeanInfo beanInfo, Seq<AttributeReference> attrs) {
        Method[] extractors = (Method[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])beanInfo.getPropertyDescriptors()).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PropertyDescriptor x$1) {
                String string = x$1.getName();
                String string2 = "class";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Method apply(PropertyDescriptor x$2) {
                return x$2.getReadMethod();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Method.class)));
        Tuple2[] methodsToConverts = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])extractors).zip(attrs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Method, Function1<Object, Object>> apply(Tuple2<Method, AttributeReference> x0$1) {
                Tuple2<Method, AttributeReference> tuple2 = x0$1;
                if (tuple2 != null) {
                    Method e = (Method)tuple2._1();
                    AttributeReference attr = (AttributeReference)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)e, (Object)CatalystTypeConverters$.MODULE$.createToCatalystConverter(attr.dataType()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return data.map((Function1)new Serializable(methodsToConverts){
            public static final long serialVersionUID = 0L;
            private final Tuple2[] methodsToConverts$1;

            public final InternalRow apply(Object element) {
                return new GenericInternalRow((Object[])Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])this.methodsToConverts$1).map((Function1)new Serializable(this, element){
                    public static final long serialVersionUID = 0L;
                    private final Object element$1;

                    public final Object apply(Tuple2<Method, Function1<Object, Object>> x0$2) {
                        Tuple2<Method, Function1<Object, Object>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Method e = (Method)tuple2._1();
                            Function1 convert = (Function1)tuple2._2();
                            Object object = convert.apply(e.invoke(this.element$1, new Object[0]));
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.element$1 = element$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toArray(ClassTag$.MODULE$.Any()));
            }
            {
                this.methodsToConverts$1 = methodsToConverts$1;
            }
        });
    }

    public SchemaDStream getSchemaDStream(SnappyStreamingContext ssc, String tableName) {
        LogicalRelation logicalRelation;
        BaseRelation sr;
        SnappyStoreHiveCatalog catalog = ssc.snappyContext().catalog();
        LogicalPlan logicalPlan = catalog.lookupRelation(catalog.newQualifiedTableName(tableName));
        if (logicalPlan instanceof LogicalRelation && (sr = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof StreamPlan) {
            BaseRelation baseRelation = sr;
            SchemaDStream schemaDStream = new SchemaDStream(ssc, new LogicalDStreamPlan((Seq<Attribute>)((StreamPlan)baseRelation).schema().toAttributes(), ((StreamPlan)baseRelation).rowStream(), ssc));
            return schemaDStream;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " not a stream table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
    }

    public <A extends Product> SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, DStream<A> stream, TypeTags.TypeTag<A> evidence$1) {
        StructType schema = (StructType)ScalaReflection$.MODULE$.schemaFor(evidence$1).dataType();
        DStream rowStream2 = stream.transform((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final RDD<InternalRow> apply(RDD<A> rdd) {
                return RDDConversions$.MODULE$.productToRowRdd(rdd, (Seq)this.schema$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DataType apply(StructField x$3) {
                        return x$3.dataType();
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan((Seq<Attribute>)schema.toAttributes(), (DStream<InternalRow>)rowStream2, ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    public SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, DStream<Row> rowStream2, StructType schema) {
        Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)schema);
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan((Seq<Attribute>)schema.toAttributes(), (DStream<InternalRow>)rowStream2.map((Function1)new Serializable(converter){
            public static final long serialVersionUID = 0L;
            private final Function1 converter$1;

            public final InternalRow apply(Row x$4) {
                return (InternalRow)this.converter$1.apply((Object)x$4);
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class)), ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    public SchemaDStream createSchemaDStream(SnappyStreamingContext ssc, JavaDStream<?> rowStream2, Class<?> beanClass) {
        Seq<AttributeReference> attributeSeq = this.getSchema(beanClass);
        String className2 = beanClass.getName();
        DStream internalRowStream = rowStream2.dstream().mapPartitions((Function1)new Serializable(attributeSeq, className2){
            public static final long serialVersionUID = 0L;
            private final Seq attributeSeq$1;
            private final String className$1;

            public final Iterator<InternalRow> apply(Iterator<Object> iter) {
                BeanInfo localBeanInfo = Introspector.getBeanInfo(Utils$.MODULE$.classForName(this.className$1));
                return StreamSqlHelper$.MODULE$.org$apache$spark$sql$streaming$StreamSqlHelper$$beansToRows(iter, localBeanInfo, (Seq<AttributeReference>)this.attributeSeq$1);
            }
            {
                this.attributeSeq$1 = attributeSeq$1;
                this.className$1 = className$1;
            }
        }, rowStream2.dstream().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        LogicalDStreamPlan logicalPlan = new LogicalDStreamPlan(attributeSeq, (DStream<InternalRow>)internalRowStream, ssc);
        return new SchemaDStream(ssc, logicalPlan);
    }

    private StreamSqlHelper$() {
        MODULE$ = this;
    }
}

