/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.Logging;
import org.apache.spark.rdd.EmptyRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.DDLException;
import org.apache.spark.sql.hive.QualifiedTableName;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DependencyCatalog$;
import org.apache.spark.sql.sources.DependentRelation;
import org.apache.spark.sql.sources.DestroyRelation;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.ParentRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.streaming.StreamBaseRelation$;
import org.apache.spark.sql.streaming.StreamPlan;
import org.apache.spark.sql.streaming.StreamToRowsConverter;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.SnappyStreamingContext;
import org.apache.spark.streaming.SnappyStreamingContext$;
import org.apache.spark.streaming.StreamUtils$;
import org.apache.spark.streaming.StreamingContextState;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0001\u0003\u0003\u0003i!AE*ue\u0016\fWNQ1tKJ+G.\u0019;j_:T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0003\u0001\u000f)]Yb$I\u0014\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011aB:pkJ\u001cWm]\u0005\u0003'A\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"aD\u000b\n\u0005Y\u0001\"A\u0004)be\u0016tGOU3mCRLwN\u001c\t\u00031ei\u0011AA\u0005\u00035\t\u0011!b\u0015;sK\u0006l\u0007\u000b\\1o!\tyA$\u0003\u0002\u001e!\tIA+\u00192mKN\u001b\u0017M\u001c\t\u0003\u001f}I!\u0001\t\t\u0003\u001f\u0011+7\u000f\u001e:psJ+G.\u0019;j_:\u0004\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001K\u0015\u000e\u0003\u0019I!A\u000b\u0004\u0003\u000f1{wmZ5oO\"AA\u0006\u0001B\u0001B\u0003%Q&A\u0004paRLwN\\:\u0011\t9\nD\u0007\u000e\b\u0003E=J!\u0001M\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u00114GA\u0002NCBT!\u0001M\u0012\u0011\u00059*\u0014B\u0001\u001c4\u0005\u0019\u0019FO]5oO\")\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"\"AO\u001e\u0011\u0005a\u0001\u0001\"\u0002\u00178\u0001\u0004i\u0003\"B\u001f\u0001\t\u000bq\u0014aB2p]R,\u0007\u0010^\u000b\u0002\u007fA\u0011\u0001IQ\u0007\u0002\u0003*\u00111AB\u0005\u0003\u0007\u0006\u0013ac\u00158baBL8\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u00015\u0011\u0019A\u0005\u0001)A\u0005i\u0005QA/\u00192mK:\u000bW.\u001a\u0011)\u0005\u001dS\u0005C\u0001\u0012L\u0013\ta5EA\u0005ue\u0006t7/[3oi\")a\n\u0001C!\u001f\u0006a\u0011\r\u001a3EKB,g\u000eZ3oiR\u0019\u0001k\u0015-\u0011\u0005\t\n\u0016B\u0001*$\u0005\u001d\u0011un\u001c7fC:DQ\u0001V'A\u0002U\u000b\u0011\u0002Z3qK:$WM\u001c;\u0011\u0005=1\u0016BA,\u0011\u0005E!U\r]3oI\u0016tGOU3mCRLwN\u001c\u0005\u000636\u0003\rAW\u0001\bG\u0006$\u0018\r\\8h!\tYf,D\u0001]\u0015\tiF!\u0001\u0003iSZ,\u0017BA0]\u0005Y\u0019f.\u00199qsN#xN]3ISZ,7)\u0019;bY><\u0007\"B1\u0001\t\u0003\u0012\u0017a\u0004:f[>4X\rR3qK:$WM\u001c;\u0015\u0007A\u001bG\rC\u0003UA\u0002\u0007Q\u000bC\u0003ZA\u0002\u0007!\fC\u0003g\u0001\u0011\u0005s-A\u0007hKR$U\r]3oI\u0016tGo\u001d\u000b\u0003QR\u00042![95\u001d\tQwN\u0004\u0002l]6\tAN\u0003\u0002n\u0019\u00051AH]8pizJ\u0011\u0001J\u0005\u0003a\u000e\nq\u0001]1dW\u0006<W-\u0003\u0002sg\n\u00191+Z9\u000b\u0005A\u001c\u0003\"B-f\u0001\u0004Q\u0006\"\u0002<\u0001\t\u0003:\u0018!\u0007:fG>4XM\u001d#fa\u0016tG-\u001a8ugJ+G.\u0019;j_:$\u0012\u0001\u001f\t\u0003EeL!A_\u0012\u0003\tUs\u0017\u000e\u001e\u0005\by\u0002\u0011\r\u0011\"\u0001~\u00031\u0019Ho\u001c:bO\u0016dUM^3m+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u00071\u0011aB:u_J\fw-Z\u0005\u0005\u0003\u000f\t\tA\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002@\u0002\u001bM$xN]1hK2+g/\u001a7!\u0011%\ty\u0001\u0001b\u0001\n\u0003\t\t\"\u0001\u0007s_^\u001cuN\u001c<feR,'/\u0006\u0002\u0002\u0014A\u0019\u0001$!\u0006\n\u0007\u0005]!AA\u000bTiJ,\u0017-\u001c+p%><8oQ8om\u0016\u0014H/\u001a:\t\u0011\u0005m\u0001\u0001)A\u0005\u0003'\tQB]8x\u0007>tg/\u001a:uKJ\u0004\u0003bBA\u0010\u0001\u0019E\u0011\u0011E\u0001\u0010GJ,\u0017\r^3S_^\u001cFO]3b[R\u0011\u00111\u0005\t\u0007\u0003K\tY#a\f\u000e\u0005\u0005\u001d\"bAA\u0015\u0003\u00069Am\u001d;sK\u0006l\u0017\u0002BA\u0017\u0003O\u0011q\u0001R*ue\u0016\fW\u000e\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004B\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011HA\u001a\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u0015\u0005u\u0002\u0001#b\u0001\n\u000b\ny$A\u0005s_^\u001cFO]3b[V\u0011\u00111\u0005\u0005\u000b\u0003\u0007\u0002\u0001\u0012!Q!\u000e\u0005\r\u0012A\u0003:poN#(/Z1nA!\u001a\u0011\u0011\t&\t\u0013\u0005%\u0003A1A\u0005B\u0005-\u0013A\u00048fK\u0012\u001cuN\u001c<feNLwN\\\u000b\u0002!\"9\u0011q\n\u0001!\u0002\u0013\u0001\u0016a\u00048fK\u0012\u001cuN\u001c<feNLwN\u001c\u0011\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V\u0005I!-^5mIN\u001b\u0017M\u001c\u000b\u0003\u0003/\u0002b!!\u0017\u0002`\u0005\rTBAA.\u0015\r\tiFB\u0001\u0004e\u0012$\u0017\u0002BA1\u00037\u00121A\u0015#E!\u0011\t)'a\u001a\u000e\u0003\u0011I1!!\u001b\u0005\u0005\r\u0011vn\u001e\u0005\b\u0003[\u0002A\u0011IA8\u0003\u001d!Wm\u001d;s_f$2\u0001_A9\u0011\u001d\t\u0019(a\u001bA\u0002A\u000b\u0001\"\u001b4Fq&\u001cHo\u001d\u0005\u0007\u0003o\u0002A\u0011A<\u0002\u0011Q\u0014XO\\2bi\u0016<q!a\u001f\u0003\u0011\u0013\ti(\u0001\nTiJ,\u0017-\u001c\"bg\u0016\u0014V\r\\1uS>t\u0007c\u0001\r\u0002\u0000\u00191\u0011A\u0001E\u0005\u0003\u0003\u001bb!a \u0002\u0004\u001e\n\u0003c\u0001\u0012\u0002\u0006&\u0019\u0011qQ\u0012\u0003\r\u0005s\u0017PU3g\u0011\u001dA\u0014q\u0010C\u0001\u0003\u0017#\"!! \t\u0013\u0005=\u0015q\u0010Q\u0001\n\u0005E\u0015!\u0004;bE2,Gk\\*ue\u0016\fW\u000eE\u0004\u0002\u0014\u0006uE'a\t\u000e\u0005\u0005U%\u0002BAL\u00033\u000bq!\\;uC\ndWMC\u0002\u0002\u001c\u000e\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty*!&\u0003\u000f!\u000b7\u000f['ba\"I\u00111UA@A\u0003%\u0011QU\u0001\u0005\u0019>\u001b5\n\u0005\u0003\u0002(\u0006EVBAAU\u0015\u0011\tY+!,\u0002\t1\fgn\u001a\u0006\u0003\u0003_\u000bAA[1wC&!\u00111WAU\u0005\u0019y%M[3di\"Q\u0011qWA@\u0001\u0004%\t!!/\u0002\u0013Y\fG.\u001b3US6,WCAA^!\r\u0001\u0015QX\u0005\u0004\u0003\u007f\u000b%\u0001\u0002+j[\u0016D!\"a1\u0002\u0000\u0001\u0007I\u0011AAc\u000351\u0018\r\\5e)&lWm\u0018\u0013fcR\u0019\u00010a2\t\u0015\u0005%\u0017\u0011YA\u0001\u0002\u0004\tY,A\u0002yIEB\u0011\"!4\u0002\u0000\u0001\u0006K!a/\u0002\u0015Y\fG.\u001b3US6,\u0007\u0005\u0003\u0005\u0002R\u0006}D\u0011AAj\u00031\u0019X\r\u001e,bY&$G+[7f)\rA\u0018Q\u001b\u0005\t\u0003/\fy\r1\u0001\u0002<\u0006!A/[7f\u0011!\tY.a \u0005\n\u0005u\u0017\u0001F4fi>\u00138I]3bi\u0016\u0014vn^*ue\u0016\fW\u000e\u0006\u0004\u0002$\u0005}\u0017\u0011\u001d\u0005\u0007\u000b\u0006e\u0007\u0019\u0001\u001b\t\u0011\u0005\r\u0018\u0011\u001ca\u0001\u0003K\fAb\u0019:fCR,7\u000b\u001e:fC6\u0004RAIAt\u0003WL1!!;$\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0004#\u0003[\f\u0019\u0003[\u0005\u0004\u0003_\u001c#A\u0002+va2,'\u0007\u0003\u0005\u0002t\u0006}D\u0011BA{\u00031\u0011X-\\8wKN#(/Z1n)\u0011\t90!@\u0011\u000b\t\nI0a\t\n\u0007\u0005m8E\u0001\u0004PaRLwN\u001c\u0005\u0007\u000b\u0006E\b\u0019\u0001\u001b\t\u0011\t\u0005\u0011q\u0010C\u0001\u0005\u0007\t!b\u001d;paN#(/Z1n)\rA(Q\u0001\u0005\t\u0005\u000f\ty\u00101\u0001\u0003\n\u000511\u000f\u001e:fC6\u0004DAa\u0003\u0003\u0012A1\u0011QEA\u0016\u0005\u001b\u0001BAa\u0004\u0003\u00121\u0001A\u0001\u0004B\n\u0005\u000b\t\t\u0011!A\u0003\u0002\tU!aA0%cE!!q\u0003B\u000f!\r\u0011#\u0011D\u0005\u0004\u00057\u0019#a\u0002(pi\"Lgn\u001a\t\u0004E\t}\u0011b\u0001B\u0011G\t\u0019\u0011I\\=\t\u0011\t\u0015\u0012q\u0010C\u0001\u0005]\fAb\u00197fCJ\u001cFO]3b[ND!B!\u000b\u0002\u0000\u0005\u0005I\u0011\u0002B\u0016\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0015\u0006")
public abstract class StreamBaseRelation
extends BaseRelation
implements ParentRelation,
StreamPlan,
TableScan,
DestroyRelation,
Serializable,
Logging {
    private final Map<String, String> options;
    private final transient String tableName;
    private final StorageLevel storageLevel;
    private final StreamToRowsConverter rowConverter;
    private transient DStream<InternalRow> rowStream;
    private final boolean needConversion;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile transient boolean bitmap$trans$0;

    public static void stopStream(DStream<?> dStream) {
        StreamBaseRelation$.MODULE$.stopStream(dStream);
    }

    public static void setValidTime(Time time) {
        StreamBaseRelation$.MODULE$.setValidTime(time);
    }

    public static void validTime_$eq(Time time) {
        StreamBaseRelation$.MODULE$.validTime_$eq(time);
    }

    public static Time validTime() {
        return StreamBaseRelation$.MODULE$.validTime();
    }

    private DStream rowStream$lzycompute() {
        StreamBaseRelation streamBaseRelation = this;
        synchronized (streamBaseRelation) {
            if (!this.bitmap$trans$0) {
                this.rowStream = StreamBaseRelation$.MODULE$.org$apache$spark$sql$streaming$StreamBaseRelation$$getOrCreateRowStream(this.tableName(), (Function0<Tuple2<DStream<InternalRow>, Seq<String>>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StreamBaseRelation $outer;

                    public final Tuple2<DStream<InternalRow>, Seq<String>> apply() {
                        DStream<InternalRow> stream = this.$outer.createRowStream();
                        SnappyStoreHiveCatalog catalog = this.$outer.context().snappyContext().catalog();
                        Seq initDependents = (Seq)catalog.getDataSourceTables((Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.empty()), (Option<String>)new Some((Object)this.$outer.tableName())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(QualifiedTableName x$1) {
                                return x$1.toString();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Tuple2(stream, (Object)initDependents);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$trans$0 = true;
            }
            return this.rowStream;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public final SnappyStreamingContext context() {
        return (SnappyStreamingContext)((Object)SnappyStreamingContext$.MODULE$.getInstance().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No initialized streaming context");
            }
        }));
    }

    public String tableName() {
        return this.tableName;
    }

    @Override
    public boolean addDependent(DependentRelation dependent, SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.addDependent(this.tableName(), dependent.name());
    }

    @Override
    public boolean removeDependent(DependentRelation dependent, SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.removeDependent(this.tableName(), dependent.name());
    }

    @Override
    public Seq<String> getDependents(SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.getDependents(this.tableName());
    }

    @Override
    public void recoverDependentsRelation() {
        throw new UnsupportedOperationException("Recovery of dependents' relation not possible");
    }

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public StreamToRowsConverter rowConverter() {
        return this.rowConverter;
    }

    public abstract DStream<InternalRow> createRowStream();

    @Override
    public final DStream<InternalRow> rowStream() {
        return this.bitmap$trans$0 ? this.rowStream : this.rowStream$lzycompute();
    }

    public boolean needConversion() {
        return this.needConversion;
    }

    public RDD<Row> buildScan() {
        StreamingContextState streamingContextState = this.context().getState();
        StreamingContextState streamingContextState2 = StreamingContextState.STOPPED;
        if (!(streamingContextState != null ? !streamingContextState.equals(streamingContextState2) : streamingContextState2 != null)) {
            throw new IllegalStateException("StreamingContext has stopped");
        }
        scala.collection.mutable.Map<Time, RDD<InternalRow>> rdds = StreamUtils$.MODULE$.getGeneratedRDDs(this.rowStream(), ClassTag$.MODULE$.apply(InternalRow.class));
        return rdds.isEmpty() ? new EmptyRDD(this.sqlContext().sparkContext(), ClassTag$.MODULE$.apply(Row.class)) : (RDD)((Tuple2)rdds.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Time apply(Tuple2<Time, RDD<InternalRow>> x$2) {
                return (Time)x$2._1();
            }
        }, Time$.MODULE$.ordering()))._2();
    }

    @Override
    public void destroy(boolean ifExists) {
        StreamBaseRelation$.MODULE$.org$apache$spark$sql$streaming$StreamBaseRelation$$removeStream(this.tableName()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DStream<?> stream) {
                StreamBaseRelation$.MODULE$.stopStream(stream);
            }
        });
        DependencyCatalog$.MODULE$.removeAllDependents(this.tableName());
    }

    @Override
    public void truncate() {
        throw new DDLException("Stream tables cannot be truncated");
    }

    private final StreamToRowsConverter liftedTree1$1() {
        try {
            Class<?> clz = Utils$.MODULE$.getContextOrSparkClassLoader().loadClass((String)this.options.apply((Object)"rowConverter"));
            return (StreamToRowsConverter)clz.newInstance();
        }
        catch (Exception exception) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load class : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.toString()})));
        }
    }

    public StreamBaseRelation(Map<String, String> options) {
        this.options = options;
        Logging.class.$init$((Logging)this);
        this.tableName = (String)options.apply((Object)JdbcExtendedUtils$.MODULE$.DBTABLE_PROPERTY());
        this.storageLevel = (StorageLevel)options.get((Object)"storageLevel").map((Function1)new $anonfun$1(this)).getOrElse((Function0)new $anonfun$2(this));
        this.rowConverter = this.liftedTree1$1();
        this.needConversion = false;
    }
}

