/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.store;

import com.pivotal.gemfirexd.internal.iapi.types.SQLBit;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.apache.spark.sql.CatalystHashFunction;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.Decimal$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001I3A!\u0001\u0002\u0001\u001b\t\t2\u000b^8sK\"\u000b7\u000f\u001b$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!B:u_J,'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0001#D\u0001\u0005\u0013\t\tBA\u0001\u000bDCR\fG._:u\u0011\u0006\u001c\bNR;oGRLwN\u001c\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005Be\t1bY8naV$X\rS1tQR\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0004\u0013:$\b\"B\u0011\u0018\u0001\u0004\u0011\u0013aA6fsB\u00111dI\u0005\u0003Iq\u00111!\u00118z\u0011\u00151\u0003\u0001\"\u0003(\u0003=\u0019w.\u001c9vi\u0016D\u0015m\u001d5D_\u0012,GC\u0001\u000e)\u0011\u0015IS\u00051\u0001+\u0003\t\u0019H\r\u0005\u0002,q5\tAF\u0003\u0002.]\u0005)A/\u001f9fg*\u0011q\u0006M\u0001\u0005S\u0006\u0004\u0018N\u0003\u00022e\u0005A\u0011N\u001c;fe:\fGN\u0003\u00024i\u0005Iq-Z7gSJ,\u0007\u0010\u001a\u0006\u0003kY\nq\u0001]5w_R\fGNC\u00018\u0003\r\u0019w.\\\u0005\u0003s1\u0012qaU)M\t\u0006$X\rC\u0003'\u0001\u0011%1\b\u0006\u0002\u001by!)QH\u000fa\u0001}\u00059A-Z2j[\u0006d\u0007CA\u0016@\u0013\t\u0001EF\u0001\u0006T#2#UmY5nC2DQA\n\u0001\u0005\n\t#\"AG\"\t\u000b\u0011\u000b\u0005\u0019A#\u0002\tQLW.\u001a\t\u0003W\u0019K!a\u0012\u0017\u0003\u0019M\u000bF\nV5nKN$\u0018-\u001c9\t\u000b\u0019\u0002A\u0011B%\u0015\u0005iQ\u0005\"B&I\u0001\u0004a\u0015\u0001\u00023bi\u0006\u00042aG'P\u0013\tqEDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001c!&\u0011\u0011\u000b\b\u0002\u0005\u0007\"\f'\u000f")
public class StoreHashFunction
extends CatalystHashFunction {
    /*
     * WARNING - void declaration
     */
    @Override
    public int computeHash(Object key) {
        void var2_25;
        int n;
        if (key == null) {
            n = 0;
        } else {
            int n2;
            Object object = key;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                n2 = bl ? 0 : 1;
            } else if (object instanceof Byte) {
                int n3;
                n2 = n3 = BoxesRunTime.unboxToByte((Object)object);
            } else if (object instanceof Short) {
                int n4;
                n2 = n4 = BoxesRunTime.unboxToShort((Object)object);
            } else if (object instanceof Integer) {
                int n5;
                n2 = n5 = BoxesRunTime.unboxToInt((Object)object);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                n2 = (int)(l ^ l >>> 32);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                n2 = Float.floatToIntBits(f);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                long b = Double.doubleToLongBits(d);
                n2 = (int)(b ^ b >>> 32);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                n2 = Arrays.hashCode(byArray);
            } else if (object instanceof String) {
                String string = (String)object;
                n2 = this.computeHashCode(string);
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                n2 = this.computeHashCode(timestamp);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                n2 = this.computeHashCode(date);
            } else if (object instanceof SQLBoolean) {
                SQLBoolean sQLBoolean = (SQLBoolean)object;
                n2 = sQLBoolean.getBoolean() ? 0 : 1;
            } else if (object instanceof SQLDate) {
                SQLDate sQLDate = (SQLDate)object;
                n2 = this.computeHashCode(sQLDate);
            } else if (object instanceof SQLBit) {
                SQLBit sQLBit = (SQLBit)object;
                byte[] bytes = sQLBit.getBytes();
                n2 = bytes == null ? 0 : Arrays.hashCode(bytes);
            } else if (object instanceof SQLReal) {
                SQLReal sQLReal = (SQLReal)object;
                n2 = Float.floatToIntBits(sQLReal.getFloat());
            } else if (object instanceof SQLClob) {
                SQLClob sQLClob = (SQLClob)object;
                n2 = this.computeHashCode(sQLClob.getCharArray(true));
            } else if (object instanceof SQLVarchar) {
                SQLVarchar sQLVarchar = (SQLVarchar)object;
                n2 = this.computeHashCode(sQLVarchar.getCharArray(true));
            } else if (object instanceof SQLTimestamp) {
                SQLTimestamp sQLTimestamp = (SQLTimestamp)object;
                n2 = this.computeHashCode(sQLTimestamp);
            } else if (object instanceof SQLDecimal) {
                SQLDecimal sQLDecimal = (SQLDecimal)object;
                n2 = this.computeHashCode(sQLDecimal);
            } else {
                n2 = object.hashCode();
            }
            n = n2;
        }
        int update2 = n;
        return (int)var2_25;
    }

    private int computeHashCode(SQLDate sd) {
        return this.computeHash(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(sd.getTimeInMillis(null))));
    }

    private int computeHashCode(SQLDecimal decimal) {
        Object javaBigDecimal = decimal.getObject();
        return javaBigDecimal == null ? 0 : this.computeHash(Decimal$.MODULE$.apply((BigDecimal)javaBigDecimal));
    }

    private int computeHashCode(SQLTimestamp time) {
        long ht = time.getEpochTime(null) * 1000L + (long)time.getNanos() / 1000L;
        return this.computeHash(BoxesRunTime.boxToLong((long)ht));
    }

    private int computeHashCode(char[] data) {
        IntRef result = new IntRef(1);
        int end = data.length;
        for (int index = 0; index <= end - 1; ++index) {
            char c = data[index];
            if (c < '\u0080') {
                this.addToHash$1(c, result);
                continue;
            }
            if (c < '\u0800') {
                this.addToHash$1(c >> 6 | 0xC0, result);
                this.addToHash$1(c & 0x3F | 0x80, result);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char low;
                char high = c;
                char c2 = low = index + 1 != end ? data[index + 1] : (char)'\u0000';
                if (Character.isSurrogatePair(high, low)) {
                    ++index;
                    int sch = Character.toCodePoint(high, low);
                    this.addToHash$1(sch >> 18 | 0xF0, result);
                    this.addToHash$1(sch >> 12 & 0x3F | 0x80, result);
                    this.addToHash$1(sch >> 6 & 0x3F | 0x80, result);
                    this.addToHash$1(sch & 0x3F | 0x80, result);
                    continue;
                }
                throw new RuntimeException("The supplementary unicode is not in proper format");
            }
            this.addToHash$1(c >> 12 | 0xE0, result);
            this.addToHash$1(c >> 6 & 0x3F | 0x80, result);
            this.addToHash$1(c & 0x3F | 0x80, result);
        }
        return result.elem;
    }

    private final void addToHash$1(int value, IntRef result$1) {
        result$1.elem = 31 * result$1.elem + (byte)value;
    }
}

