/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.store;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Collections;
import org.apache.spark.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.collection.WrappedRow;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.store.CodeGeneration;
import org.apache.spark.sql.store.CodeGeneration$;
import org.apache.spark.sql.store.ExecuteKey;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.codehaus.commons.compiler.IScriptEvaluator;
import org.codehaus.janino.CompilerFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class CodeGeneration$
implements Logging {
    public static final CodeGeneration$ MODULE$;
    private final LoadingCache<ExecuteKey, CodeGeneration> cache;
    public final IndexedSeq<Method> org$apache$spark$sql$store$CodeGeneration$$allMethods;
    private final Method generateArrayCodeMethod;
    private final Method generateMapCodeMethod;
    private final Method generateStructCodeMethod;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new CodeGeneration$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    private Method getComplexTypeCodeMethod(String methodName) {
        void var2_2;
        Method method = (Method)this.org$apache$spark$sql$store$CodeGeneration$$allMethods.find((Function1)new Serializable(methodName){
            public static final long serialVersionUID = 0L;
            private final String methodName$1;

            public final boolean apply(Method x$1) {
                return x$1.getName().endsWith(this.methodName$1);
            }
            {
                this.methodName$1 = methodName$1;
            }
        }).getOrElse((Function0)new Serializable(methodName){
            public static final long serialVersionUID = 0L;
            private final String methodName$1;

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find method ", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.methodName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GenerateUnsafeProjection (methods=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGeneration$.MODULE$.org$apache$spark$sql$store$CodeGeneration$$allMethods.toSeq()}))).toString());
            }
            {
                this.methodName$1 = methodName$1;
            }
        });
        method.setAccessible(true);
        return var2_2;
    }

    private String generateComplexTypeCode(Method method, Seq<Object> typeArgs) {
        return (String)method.invoke((Object)GenerateUnsafeProjection$.MODULE$, (Object[])typeArgs.toArray(ClassTag$.MODULE$.Object()));
    }

    public Tuple2<String, String> org$apache$spark$sql$store$CodeGeneration$$getColumnSetterFragment(int col, DataType dataType, JdbcDialect dialect, CodeGenContext ctx, String buffHolderVar) {
        String string;
        DataType dataType2 = dataType;
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        DataType dataType3 = dataType2;
        if (!(integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null)) {
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setInt(", ", row.getInt(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
        } else {
            LongType$ longType$ = LongType$.MODULE$;
            DataType dataType4 = dataType2;
            if (!(longType$ != null ? !longType$.equals(dataType4) : dataType4 != null)) {
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setLong(", ", row.getLong(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
            } else {
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                DataType dataType5 = dataType2;
                if (!(doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null)) {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setDouble(", ", row.getDouble(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                } else {
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    DataType dataType6 = dataType2;
                    if (!(floatType$ != null ? !floatType$.equals(dataType6) : dataType6 != null)) {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setFloat(", ", row.getFloat(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                    } else {
                        ShortType$ shortType$ = ShortType$.MODULE$;
                        DataType dataType7 = dataType2;
                        if (!(shortType$ != null ? !shortType$.equals(dataType7) : dataType7 != null)) {
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setInt(", ", row.getShort(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                        } else {
                            ByteType$ byteType$ = ByteType$.MODULE$;
                            DataType dataType8 = dataType2;
                            if (!(byteType$ != null ? !byteType$.equals(dataType8) : dataType8 != null)) {
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setInt(", ", row.getByte(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                            } else {
                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                DataType dataType9 = dataType2;
                                if (!(booleanType$ != null ? !booleanType$.equals(dataType9) : dataType9 != null)) {
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setBoolean(", ", row.getBoolean(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                                } else {
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    DataType dataType10 = dataType2;
                                    if (!(stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null)) {
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setString(", ", row.getString(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                                    } else {
                                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                        DataType dataType11 = dataType2;
                                        if (!(binaryType$ != null ? !binaryType$.equals(dataType11) : dataType11 != null)) {
                                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setBytes(", ", row.getBinary(", "));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                                        } else {
                                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                            DataType dataType12 = dataType2;
                                            if (!(timestampType$ != null ? !timestampType$.equals(dataType12) : dataType12 != null)) {
                                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        stmt.setTimestamp(", ",\n          DateTimeUtils.toJavaTimestamp(row.getLong(", ")));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                                            } else {
                                                DateType$ dateType$ = DateType$.MODULE$;
                                                DataType dataType13 = dataType2;
                                                if (!(dateType$ != null ? !dateType$.equals(dataType13) : dataType13 != null)) {
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        stmt.setDate(", ",\n          DateTimeUtils.toJavaDate(row.getInt(", ")));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col)}));
                                                } else if (dataType2 instanceof DecimalType) {
                                                    DecimalType decimalType = (DecimalType)dataType2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        stmt.setBigDecimal(", ",\n          row.getDecimal(", ", ", ", ", ").toJavaBigDecimal());"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col), BoxesRunTime.boxToInteger((int)decimalType.precision()), BoxesRunTime.boxToInteger((int)decimalType.scale())}));
                                                } else if (dataType2 instanceof ArrayType) {
                                                    ArrayType arrayType = (ArrayType)dataType2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ArrayData arr = row.getArray(", ");\n        if (", " == null) {\n          ", " = new BufferHolder();\n        } else {\n          ", ".reset();\n        }\n        ", "\n        stmt.setBytes(", ", java.util.Arrays.copyOf(\n            ", ".buffer, ", ".totalSize()));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)col), buffHolderVar, buffHolderVar, buffHolderVar, this.generateComplexTypeCode(this.generateArrayCodeMethod, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{ctx, "arr", arrayType.elementType(), buffHolderVar})), BoxesRunTime.boxToInteger((int)(col + 1)), buffHolderVar, buffHolderVar}));
                                                } else if (dataType2 instanceof MapType) {
                                                    MapType mapType = (MapType)dataType2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        MapData map = row.getMap(", ");\n        if (", " == null) {\n          ", " = new BufferHolder();\n        } else {\n          ", ".reset();\n        }\n        ", "\n        stmt.setBytes(", ", java.util.Arrays.copyOf(\n           ", ".buffer, ", ".totalSize()));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)col), buffHolderVar, buffHolderVar, buffHolderVar, this.generateComplexTypeCode(this.generateMapCodeMethod, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{ctx, "map", mapType.keyType(), mapType.valueType(), buffHolderVar})), BoxesRunTime.boxToInteger((int)(col + 1)), buffHolderVar, buffHolderVar}));
                                                } else if (dataType2 instanceof StructType) {
                                                    StructType structType = (StructType)dataType2;
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        InternalRow struct = row.getStruct(", ", ", ");\n        if (", " == null) {\n          ", " = new BufferHolder();\n        } else {\n          ", ".reset();\n        }\n        ", "\n        stmt.setBytes(", ", java.util.Arrays.copyOf(\n            ", ".buffer, ", ".totalSize()));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)col), BoxesRunTime.boxToInteger((int)structType.length()), buffHolderVar, buffHolderVar, buffHolderVar, this.generateComplexTypeCode(this.generateStructCodeMethod, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{ctx, "struct", Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])structType.fields()).map((Function1)new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final DataType apply(StructField x$2) {
                                                            return x$2.dataType();
                                                        }
                                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))).toSeq(), buffHolderVar})), BoxesRunTime.boxToInteger((int)(col + 1)), buffHolderVar, buffHolderVar}));
                                                } else {
                                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setObject(", ", row.get(", ", schema[", "].dataType()));"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1)), BoxesRunTime.boxToInteger((int)col), BoxesRunTime.boxToInteger((int)col)}));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        String nonNullCode = string;
        return new Tuple2((Object)nonNullCode, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmt.setNull(", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(col + 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ExternalStoreUtils$.MODULE$.getJDBCType(dialect, (DataType)NullType$.MODULE$))}))).toString());
    }

    public CodeGeneration org$apache$spark$sql$store$CodeGeneration$$compilePreparedUpdate(String table, StructField[] schema, JdbcDialect dialect) {
        CodeGenContext ctx = new CodeGenContext();
        String bufferHolderVar = ctx.freshName("bufferHolder");
        String bufferHolderClass = BufferHolder.class.getName();
        ctx.addMutableState(bufferHolderClass, bufferHolderVar, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = null;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bufferHolderVar})));
        StringBuilder sb = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])schema).indices().foreach((Function1)new Serializable(schema, dialect, ctx, bufferHolderVar, sb){
            public static final long serialVersionUID = 0L;
            private final StructField[] schema$2;
            private final JdbcDialect dialect$1;
            private final CodeGenContext ctx$1;
            private final String bufferHolderVar$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int col) {
                Tuple2<String, String> tuple2 = CodeGeneration$.MODULE$.org$apache$spark$sql$store$CodeGeneration$$getColumnSetterFragment(col, this.schema$2[col].dataType(), this.dialect$1, this.ctx$1, this.bufferHolderVar$1);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    String nonNullCode = (String)tuple2._1();
                    String nullCode = (String)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)nonNullCode, (Object)nullCode);
                    String nonNullCode2 = (String)tuple23._1();
                    String nullCode2 = (String)tuple23._2();
                    return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        if (!row.isNullAt(", ")) {\n          ", "\n        } else {\n          ", "\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)col), nonNullCode2, nullCode2})));
                }
                throw new MatchError(tuple2);
            }
            {
                this.schema$2 = schema$2;
                this.dialect$1 = dialect$1;
                this.ctx$1 = ctx$1;
                this.bufferHolderVar$1 = bufferHolderVar$1;
                this.sb$1 = sb$1;
            }
        });
        IScriptEvaluator evaluator = new CompilerFactory().newScriptEvaluator();
        evaluator.setClassName("io.snappydata.execute.GeneratedEvaluation");
        evaluator.setParentClassLoader(this.getClass().getClassLoader());
        evaluator.setDefaultImports((String[])((Object[])new String[]{bufferHolderClass, DateTimeUtils$.MODULE$.getClass().getName().replace("$", ""), Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), MutableRow.class.getName()}));
        String separator = "\n      ";
        ArrayBuffer varDeclarations = (ArrayBuffer)ctx.mutableStates().map((Function1)new Serializable(separator){
            public static final long serialVersionUID = 0L;
            private final String separator$1;

            public final String apply(Tuple3<String, String, String> x0$1) {
                Tuple3<String, String, String> tuple3 = x0$1;
                if (tuple3 != null) {
                    String javaType = (String)tuple3._1();
                    String name = (String)tuple3._2();
                    String init = (String)tuple3._3();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ";", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{javaType, name, this.separator$1, init.replace("this.", "")}));
                    return string;
                }
                throw new MatchError(tuple3);
            }
            {
                this.separator$1 = separator$1;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        String expression = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      int rowCount = 0;\n      int totalRowCount = 0;\n      int result = 0;\n      while (rows.hasNext()) {\n        InternalRow row = (InternalRow)rows.next();\n        ", "\n        rowCount++;\n        totalRowCount++;\n        if (multipleRows) {\n          stmt.addBatch();\n          if ((rowCount % batchSize) == 0) {\n            result += stmt.executeBatch().length;\n            rowCount = 0;\n          }\n        }\n      }\n      if (multipleRows) {\n        if (rowCount > 0) {\n          result += stmt.executeBatch().length;\n        }\n      } else {\n        result += stmt.executeUpdate();\n      }\n      return result;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{varDeclarations.mkString(separator), sb.toString()}));
        return (CodeGeneration)evaluator.createFastEvaluator(expression, CodeGeneration.class, (String[])((Object[])new String[]{"stmt", "multipleRows", "rows", "batchSize", "schema", "dialect"}));
    }

    public int executeUpdate(String name, PreparedStatement stmt, Iterator<InternalRow> rows, boolean multipleRows, int batchSize, StructField[] schema, JdbcDialect dialect) {
        CodeGeneration result = (CodeGeneration)this.cache.get((Object)new ExecuteKey(name, schema, dialect));
        return result.executeStatement(stmt, multipleRows, (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(rows).asJava(), batchSize, schema, dialect);
    }

    public int executeUpdate(String name, PreparedStatement stmt, Seq<Row> rows, boolean multipleRows, int batchSize, StructField[] schema, JdbcDialect dialect) {
        CodeGeneration result = (CodeGeneration)this.cache.get((Object)new ExecuteKey(name, schema, dialect));
        java.util.Iterator<InternalRow> iterator = new java.util.Iterator<InternalRow>(rows, schema){
            private final Iterator<Row> baseIterator;
            private final WrappedRow internalRow;

            private Iterator<Row> baseIterator() {
                return this.baseIterator;
            }

            private WrappedRow internalRow() {
                return this.internalRow;
            }

            public boolean hasNext() {
                return this.baseIterator().hasNext();
            }

            public InternalRow next() {
                this.internalRow().row_$eq((Row)this.baseIterator().next());
                return this.internalRow();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
            {
                this.baseIterator = rows$1.iterator();
                this.internalRow = new WrappedRow(schema$1);
            }
        };
        return result.executeStatement(stmt, multipleRows, iterator, batchSize, schema, dialect);
    }

    public int executeUpdate(String name, PreparedStatement stmt, Row row, StructField[] schema, JdbcDialect dialect) {
        CodeGeneration result = (CodeGeneration)this.cache.get((Object)new ExecuteKey(name, schema, dialect));
        WrappedRow internalRow = new WrappedRow(schema);
        internalRow.row_$eq(row);
        return result.executeStatement(stmt, false, Collections.singleton(internalRow).iterator(), 0, schema, dialect);
    }

    public void removeCache(String name) {
        this.cache.invalidate((Object)new ExecuteKey(name, null, null));
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    private CodeGeneration$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.cache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new anon.1());
        this.org$apache$spark$sql$store$CodeGeneration$$allMethods = Predef$.MODULE$.refArrayOps((Object[])GenerateUnsafeProjection$.MODULE$.getClass().getDeclaredMethods()).toIndexedSeq();
        this.generateArrayCodeMethod = this.getComplexTypeCodeMethod("writeArrayToBuffer");
        this.generateMapCodeMethod = this.getComplexTypeCodeMethod("writeMapToBuffer");
        this.generateStructCodeMethod = this.getComplexTypeCodeMethod("writeStructToBuffer");
    }
}

