/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.spark.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.datasources.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.sources.ExternalSchemaRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.store.CodeGeneration$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.control.NonFatal$;

public final class JdbcExtendedUtils$
implements Logging {
    public static final JdbcExtendedUtils$ MODULE$;
    private final String DBTABLE_PROPERTY;
    private final String SCHEMA_PROPERTY;
    private final String ALLOW_EXISTING_PROPERTY;
    private final String BASETABLE_PROPERTY;
    private final String TABLETYPE_PROPERTY;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JdbcExtendedUtils$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String DBTABLE_PROPERTY() {
        return this.DBTABLE_PROPERTY;
    }

    public String SCHEMA_PROPERTY() {
        return this.SCHEMA_PROPERTY;
    }

    public String ALLOW_EXISTING_PROPERTY() {
        return this.ALLOW_EXISTING_PROPERTY;
    }

    public String BASETABLE_PROPERTY() {
        return this.BASETABLE_PROPERTY;
    }

    public String TABLETYPE_PROPERTY() {
        return this.TABLETYPE_PROPERTY;
    }

    public void executeUpdate(String sql, Connection conn) {
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(sql);
            return;
        }
        finally {
            stmt.close();
        }
    }

    public String schemaString(StructType schema, JdbcDialect dialect) {
        Object object;
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            object = new Serializable(jdbcExtendedDialect){
                public static final long serialVersionUID = 0L;
                private final JdbcExtendedDialect x2$1;

                public final Option<JdbcType> apply(DataType dataType, Metadata md) {
                    return this.x2$1.getJDBCType(dataType, md);
                }
                {
                    this.x2$1 = x2$1;
                }
            };
        } else {
            object = new Serializable(dialect){
                public static final long serialVersionUID = 0L;
                private final JdbcDialect dialect$1;

                public final Option<JdbcType> apply(DataType dataType, Metadata x$1) {
                    return this.dialect$1.getJDBCType(dataType);
                }
                {
                    this.dialect$1 = dialect$1;
                }
            };
        }
        Serializable jdbcType = object;
        StringBuilder sb = new StringBuilder();
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable((Function2)jdbcType, sb){
            public static final long serialVersionUID = 0L;
            private final Function2 jdbcType$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(StructField field) {
                DataType dataType = field.dataType();
                String typeString = (String)((Option)this.jdbcType$1.apply((Object)dataType, (Object)field.metadata())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(JdbcType x$2) {
                        return x$2.databaseTypeDefinition();
                    }
                }).getOrElse((Function0)new Serializable(this, field, dataType){
                    public static final long serialVersionUID = 0L;
                    private final StructField field$1;
                    private final DataType dataType$1;

                    public final String apply() {
                        block14: {
                            String string;
                            block3: {
                                DecimalType decimalType;
                                Option option;
                                DataType dataType;
                                block13: {
                                    block12: {
                                        block11: {
                                            block10: {
                                                block9: {
                                                    block8: {
                                                        block7: {
                                                            block6: {
                                                                block5: {
                                                                    block4: {
                                                                        block2: {
                                                                            dataType = this.dataType$1;
                                                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                                            DataType dataType2 = dataType;
                                                                            if (integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null) break block2;
                                                                            string = "INTEGER";
                                                                            break block3;
                                                                        }
                                                                        LongType$ longType$ = LongType$.MODULE$;
                                                                        DataType dataType3 = dataType;
                                                                        if (longType$ != null ? !longType$.equals(dataType3) : dataType3 != null) break block4;
                                                                        string = "BIGINT";
                                                                        break block3;
                                                                    }
                                                                    DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                                    DataType dataType4 = dataType;
                                                                    if (doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null) break block5;
                                                                    string = "DOUBLE PRECISION";
                                                                    break block3;
                                                                }
                                                                FloatType$ floatType$ = FloatType$.MODULE$;
                                                                DataType dataType5 = dataType;
                                                                if (floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null) break block6;
                                                                string = "REAL";
                                                                break block3;
                                                            }
                                                            ShortType$ shortType$ = ShortType$.MODULE$;
                                                            DataType dataType6 = dataType;
                                                            if (shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null) break block7;
                                                            string = "INTEGER";
                                                            break block3;
                                                        }
                                                        ByteType$ byteType$ = ByteType$.MODULE$;
                                                        DataType dataType7 = dataType;
                                                        if (byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null) break block8;
                                                        string = "BYTE";
                                                        break block3;
                                                    }
                                                    BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                    DataType dataType8 = dataType;
                                                    if (booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null) break block9;
                                                    string = "BIT(1)";
                                                    break block3;
                                                }
                                                StringType$ stringType$ = StringType$.MODULE$;
                                                DataType dataType9 = dataType;
                                                if (stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) break block10;
                                                string = "TEXT";
                                                break block3;
                                            }
                                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                            DataType dataType10 = dataType;
                                            if (binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null) break block11;
                                            string = "BLOB";
                                            break block3;
                                        }
                                        TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                        DataType dataType11 = dataType;
                                        if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block12;
                                        string = "TIMESTAMP";
                                        break block3;
                                    }
                                    DateType$ dateType$ = DateType$.MODULE$;
                                    DataType dataType12 = dataType;
                                    if (dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null) break block13;
                                    string = "DATE";
                                    break block3;
                                }
                                if (!(dataType instanceof DecimalType) || (option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) break block14;
                                int precision = ((Tuple2)option.get())._1$mcI$sp();
                                int scale = ((Tuple2)option.get())._2$mcI$sp();
                                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DECIMAL(", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)precision), BoxesRunTime.boxToInteger((int)scale)}));
                            }
                            return string;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Don't know how to save ", " to JDBC"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1})));
                    }
                    {
                        this.field$1 = field$1;
                        this.dataType$1 = dataType$1;
                    }
                });
                String nullable = field.nullable() ? "" : "NOT NULL";
                return this.sb$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.name(), typeString, nullable})));
            }
            {
                this.jdbcType$1 = jdbcType$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.length() < 2 ? "" : "(".concat(sb.substring(2)).concat(")");
    }

    public boolean tableExistsInMetaData(String table, Connection conn, JdbcDialect dialect) {
        boolean bl;
        int dotIndex = table.indexOf(46);
        String schemaName = dotIndex > 0 ? table.substring(0, dotIndex) : conn.getSchema();
        String tableName = dotIndex > 0 ? table.substring(dotIndex + 1) : table;
        try {
            ResultSet rs = conn.getMetaData().getTables(null, schemaName, tableName, null);
            bl = rs.next();
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public void createSchema(String schemaName, Connection conn, JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            jdbcExtendedDialect.createSchema(schemaName, conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean tableExists(String table, Connection conn, JdbcDialect dialect, SQLContext context2) {
        boolean bl;
        Object object = new Object();
        try {
            boolean bl2;
            JdbcDialect jdbcDialect = dialect;
            if (jdbcDialect instanceof JdbcExtendedDialect) {
                JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
                bl2 = jdbcExtendedDialect.tableExists(table, conn, context2);
            } else {
                boolean bl3;
                try {
                    bl3 = this.tableExistsInMetaData(table, conn, dialect);
                }
                catch (Throwable throwable) {
                    boolean bl4;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Statement stmt = conn.createStatement();
                    String[] testQueries = (String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM ", " FETCH FIRST ROW ONLY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT COUNT(1) FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))});
                    Predef$.MODULE$.refArrayOps((Object[])testQueries).foreach((Function1)new Serializable(stmt, object){
                        public static final long serialVersionUID = 0L;
                        private final Statement stmt$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(String q) {
                            try {
                                ResultSet rs = this.stmt$1.executeQuery(q);
                                rs.next();
                                rs.close();
                                this.stmt$1.close();
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (option.isEmpty()) {
                                    throw throwable;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        {
                            this.stmt$1 = stmt$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    bl3 = bl4 = false;
                }
                bl2 = bl3;
            }
            bl = bl2;
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                bl = nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
        return bl;
    }

    public void dropTable(Connection conn, String tableName, JdbcDialect dialect, SQLContext context2, boolean ifExists) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            jdbcExtendedDialect.dropTable(tableName, conn, context2, ifExists);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (ifExists && !this.tableExists(tableName, conn, dialect, context2)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public void truncateTable(Connection conn, String tableName, JdbcDialect dialect) {
        JdbcDialect jdbcDialect = dialect;
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            this.executeUpdate(jdbcExtendedDialect.truncateTable(tableName), conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.executeUpdate(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), conn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResolvedDataSource externalResolvedDataSource(SQLContext sqlContext, String schemaString2, String provider, SaveMode mode, Map<String, String> options) {
        void var6_6;
        Class clazz = ResolvedDataSource$.MODULE$.lookupDataSource(provider);
        Object t = clazz.newInstance();
        if (t instanceof ExternalSchemaRelationProvider) {
            BaseRelation baseRelation;
            Object t2 = t;
            BaseRelation relation = baseRelation = ((ExternalSchemaRelationProvider)t2).createRelation(sqlContext, mode, (Map<String, String>)new CaseInsensitiveMap(options.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.SCHEMA_PROPERTY()), (Object)schemaString2))), schemaString2);
            return new ResolvedDataSource(clazz, relation);
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not an ExternalSchemaRelationProvider."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6.getCanonicalName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
    }

    public PreparedStatement insertStatement(Connection conn, String table, StructType rddSchema, boolean upsert) {
        StringBuilder sql = new StringBuilder();
        StringBuilder stringBuilder = upsert ? sql.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PUT INTO ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))) : sql.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        IntRef fieldsLeft = new IntRef(rddSchema.fields().length);
        Predef$.MODULE$.refArrayOps((Object[])rddSchema.fields()).foreach((Function1)new Serializable(sql, fieldsLeft){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sql$1;
            private final IntRef fieldsLeft$1;

            public final void apply(StructField field) {
                this.sql$1.append(field.name());
                StringBuilder stringBuilder = this.fieldsLeft$1.elem > 1 ? this.sql$1.append(',') : this.sql$1.append(')');
                --this.fieldsLeft$1.elem;
            }
            {
                this.sql$1 = sql$1;
                this.fieldsLeft$1 = fieldsLeft$1;
            }
        });
        sql.append(" VALUES (");
        fieldsLeft.elem = rddSchema.fields().length;
        while (fieldsLeft.elem > 0) {
            sql.append('?');
            StringBuilder stringBuilder2 = fieldsLeft.elem > 1 ? sql.append(',') : sql.append(')');
            --fieldsLeft.elem;
        }
        return conn.prepareStatement(sql.toString());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void savePartition(Function0<Connection> getConnection, String table, Iterator<InternalRow> iterator, StructType rddSchema, JdbcDialect dialect, int batchSize, boolean upsert) {
        block13: {
            if (iterator.hasNext()) {
                boolean committed;
                Connection conn;
                block12: {
                    conn = (Connection)getConnection.apply();
                    committed = false;
                    PreparedStatement stmt = this.insertStatement(conn, table, rddSchema, upsert);
                    CodeGeneration$.MODULE$.executeUpdate(table, stmt, iterator, true, batchSize, rddSchema.fields(), dialect);
                    stmt.close();
                    conn.commit();
                    committed = true;
                    if (!committed) break block12;
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        this.logWarning((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Transaction succeeded, but closing failed";
                            }
                        }, exception);
                    }
                }
                conn.rollback();
                conn.close();
                break block13;
                {
                    catch (Throwable throwable) {
                        try {
                            void var12_10;
                            var12_10.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (committed) {
                                try {
                                    conn.close();
                                }
                                catch (Exception exception) {
                                    this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                                }
                            } else {
                                conn.rollback();
                                conn.close();
                            }
                            throw throwable2;
                        }
                    }
                }
            }
        }
    }

    public void saveTable(DataFrame df, String table, ConnectionProperties connProperties, boolean upsert) {
        StructType rddSchema = df.schema();
        Function0<Connection> getConnection = ExternalStoreUtils$.MODULE$.getConnector(table, connProperties, true);
        int batchSize = new StringOps(Predef$.MODULE$.augmentString(connProperties.connProps().getProperty("batchsize", "1000"))).toInt();
        df.queryExecution().toRdd().foreachPartition((Function1)new Serializable(table, connProperties, upsert, rddSchema, getConnection, batchSize){
            public static final long serialVersionUID = 0L;
            private final String table$1;
            private final ConnectionProperties connProperties$1;
            private final boolean upsert$1;
            private final StructType rddSchema$1;
            private final Function0 getConnection$1;
            private final int batchSize$1;

            public final void apply(Iterator<InternalRow> iterator) {
                JdbcExtendedUtils$.MODULE$.savePartition((Function0<Connection>)this.getConnection$1, this.table$1, iterator, this.rddSchema$1, this.connProperties$1.dialect(), this.batchSize$1, this.upsert$1);
            }
            {
                this.table$1 = table$1;
                this.connProperties$1 = connProperties$1;
                this.upsert$1 = upsert$1;
                this.rddSchema$1 = rddSchema$1;
                this.getConnection$1 = getConnection$1;
                this.batchSize$1 = batchSize$1;
            }
        });
    }

    public boolean saveTable$default$4() {
        return false;
    }

    private JdbcExtendedUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DBTABLE_PROPERTY = "dbtable";
        this.SCHEMA_PROPERTY = "schemaddl";
        this.ALLOW_EXISTING_PROPERTY = "allowexisting";
        this.BASETABLE_PROPERTY = "basetable";
        this.TABLETYPE_PROPERTY = "EXTERNAL";
    }
}

