/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.row;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificMutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.columnar.ResultSetIterator;
import org.apache.spark.sql.execution.row.InternalRowIteratorOnRS$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0003\u001f\t9\u0012J\u001c;fe:\fGNU8x\u0013R,'/\u0019;pe>s'k\u0015\u0006\u0003\u0007\u0011\t1A]8x\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0004#Q1R\"\u0001\n\u000b\u0005M!\u0011\u0001C2pYVlg.\u0019:\n\u0005U\u0011\"!\u0005*fgVdGoU3u\u0013R,'/\u0019;peB\u0011qCG\u0007\u00021)\u0011\u0011DB\u0001\tG\u0006$\u0018\r\\=ti&\u00111\u0004\u0007\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0011\u0019wN\u001c8\u0011\u0005}\u0019S\"\u0001\u0011\u000b\u0005\u001d\t#\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I\u0001\u0012!bQ8o]\u0016\u001cG/[8o\u0011!1\u0003A!A!\u0002\u00139\u0013\u0001B:u[R\u0004\"a\b\u0015\n\u0005%\u0002#!C*uCR,W.\u001a8u\u0011!Y\u0003A!A!\u0002\u0013a\u0013A\u0001:t!\tyR&\u0003\u0002/A\tI!+Z:vYR\u001cV\r\u001e\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u000591m\u001c8uKb$\bC\u0001\u001a4\u001b\u0005A\u0011B\u0001\u001b\t\u0005-!\u0016m]6D_:$X\r\u001f;\t\u0011Y\u0002!\u0011!Q\u0001\n]\naa]2iK6\f\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0007\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0014H\u0001\u0006TiJ,8\r\u001e+za\u0016DQA\u0010\u0001\u0005\u0002}\na\u0001P5oSRtDC\u0002!C\u0007\u0012+e\t\u0005\u0002B\u00015\t!\u0001C\u0003\u001e{\u0001\u0007a\u0004C\u0003'{\u0001\u0007q\u0005C\u0003,{\u0001\u0007A\u0006C\u00031{\u0001\u0007\u0011\u0007C\u00037{\u0001\u0007q\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u0013\t\u0004\u00132sU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\u000b\u0005\u0013(/Y=\u0011\u0005az\u0015B\u0001):\u0005!!\u0015\r^1UsB,\u0007B\u0002*\u0001A\u0003%1+\u0001\u0006nkR\f'\r\\3S_^\u0004\"\u0001V,\u000e\u0003US!A\u0016\r\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u00031V\u0013!c\u00159fG&4\u0017nY'vi\u0006\u0014G.\u001a*po\")!\f\u0001C!7\u0006aq-\u001a;OKb$h+\u00197vKR\u0011a\u0003\u0018\u0005\u0006We\u0003\r\u0001\f")
public final class InternalRowIteratorOnRS
extends ResultSetIterator<InternalRow> {
    private final StructType schema;
    private final DataType[] types;
    private final SpecificMutableRow mutableRow;

    @Override
    public InternalRow getNextValue(ResultSet rs) {
        for (int i = 0; i < this.types.length; ++i) {
            DecimalType decimalType;
            Option option;
            BoxedUnit boxedUnit;
            int pos = i + 1;
            DataType dataType = this.types[i];
            StringType$ stringType$ = StringType$.MODULE$;
            DataType dataType2 = dataType;
            if (!(stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null)) {
                this.mutableRow.update(i, (Object)UTF8String.fromString((String)rs.getString(pos)));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            DataType dataType3 = dataType;
            if (!(integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null)) {
                BoxedUnit boxedUnit2;
                int iv = rs.getInt(pos);
                if (iv == 0 && rs.wasNull()) {
                    this.mutableRow.setNullAt(i);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setInt(i, iv);
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            LongType$ longType$ = LongType$.MODULE$;
            DataType dataType4 = dataType;
            if (!(longType$ != null ? !longType$.equals(dataType4) : dataType4 != null)) {
                BoxedUnit boxedUnit3;
                if (this.schema.fields()[i].metadata().contains("binarylong")) {
                    byte[] bytes = rs.getBytes(pos);
                    if (bytes != null) {
                        long lv = 0L;
                        for (int j = 0; j < Predef$.MODULE$.byteArrayOps(bytes).size(); ++j) {
                            lv = 256L * lv + (long)(0xFF & bytes[j]);
                        }
                        this.mutableRow.setLong(i, lv);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        this.mutableRow.setNullAt(i);
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    long lv = rs.getLong(pos);
                    if (lv == 0L && rs.wasNull()) {
                        this.mutableRow.setNullAt(i);
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        this.mutableRow.setLong(i, lv);
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                }
                boxedUnit = boxedUnit3;
                continue;
            }
            DoubleType$ doubleType$ = DoubleType$.MODULE$;
            DataType dataType5 = dataType;
            if (!(doubleType$ != null ? !doubleType$.equals(dataType5) : dataType5 != null)) {
                BoxedUnit boxedUnit4;
                double dv = rs.getDouble(pos);
                if (rs.wasNull()) {
                    this.mutableRow.setNullAt(i);
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setDouble(i, dv);
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
                continue;
            }
            FloatType$ floatType$ = FloatType$.MODULE$;
            DataType dataType6 = dataType;
            if (!(floatType$ != null ? !floatType$.equals(dataType6) : dataType6 != null)) {
                BoxedUnit boxedUnit5;
                float fv = rs.getFloat(pos);
                if (rs.wasNull()) {
                    this.mutableRow.setNullAt(i);
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setFloat(i, fv);
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit5;
                continue;
            }
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            DataType dataType7 = dataType;
            if (!(booleanType$ != null ? !booleanType$.equals(dataType7) : dataType7 != null)) {
                BoxedUnit boxedUnit6;
                boolean bv = rs.getBoolean(pos);
                if (!bv && rs.wasNull()) {
                    this.mutableRow.setNullAt(i);
                    boxedUnit6 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setBoolean(i, bv);
                    boxedUnit6 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit6;
                continue;
            }
            if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                BoxedUnit boxedUnit7;
                int p = ((Tuple2)option.get())._1$mcI$sp();
                int s = ((Tuple2)option.get())._2$mcI$sp();
                BigDecimal decimalVal = rs.getBigDecimal(pos);
                if (decimalVal != null) {
                    this.mutableRow.update(i, (Object)Decimal$.MODULE$.apply(decimalVal, p, s));
                    boxedUnit7 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setNullAt(i);
                    boxedUnit7 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit7;
                continue;
            }
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            DataType dataType8 = dataType;
            if (!(timestampType$ != null ? !timestampType$.equals(dataType8) : dataType8 != null)) {
                BoxedUnit boxedUnit8;
                Timestamp t = rs.getTimestamp(pos);
                if (t != null) {
                    this.mutableRow.setLong(i, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                    boxedUnit8 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setNullAt(i);
                    boxedUnit8 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit8;
                continue;
            }
            DateType$ dateType$ = DateType$.MODULE$;
            DataType dataType9 = dataType;
            if (!(dateType$ != null ? !dateType$.equals(dataType9) : dataType9 != null)) {
                BoxedUnit boxedUnit9;
                Date dateVal = rs.getDate(pos);
                if (dateVal != null) {
                    this.mutableRow.setInt(i, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
                    boxedUnit9 = BoxedUnit.UNIT;
                } else {
                    this.mutableRow.setNullAt(i);
                    boxedUnit9 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit9;
                continue;
            }
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            DataType dataType10 = dataType;
            if (!(binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null)) {
                this.mutableRow.update(i, (Object)rs.getBytes(pos));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof ArrayType) {
                byte[] bytes = rs.getBytes(pos);
                UnsafeArrayData array = new UnsafeArrayData();
                array.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, bytes.length);
                this.mutableRow.update(i, (Object)array);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof MapType) {
                byte[] bytes = rs.getBytes(pos);
                UnsafeMapData map = new UnsafeMapData();
                map.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, bytes.length);
                this.mutableRow.update(i, (Object)map);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                byte[] bytes = rs.getBytes(pos);
                UnsafeRow row = new UnsafeRow();
                row.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, structType.fields().length, bytes.length);
                this.mutableRow.update(i, (Object)row);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema.fields()[i]})));
        }
        return this.mutableRow;
    }

    public InternalRowIteratorOnRS(Connection conn, Statement stmt, ResultSet rs, TaskContext context2, StructType schema) {
        this.schema = schema;
        super(conn, stmt, rs, context2);
        this.types = (DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new $anonfun$3(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        this.mutableRow = new SpecificMutableRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.types));
    }
}

