/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import io.snappydata.Constant$;
import io.snappydata.util.ServiceUtils$;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.ClusterMode;
import org.apache.spark.sql.ExternalClusterMode;
import org.apache.spark.sql.ExternalEmbeddedMode;
import org.apache.spark.sql.LocalMode;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SnappyContext$;
import org.apache.spark.sql.SnappyEmbeddedMode;
import org.apache.spark.sql.SnappyShellMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.SpecificMutableRow;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.collection.Utils$StringExtensions$;
import org.apache.spark.sql.execution.ConnectionPool$;
import org.apache.spark.sql.execution.columnar.CachedBatch;
import org.apache.spark.sql.execution.columnar.ColumnAccessor;
import org.apache.spark.sql.execution.columnar.ColumnAccessor$;
import org.apache.spark.sql.execution.columnar.ConnectionType$;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$$anonfun$pruneSchema$1$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.row.GemFireXDClientDialect$;
import org.apache.spark.sql.row.GemFireXDDialect$;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.store.CodeGeneration$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class ExternalStoreUtils$ {
    public static final ExternalStoreUtils$ MODULE$;
    private final String DEFAULT_TABLE_BUCKETS;
    private final String DEFAULT_SAMPLE_TABLE_BUCKETS;
    private final String DEFAULT_TABLE_BUCKETS_LOCAL_MODE;
    private final String DEFAULT_SAMPLE_TABLE_BUCKETS_LOCAL_MODE;
    private final String INDEX_TYPE;
    private final String INDEX_NAME;
    private final String PARTITION_BY;
    private final String REPLICATE;
    private final String BUCKETS;

    static {
        new ExternalStoreUtils$();
    }

    public final String DEFAULT_TABLE_BUCKETS() {
        return "113";
    }

    public final String DEFAULT_SAMPLE_TABLE_BUCKETS() {
        return "53";
    }

    public final String DEFAULT_TABLE_BUCKETS_LOCAL_MODE() {
        return "11";
    }

    public final String DEFAULT_SAMPLE_TABLE_BUCKETS_LOCAL_MODE() {
        return "7";
    }

    public final String INDEX_TYPE() {
        return "INDEX_TYPE";
    }

    public final String INDEX_NAME() {
        return "INDEX_NAME";
    }

    private scala.collection.immutable.Map<String, String> addProperty(scala.collection.immutable.Map<String, String> props, String key, String string) {
        return props.contains((Object)key) ? props : props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)string));
    }

    private String defaultMaxExternalPoolSize() {
        return String.valueOf(package$.MODULE$.max(32, Runtime.getRuntime().availableProcessors() * 4));
    }

    private String defaultMaxEmbeddedPoolSize() {
        return String.valueOf(package$.MODULE$.max(64, Runtime.getRuntime().availableProcessors() * 6));
    }

    public scala.collection.immutable.Map<String, String> getAllPoolProperties(String url, String driver, scala.collection.immutable.Map<String, String> poolProps, boolean hikariCP, boolean isEmbedded) {
        String defaultMaxPoolSize;
        scala.collection.immutable.Map<String, String> props = poolProps;
        if (driver != null && !driver.isEmpty()) {
            props = this.addProperty(props, "driverClassName", driver);
        }
        String string = defaultMaxPoolSize = isEmbedded ? this.defaultMaxEmbeddedPoolSize() : this.defaultMaxExternalPoolSize();
        if (hikariCP) {
            props = props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"jdbcUrl"), (Object)url));
            props = this.addProperty(props, "maximumPoolSize", defaultMaxPoolSize);
            props = this.addProperty(props, "minimumIdle", "4");
        } else {
            props = props.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)url));
            props = this.addProperty(props, "maxActive", defaultMaxPoolSize);
            props = this.addProperty(props, "initialSize", "4");
        }
        return props;
    }

    public String getDriver(String url, JdbcDialect dialect) {
        String string;
        JdbcDialect jdbcDialect = dialect;
        GemFireXDDialect$ gemFireXDDialect$ = GemFireXDDialect$.MODULE$;
        JdbcDialect jdbcDialect2 = jdbcDialect;
        if (!(gemFireXDDialect$ != null ? !((Object)((Object)gemFireXDDialect$)).equals(jdbcDialect2) : jdbcDialect2 != null)) {
            string = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
        } else {
            GemFireXDClientDialect$ gemFireXDClientDialect$ = GemFireXDClientDialect$.MODULE$;
            JdbcDialect jdbcDialect3 = jdbcDialect;
            string = !(gemFireXDClientDialect$ != null ? !((Object)((Object)gemFireXDClientDialect$)).equals(jdbcDialect3) : jdbcDialect3 != null) ? "com.pivotal.gemfirexd.jdbc.ClientDriver" : Utils$.MODULE$.getDriverClassName(url);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String removeInternalProps(Map<String, String> parameters) {
        void var3_3;
        String dbtableProp = JdbcExtendedUtils$.MODULE$.DBTABLE_PROPERTY();
        String table = (String)parameters.remove((Object)dbtableProp).getOrElse((Function0)new Serializable(dbtableProp){
            public static final long serialVersionUID = 0L;
            private final String dbtableProp$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option '", "' not specified"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbtableProp$1})));
            }
            {
                this.dbtableProp$1 = dbtableProp$1;
            }
        });
        parameters.remove((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY());
        parameters.remove((Object)JdbcExtendedUtils$.MODULE$.SCHEMA_PROPERTY());
        parameters.remove((Object)"serialization.format");
        return var3_3;
    }

    public scala.collection.immutable.Map<String, String> removeSamplingOptions(Map<String, String> parameters) {
        Seq optSequence = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"qcs", "fraction", "strataReservoirSize", "errorLimitColumn", "errorLimitPercent", "timeSeriesColumn", "timeInterval"}));
        HashMap optMap = new HashMap();
        optSequence.map((Function1)new Serializable(parameters, optMap){
            public static final long serialVersionUID = 0L;
            private final Map parameters$1;
            private final HashMap optMap$1;

            public final Object apply(String key) {
                Option option;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        block2: {
                            Option value = this.parameters$1.remove((Object)key);
                            option = value;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            String v = (String)some.x();
                            boxedUnit = this.optMap$1.$plus$eq(new Tuple2((Object)Utils$StringExtensions$.MODULE$.normalize$extension(Utils$.MODULE$.StringExtensions(key)), (Object)v));
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)option);
            }
            {
                this.parameters$1 = parameters$1;
                this.optMap$1 = optMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return optMap.toMap(Predef$.MODULE$.conforms());
    }

    public String defaultStoreURL(SparkContext sc) {
        ClusterMode clusterMode;
        block8: {
            String string;
            block5: {
                block7: {
                    block6: {
                        block4: {
                            clusterMode = SnappyContext$.MODULE$.getClusterMode(sc);
                            if (!(clusterMode instanceof SnappyEmbeddedMode)) break block4;
                            string = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)";host-data=false;mcast-port=0").toString();
                            break block5;
                        }
                        if (!(clusterMode instanceof SnappyShellMode)) break block6;
                        string = new StringBuilder().append((Object)ServiceUtils$.MODULE$.getLocatorJDBCURL(sc)).append((Object)"/route-query=false").toString();
                        break block5;
                    }
                    if (!(clusterMode instanceof ExternalEmbeddedMode)) break block7;
                    ExternalEmbeddedMode externalEmbeddedMode = (ExternalEmbeddedMode)clusterMode;
                    String url = externalEmbeddedMode.url();
                    string = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)";host-data=false;").append((Object)url).toString();
                    break block5;
                }
                if (!(clusterMode instanceof LocalMode)) break block8;
                LocalMode localMode = (LocalMode)clusterMode;
                String url = localMode.url();
                string = new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_EMBEDDED_URL()).append((Object)BoxesRunTime.boxToCharacter((char)';')).append((Object)url).toString();
            }
            return string;
        }
        if (clusterMode instanceof ExternalClusterMode) {
            ExternalClusterMode externalClusterMode = (ExternalClusterMode)clusterMode;
            String url = externalClusterMode.url();
            throw new AnalysisException(new StringBuilder().append((Object)"Option 'url' not specified for cluster ").append((Object)url).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError((Object)clusterMode);
    }

    public boolean isShellOrLocalMode(SparkContext sparkContext) {
        ClusterMode clusterMode = SnappyContext$.MODULE$.getClusterMode(sparkContext);
        boolean bl = clusterMode instanceof SnappyShellMode ? true : clusterMode instanceof LocalMode;
        boolean bl2 = bl;
        return bl2;
    }

    public ConnectionProperties validateAndGetAllProps(SparkContext sc, Map<String, String> parameters) {
        Option option;
        block13: {
            boolean bl;
            boolean bl2;
            Option poolProperties;
            String driver;
            JdbcDialect dialect;
            String url;
            block11: {
                Some some;
                boolean bl3;
                block12: {
                    String string;
                    block10: {
                        String string2;
                        url = (String)parameters.remove((Object)"url").getOrElse((Function0)new Serializable(sc){
                            public static final long serialVersionUID = 0L;
                            private final SparkContext sc$1;

                            public final String apply() {
                                return ExternalStoreUtils$.MODULE$.defaultStoreURL(this.sc$1);
                            }
                            {
                                this.sc$1 = sc$1;
                            }
                        });
                        dialect = JdbcDialects$.MODULE$.get(url);
                        driver = (String)parameters.remove((Object)"driver").getOrElse((Function0)new Serializable(url, dialect){
                            public static final long serialVersionUID = 0L;
                            private final String url$1;
                            private final JdbcDialect dialect$1;

                            public final String apply() {
                                return ExternalStoreUtils$.MODULE$.getDriver(this.url$1, this.dialect$1);
                            }
                            {
                                this.url$1 = url$1;
                                this.dialect$1 = dialect$1;
                            }
                        });
                        DriverRegistry$.MODULE$.register(driver);
                        Option poolImpl = parameters.remove((Object)"poolimpl");
                        poolProperties = parameters.remove((Object)"poolproperties");
                        bl3 = false;
                        some = null;
                        option = poolImpl.map((Function1)new anonfun.5());
                        if (!(option instanceof Some)) break block10;
                        bl3 = true;
                        some = (Some)option;
                        String string3 = string2 = (String)some.x();
                        if ("hikari" != null ? !"hikari".equals(string3) : string3 != null) break block10;
                        bl2 = true;
                        break block11;
                    }
                    if (!bl3) break block12;
                    String string4 = string = (String)some.x();
                    if ("tomcat" != null ? !"tomcat".equals(string4) : string4 != null) break block12;
                    bl2 = false;
                    break block11;
                }
                if (bl3) {
                    String p = (String)some.x();
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"ExternalStoreUtils: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported pool implementation '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(supported values: tomcat, hikari)"})).s((Seq)Nil$.MODULE$)).toString());
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block13;
                bl2 = Constant$.MODULE$.DEFAULT_USE_HIKARICP();
            }
            boolean hikariCP = bl2;
            scala.collection.immutable.Map poolProps = (scala.collection.immutable.Map)poolProperties.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<String, String> apply(String p) {
                    return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])p.split(",")).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(String s) {
                            int eqIndex = s.indexOf(61);
                            return eqIndex >= 0 ? new Tuple2((Object)s.substring(0, eqIndex).trim(), (Object)s.substring(eqIndex + 1).trim()) : new Tuple2((Object)s.trim(), (Object)"true");
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<String, Nothing$> apply() {
                    return Predef$.MODULE$.Map().empty();
                }
            });
            boolean isLoner = Utils$.MODULE$.isLoner(sc);
            Properties connProps = new Properties();
            Properties executorConnProps = new Properties();
            parameters.foreach((Function1)new Serializable(connProps, executorConnProps){
                public static final long serialVersionUID = 0L;
                private final Properties connProps$1;
                private final Properties executorConnProps$1;

                public final Object apply(Tuple2<String, String> kv) {
                    this.connProps$1.setProperty((String)kv._1(), (String)kv._2());
                    return this.executorConnProps$1.setProperty((String)kv._1(), (String)kv._2());
                }
                {
                    this.connProps$1 = connProps$1;
                    this.executorConnProps$1 = executorConnProps$1;
                }
            });
            connProps.remove("poolProperties");
            executorConnProps.remove("poolProperties");
            JdbcDialect jdbcDialect = dialect;
            GemFireXDDialect$ gemFireXDDialect$ = GemFireXDDialect$.MODULE$;
            JdbcDialect jdbcDialect2 = jdbcDialect;
            if (!(gemFireXDDialect$ != null ? !((Object)((Object)gemFireXDDialect$)).equals(jdbcDialect2) : jdbcDialect2 != null)) {
                GemFireXDDialect$.MODULE$.addExtraDriverProperties(isLoner, connProps);
                bl = true;
            } else {
                GemFireXDClientDialect$ gemFireXDClientDialect$ = GemFireXDClientDialect$.MODULE$;
                JdbcDialect jdbcDialect3 = jdbcDialect;
                if (!(gemFireXDClientDialect$ != null ? !((Object)((Object)gemFireXDClientDialect$)).equals(jdbcDialect3) : jdbcDialect3 != null)) {
                    GemFireXDClientDialect$.MODULE$.addExtraDriverProperties(isLoner, connProps);
                    connProps.setProperty("route-query", "false");
                    executorConnProps.setProperty("route-query", "false");
                    bl = false;
                } else if (jdbcDialect instanceof JdbcExtendedDialect) {
                    JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
                    jdbcExtendedDialect.addExtraDriverProperties(isLoner, connProps);
                    bl = false;
                } else {
                    bl = false;
                }
            }
            boolean isEmbedded = bl;
            scala.collection.immutable.Map<String, String> allPoolProps = this.getAllPoolProperties(url, driver, (scala.collection.immutable.Map<String, String>)poolProps, hikariCP, isEmbedded);
            return new ConnectionProperties(url, driver, dialect, allPoolProps, connProps, executorConnProps, hikariCP);
        }
        throw new MatchError((Object)option);
    }

    public Function0<Connection> getConnector(String id, ConnectionProperties connProperties, boolean forExecutor) {
        return new Serializable(id, connProperties, forExecutor){
            public static final long serialVersionUID = 0L;
            private final String id$1;
            private final ConnectionProperties connProperties$1;
            private final boolean forExecutor$1;

            public final Connection apply() {
                Utils$.MODULE$.registerDriver(this.connProperties$1.driver());
                Properties connProps = this.forExecutor$1 ? this.connProperties$1.executorConnProps() : this.connProperties$1.connProps();
                return ConnectionPool$.MODULE$.getPoolConnection(this.id$1, this.connProperties$1.dialect(), this.connProperties$1.poolProps(), connProps, this.connProperties$1.hikariCP());
            }
            {
                this.id$1 = id$1;
                this.connProperties$1 = connProperties$1;
                this.forExecutor$1 = forExecutor$1;
            }
        };
    }

    public Enumeration.Value getConnectionType(JdbcDialect dialect) {
        Enumeration.Value value;
        JdbcDialect jdbcDialect = dialect;
        GemFireXDDialect$ gemFireXDDialect$ = GemFireXDDialect$.MODULE$;
        JdbcDialect jdbcDialect2 = jdbcDialect;
        if (!(gemFireXDDialect$ != null ? !((Object)((Object)gemFireXDDialect$)).equals(jdbcDialect2) : jdbcDialect2 != null)) {
            value = ConnectionType$.MODULE$.Embedded();
        } else {
            GemFireXDClientDialect$ gemFireXDClientDialect$ = GemFireXDClientDialect$.MODULE$;
            JdbcDialect jdbcDialect3 = jdbcDialect;
            value = !(gemFireXDClientDialect$ != null ? !((Object)((Object)gemFireXDClientDialect$)).equals(jdbcDialect3) : jdbcDialect3 != null) ? ConnectionType$.MODULE$.Net() : ConnectionType$.MODULE$.Unknown();
        }
        return value;
    }

    public int getJDBCType(JdbcDialect dialect, DataType dataType) {
        return BoxesRunTime.unboxToInt((Object)dialect.getJDBCType(dataType).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(JdbcType x$1) {
                return x$1.jdbcNullType();
            }
        }).getOrElse((Function0)new Serializable(dataType){
            public static final long serialVersionUID = 0L;
            private final DataType dataType$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                block15: {
                    int n;
                    block3: {
                        DataType dataType;
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                block4: {
                                                                    block2: {
                                                                        dataType = this.dataType$1;
                                                                        IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                                        DataType dataType2 = dataType;
                                                                        if (integerType$ != null ? !integerType$.equals(dataType2) : dataType2 != null) break block2;
                                                                        n = 4;
                                                                        break block3;
                                                                    }
                                                                    LongType$ longType$ = LongType$.MODULE$;
                                                                    DataType dataType3 = dataType;
                                                                    if (longType$ != null ? !longType$.equals(dataType3) : dataType3 != null) break block4;
                                                                    n = -5;
                                                                    break block3;
                                                                }
                                                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                                                DataType dataType4 = dataType;
                                                                if (doubleType$ != null ? !doubleType$.equals(dataType4) : dataType4 != null) break block5;
                                                                n = 8;
                                                                break block3;
                                                            }
                                                            FloatType$ floatType$ = FloatType$.MODULE$;
                                                            DataType dataType5 = dataType;
                                                            if (floatType$ != null ? !floatType$.equals(dataType5) : dataType5 != null) break block6;
                                                            n = 7;
                                                            break block3;
                                                        }
                                                        ShortType$ shortType$ = ShortType$.MODULE$;
                                                        DataType dataType6 = dataType;
                                                        if (shortType$ != null ? !shortType$.equals(dataType6) : dataType6 != null) break block7;
                                                        n = 4;
                                                        break block3;
                                                    }
                                                    ByteType$ byteType$ = ByteType$.MODULE$;
                                                    DataType dataType7 = dataType;
                                                    if (byteType$ != null ? !byteType$.equals(dataType7) : dataType7 != null) break block8;
                                                    n = 4;
                                                    break block3;
                                                }
                                                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                DataType dataType8 = dataType;
                                                if (booleanType$ != null ? !booleanType$.equals(dataType8) : dataType8 != null) break block9;
                                                n = -7;
                                                break block3;
                                            }
                                            StringType$ stringType$ = StringType$.MODULE$;
                                            DataType dataType9 = dataType;
                                            if (stringType$ != null ? !stringType$.equals(dataType9) : dataType9 != null) break block10;
                                            n = 2005;
                                            break block3;
                                        }
                                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                        DataType dataType10 = dataType;
                                        if (binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null) break block11;
                                        n = 2004;
                                        break block3;
                                    }
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType11 = dataType;
                                    if (timestampType$ != null ? !timestampType$.equals(dataType11) : dataType11 != null) break block12;
                                    n = 93;
                                    break block3;
                                }
                                DateType$ dateType$ = DateType$.MODULE$;
                                DataType dataType12 = dataType;
                                if (dateType$ != null ? !dateType$.equals(dataType12) : dataType12 != null) break block13;
                                n = 91;
                                break block3;
                            }
                            if (!(dataType instanceof DecimalType)) break block14;
                            n = 3;
                            break block3;
                        }
                        NullType$ nullType$ = NullType$.MODULE$;
                        DataType dataType13 = dataType;
                        if (nullType$ != null ? !nullType$.equals(dataType13) : dataType13 != null) break block15;
                        n = 0;
                    }
                    return n;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't translate to JDBC value for type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataType$1})));
            }
            {
                this.dataType$1 = dataType$1;
            }
        }));
    }

    public StructType pruneSchema(scala.collection.immutable.Map<String, StructField> fieldMap, String[] columns2) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])columns2).map((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map fieldMap$1;

            public final StructField apply(String col) {
                return (StructField)this.fieldMap$1.getOrElse((Object)col, (Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pruneSchema.1 $outer;
                    public final String col$1;

                    public final StructField apply() {
                        return (StructField)this.$outer.fieldMap$1.getOrElse((Object)this.col$1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$pruneSchema$1$$anonfun$apply$2 $outer;

                            public final Nothing$ apply() {
                                throw new AnalysisException(new StringBuilder().append((Object)"Cannot resolve ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"column name \"", "\" among (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.col$1, this.$outer.org$apache$spark$sql$execution$columnar$ExternalStoreUtils$$anonfun$$anonfun$$$outer().fieldMap$1.keys().mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.pruneSchema.1 org$apache$spark$sql$execution$columnar$ExternalStoreUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Object>, Seq<DataType>> columnIndicesAndDataTypes(StructType requestedSchema, StructType schema) {
        Tuple2 tuple2;
        if (requestedSchema.isEmpty()) {
            Tuple2 tuple22;
            Tuple2 tuple23 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new anonfun.8(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).minBy((Function1)new anonfun.9(), (Ordering)Ordering.Int$.MODULE$);
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            int narrowestOrdinal = tuple23._1$mcI$sp();
            DataType narrowestDataType = (DataType)tuple23._2();
            Tuple2 tuple24 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)narrowestOrdinal), (Object)narrowestDataType);
            int narrowestOrdinal2 = tuple24._1$mcI$sp();
            DataType narrowestDataType2 = (DataType)tuple24._2();
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{narrowestOrdinal2}))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{narrowestDataType2})));
            return tuple2;
        } else {
            tuple2 = ((GenericTraversableTemplate)requestedSchema.map((Function1)new Serializable(schema){
                public static final long serialVersionUID = 0L;
                private final StructType schema$1;

                public final Tuple2<Object, DataType> apply(StructField a) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.schema$1.fieldIndex(Utils$.MODULE$.fieldName(a)))), (Object)a.dataType());
                }
                {
                    this.schema$1 = schema$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
        }
        return tuple2;
    }

    public String getInsertString(String table, StructType userSchema) {
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(table).append(" VALUES (");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), userSchema.length()).foreach((Function1)new Serializable(sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int x$3) {
                return this.sb$1.append("?,");
            }
            {
                this.sb$1 = sb$1;
            }
        });
        return sb.append("?)").toString();
    }

    public String getPutString(String table, StructType userSchema) {
        StringBuilder sb = new StringBuilder("PUT INTO ");
        sb.append(table).append(" VALUES (");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), userSchema.length()).foreach((Function1)new Serializable(sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$2;

            public final StringBuilder apply(int x$4) {
                return this.sb$2.append("?,");
            }
            {
                this.sb$2 = sb$2;
            }
        });
        return sb.append("?)").toString();
    }

    public String getInsertStringWithColumnName(String table, StructType rddSchema) {
        StringBuilder sb = new StringBuilder(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " ("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        StructField[] schemaFields2 = rddSchema.fields();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), schemaFields2.length - 1).foreach((Function1)new Serializable(sb, schemaFields2){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$3;
            private final StructField[] schemaFields$1;

            public final StringBuilder apply(int i) {
                return this.sb$3.append(Utils$.MODULE$.fieldName(this.schemaFields$1[i])).append(',');
            }
            {
                this.sb$3 = sb$3;
                this.schemaFields$1 = schemaFields$1;
            }
        });
        sb.append(Utils$.MODULE$.fieldName(schemaFields2[schemaFields2.length - 1]));
        sb.append(") VALUES (");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), rddSchema.length()).foreach((Function1)new Serializable(sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$3;

            public final StringBuilder apply(int x$5) {
                return this.sb$3.append("?,");
            }
            {
                this.sb$3 = sb$3;
            }
        });
        return sb.append("?)").toString();
    }

    public void setStatementParameters(PreparedStatement stmt, ArrayBuffer<Object> row) {
        int len = row.length();
        for (int col = 1; col <= len; ++col) {
            BoxedUnit boxedUnit;
            Object colVal = row.apply(col - 1);
            if (colVal == null) {
                stmt.setNull(col, 0);
                continue;
            }
            Object object = colVal;
            if (object instanceof String) {
                String string = (String)object;
                stmt.setString(col, string);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                stmt.setInt(col, n);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                stmt.setLong(col, l);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                stmt.setDouble(col, d);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                stmt.setFloat(col, f);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                stmt.setInt(col, s);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                stmt.setInt(col, by);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                stmt.setBoolean(col, bl);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                stmt.setBytes(col, byArray);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                stmt.setTimestamp(col, timestamp);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                stmt.setDate(col, date);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Time) {
                Time time = (Time)object;
                stmt.setTime(col, time);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                stmt.setBigDecimal(col, decimal.toJavaBigDecimal());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                stmt.setBigDecimal(col, bigDecimal);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            stmt.setObject(col, colVal);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final String PARTITION_BY() {
        return "PARTITION_BY";
    }

    public final String REPLICATE() {
        return "REPLICATE";
    }

    public final String BUCKETS() {
        return "BUCKETS";
    }

    public int getTotalPartitions(SparkContext sc, Map<String, String> parameters, boolean forManagedTable, boolean forColumnTable, boolean forSampleTable) {
        return new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"BUCKETS", (Function0)new Serializable(sc, parameters, forManagedTable, forColumnTable, forSampleTable){
            public static final long serialVersionUID = 0L;
            private final SparkContext sc$2;
            private final Map parameters$2;
            private final boolean forManagedTable$1;
            private final boolean forColumnTable$1;
            private final boolean forSampleTable$1;

            /*
             * WARNING - void declaration
             */
            public final String apply() {
                void var1_3;
                ClusterMode clusterMode = SnappyContext$.MODULE$.getClusterMode(this.sc$2);
                String string = clusterMode instanceof LocalMode ? (this.forSampleTable$1 ? "7" : "11") : (this.forSampleTable$1 ? "53" : "113");
                String partitions = string;
                Object object = this.forManagedTable$1 ? (this.forColumnTable$1 ? this.parameters$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"BUCKETS"), (Object)partitions)) : (this.parameters$2.contains((Object)"PARTITION_BY") && !this.parameters$2.contains((Object)"REPLICATE") ? this.parameters$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"BUCKETS"), (Object)partitions)) : BoxedUnit.UNIT)) : BoxedUnit.UNIT;
                return var1_3;
            }
            {
                this.sc$2 = sc$2;
                this.parameters$2 = parameters$2;
                this.forManagedTable$1 = forManagedTable$1;
                this.forColumnTable$1 = forColumnTable$1;
                this.forSampleTable$1 = forSampleTable$1;
            }
        }))).toInt();
    }

    public boolean getTotalPartitions$default$4() {
        return true;
    }

    public boolean getTotalPartitions$default$5() {
        return false;
    }

    public final Iterator<InternalRow> cachedBatchesToRows(Iterator<CachedBatch> cachedBatches, String[] requestedColumns, StructType schema) {
        Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])requestedColumns).map((Function1)new anonfun.10(schema), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.mutable.IndexedSeq requestedColumnIndices = (scala.collection.mutable.IndexedSeq)tuple2._1();
            scala.collection.mutable.IndexedSeq requestedColumnDataTypes = (scala.collection.mutable.IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)requestedColumnIndices, (Object)requestedColumnDataTypes);
            scala.collection.mutable.IndexedSeq requestedColumnIndices2 = (scala.collection.mutable.IndexedSeq)tuple23._1();
            scala.collection.mutable.IndexedSeq requestedColumnDataTypes2 = (scala.collection.mutable.IndexedSeq)tuple23._2();
            return this.cachedBatchesToRows(cachedBatches, (IndexedSeq<Object>)requestedColumnIndices2, (IndexedSeq<DataType>)requestedColumnDataTypes2, schema);
        }
        throw new MatchError((Object)tuple2);
    }

    public final Iterator<InternalRow> cachedBatchesToRows(Iterator<CachedBatch> cachedBatches, IndexedSeq<Object> requestedColumnIndices, IndexedSeq<DataType> requestedColumnDataTypes, StructType schema) {
        SpecificMutableRow nextRow = new SpecificMutableRow(requestedColumnDataTypes);
        Iterator rows = cachedBatches.flatMap((Function1)new Serializable(requestedColumnIndices, schema, nextRow){
            public static final long serialVersionUID = 0L;
            public final IndexedSeq requestedColumnIndices$1;
            public final StructType schema$3;
            public final SpecificMutableRow nextRow$1;

            public final Object apply(CachedBatch cachedBatch) {
                IndexedSeq columnAccessors = (IndexedSeq)((TraversableLike)this.requestedColumnIndices$1.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, cachedBatch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.11 $outer;
                    private final CachedBatch cachedBatch$1;

                    public final ColumnAccessor apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            int schemaIndex = tuple2._1$mcI$sp();
                            int bufferIndex = tuple2._2$mcI$sp();
                            ColumnAccessor columnAccessor = ColumnAccessor$.MODULE$.apply(this.$outer.schema$3.fields()[schemaIndex].dataType(), ByteBuffer.wrap(this.cachedBatch$1.buffers()[bufferIndex]));
                            return columnAccessor;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cachedBatch$1 = cachedBatch$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return new Iterator<InternalRow>(this, columnAccessors){
                    private final int rowLen;
                    private final /* synthetic */ anonfun.11 $outer;
                    private final IndexedSeq columnAccessors$1;

                    public Iterator<InternalRow> seq() {
                        return Iterator.class.seq((Iterator)this);
                    }

                    public boolean isEmpty() {
                        return Iterator.class.isEmpty((Iterator)this);
                    }

                    public boolean isTraversableAgain() {
                        return Iterator.class.isTraversableAgain((Iterator)this);
                    }

                    public boolean hasDefiniteSize() {
                        return Iterator.class.hasDefiniteSize((Iterator)this);
                    }

                    public Iterator<InternalRow> take(int n) {
                        return Iterator.class.take((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> drop(int n) {
                        return Iterator.class.drop((Iterator)this, (int)n);
                    }

                    public Iterator<InternalRow> slice(int from, int until) {
                        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                    }

                    public <B> Iterator<B> map(Function1<InternalRow, B> f) {
                        return Iterator.class.map((Iterator)this, f);
                    }

                    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                        return Iterator.class.$plus$plus((Iterator)this, that);
                    }

                    public <B> Iterator<B> flatMap(Function1<InternalRow, GenTraversableOnce<B>> f) {
                        return Iterator.class.flatMap((Iterator)this, f);
                    }

                    public Iterator<InternalRow> filter(Function1<InternalRow, Object> p) {
                        return Iterator.class.filter((Iterator)this, p);
                    }

                    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<InternalRow, B, Object> p) {
                        return Iterator.class.corresponds((Iterator)this, that, p);
                    }

                    public Iterator<InternalRow> withFilter(Function1<InternalRow, Object> p) {
                        return Iterator.class.withFilter((Iterator)this, p);
                    }

                    public Iterator<InternalRow> filterNot(Function1<InternalRow, Object> p) {
                        return Iterator.class.filterNot((Iterator)this, p);
                    }

                    public <B> Iterator<B> collect(PartialFunction<InternalRow, B> pf) {
                        return Iterator.class.collect((Iterator)this, pf);
                    }

                    public <B> Iterator<B> scanLeft(B z, Function2<B, InternalRow, B> op) {
                        return Iterator.class.scanLeft((Iterator)this, z, op);
                    }

                    public <B> Iterator<B> scanRight(B z, Function2<InternalRow, B, B> op) {
                        return Iterator.class.scanRight((Iterator)this, z, op);
                    }

                    public Iterator<InternalRow> takeWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.takeWhile((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> partition(Function1<InternalRow, Object> p) {
                        return Iterator.class.partition((Iterator)this, p);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> span(Function1<InternalRow, Object> p) {
                        return Iterator.class.span((Iterator)this, p);
                    }

                    public Iterator<InternalRow> dropWhile(Function1<InternalRow, Object> p) {
                        return Iterator.class.dropWhile((Iterator)this, p);
                    }

                    public <B> Iterator<Tuple2<InternalRow, B>> zip(Iterator<B> that) {
                        return Iterator.class.zip((Iterator)this, that);
                    }

                    public <A1> Iterator<A1> padTo(int len, A1 elem) {
                        return Iterator.class.padTo((Iterator)this, (int)len, elem);
                    }

                    public Iterator<Tuple2<InternalRow, Object>> zipWithIndex() {
                        return Iterator.class.zipWithIndex((Iterator)this);
                    }

                    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                    }

                    public <U> void foreach(Function1<InternalRow, U> f) {
                        Iterator.class.foreach((Iterator)this, f);
                    }

                    public boolean forall(Function1<InternalRow, Object> p) {
                        return Iterator.class.forall((Iterator)this, p);
                    }

                    public boolean exists(Function1<InternalRow, Object> p) {
                        return Iterator.class.exists((Iterator)this, p);
                    }

                    public boolean contains(Object elem) {
                        return Iterator.class.contains((Iterator)this, (Object)elem);
                    }

                    public Option<InternalRow> find(Function1<InternalRow, Object> p) {
                        return Iterator.class.find((Iterator)this, p);
                    }

                    public int indexWhere(Function1<InternalRow, Object> p) {
                        return Iterator.class.indexWhere((Iterator)this, p);
                    }

                    public <B> int indexOf(B elem) {
                        return Iterator.class.indexOf((Iterator)this, elem);
                    }

                    public BufferedIterator<InternalRow> buffered() {
                        return Iterator.class.buffered((Iterator)this);
                    }

                    public <B> Iterator.GroupedIterator<B> grouped(int size) {
                        return Iterator.class.grouped((Iterator)this, (int)size);
                    }

                    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                    }

                    public int length() {
                        return Iterator.class.length((Iterator)this);
                    }

                    public Tuple2<Iterator<InternalRow>, Iterator<InternalRow>> duplicate() {
                        return Iterator.class.duplicate((Iterator)this);
                    }

                    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                    }

                    public <B> void copyToArray(Object xs, int start, int len) {
                        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                    }

                    public boolean sameElements(Iterator<?> that) {
                        return Iterator.class.sameElements((Iterator)this, that);
                    }

                    public Traversable<InternalRow> toTraversable() {
                        return Iterator.class.toTraversable((Iterator)this);
                    }

                    public Iterator<InternalRow> toIterator() {
                        return Iterator.class.toIterator((Iterator)this);
                    }

                    public Stream<InternalRow> toStream() {
                        return Iterator.class.toStream((Iterator)this);
                    }

                    public String toString() {
                        return Iterator.class.toString((Iterator)this);
                    }

                    public <B> int sliding$default$2() {
                        return Iterator.class.sliding$default$2((Iterator)this);
                    }

                    public List<InternalRow> reversed() {
                        return TraversableOnce.class.reversed((TraversableOnce)this);
                    }

                    public int size() {
                        return TraversableOnce.class.size((TraversableOnce)this);
                    }

                    public boolean nonEmpty() {
                        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                    }

                    public int count(Function1<InternalRow, Object> p) {
                        return TraversableOnce.class.count((TraversableOnce)this, p);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<InternalRow, B> pf) {
                        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                    }

                    public <B> B $div$colon(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                    }

                    public <B> B $colon$bslash(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                    }

                    public <B> B foldLeft(B z, Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                    }

                    public <B> B reduceLeft(Function2<B, InternalRow, B> op) {
                        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                    }

                    public <B> B reduceRight(Function2<InternalRow, B, B> op) {
                        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, InternalRow, B> op) {
                        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<InternalRow, B, B> op) {
                        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                    }

                    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                    }

                    public <B> B aggregate(B z, Function2<B, InternalRow, B> seqop, Function2<B, B, B> combop) {
                        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                    }

                    public <B> InternalRow min(Ordering<B> cmp) {
                        return TraversableOnce.class.min((TraversableOnce)this, cmp);
                    }

                    public <B> InternalRow max(Ordering<B> cmp) {
                        return TraversableOnce.class.max((TraversableOnce)this, cmp);
                    }

                    public <B> InternalRow maxBy(Function1<InternalRow, B> f, Ordering<B> cmp) {
                        return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
                    }

                    public <B> InternalRow minBy(Function1<InternalRow, B> f, Ordering<B> cmp) {
                        return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
                    }

                    public <B> void copyToBuffer(Buffer<B> dest) {
                        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                    }

                    public <B> void copyToArray(Object xs, int start) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                    }

                    public <B> void copyToArray(Object xs) {
                        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$1) {
                        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                    }

                    public List<InternalRow> toList() {
                        return TraversableOnce.class.toList((TraversableOnce)this);
                    }

                    public Iterable<InternalRow> toIterable() {
                        return TraversableOnce.class.toIterable((TraversableOnce)this);
                    }

                    public Seq<InternalRow> toSeq() {
                        return TraversableOnce.class.toSeq((TraversableOnce)this);
                    }

                    public scala.collection.immutable.IndexedSeq<InternalRow> toIndexedSeq() {
                        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                    }

                    public <B> Buffer<B> toBuffer() {
                        return TraversableOnce.class.toBuffer((TraversableOnce)this);
                    }

                    public <B> Set<B> toSet() {
                        return TraversableOnce.class.toSet((TraversableOnce)this);
                    }

                    public Vector<InternalRow> toVector() {
                        return TraversableOnce.class.toVector((TraversableOnce)this);
                    }

                    public <Col> Col to(CanBuildFrom<Nothing$, InternalRow, Col> cbf) {
                        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                    }

                    public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<InternalRow, Tuple2<T, U>> ev) {
                        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                    }

                    public String mkString(String start, String sep, String end) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                    }

                    public String mkString(String sep) {
                        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                    }

                    public String mkString() {
                        return TraversableOnce.class.mkString((TraversableOnce)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public StringBuilder addString(StringBuilder b, String sep) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                    }

                    public StringBuilder addString(StringBuilder b) {
                        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                    }

                    public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
                    }

                    public InternalRow next() {
                        for (int i = 0; i < this.rowLen; ++i) {
                            ((ColumnAccessor)this.columnAccessors$1.apply(i)).extractTo((MutableRow)this.$outer.nextRow$1, i);
                        }
                        return this.$outer.requestedColumnIndices$1.isEmpty() ? InternalRow$.MODULE$.empty() : this.$outer.nextRow$1;
                    }

                    public boolean hasNext() {
                        return ((ColumnAccessor)this.columnAccessors$1.head()).hasNext();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.columnAccessors$1 = columnAccessors$1;
                        GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                        TraversableOnce.class.$init$((TraversableOnce)this);
                        Iterator.class.$init$((Iterator)this);
                        this.rowLen = $outer.nextRow$1.numFields();
                    }
                };
            }
            {
                this.requestedColumnIndices$1 = requestedColumnIndices$1;
                this.schema$3 = schema$3;
                this.nextRow$1 = nextRow$1;
            }
        });
        return rows;
    }

    public void removeCachedObjects(SQLContext sqlContext, String table, boolean registerDestroy) {
        Utils$.MODULE$.mapExecutors(sqlContext, this.removeCachedObjects(table), ClassTag$.MODULE$.Unit()).count();
        this.removeCachedObjects(table).apply();
        if (registerDestroy) {
            SnappyStoreHiveCatalog$.MODULE$.registerRelationDestroy();
        }
    }

    private Function0<Iterator<BoxedUnit>> removeCachedObjects(String table) {
        return new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final String table$1;

            public final Iterator<Nothing$> apply() {
                ConnectionPool$.MODULE$.removePoolReference(this.table$1);
                CodeGeneration$.MODULE$.removeCache(this.table$1);
                return scala.package$.MODULE$.Iterator().empty();
            }
            {
                this.table$1 = table$1;
            }
        };
    }

    public boolean removeCachedObjects$default$3() {
        return false;
    }

    private ExternalStoreUtils$() {
        MODULE$ = this;
    }
}

