/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.UUID;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificMutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.collection.UUIDRegionKey;
import org.apache.spark.sql.execution.columnar.CachedBatch;
import org.apache.spark.sql.execution.columnar.CachedBatchHolder;
import org.apache.spark.sql.execution.columnar.ColumnBuilder;
import org.apache.spark.sql.execution.columnar.ColumnBuilder$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnType$;
import org.apache.spark.sql.execution.columnar.ExternalStore;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001=\u0011!cQ1dQ\u0016$')\u0019;dQ\u000e\u0013X-\u0019;pe*\u00111\u0001B\u0001\tG>dW/\u001c8be*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011!9\u0002A!b\u0001\n\u0003A\u0012!\u0003;bE2,g*Y7f+\u0005I\u0002C\u0001\u000e\u001e\u001d\t\t2$\u0003\u0002\u001d%\u00051\u0001K]3eK\u001aL!AH\u0010\u0003\rM#(/\u001b8h\u0015\ta\"\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001a\u0003)!\u0018M\u00197f\u001d\u0006lW\r\t\u0005\tG\u0001\u0011)\u0019!C\u00011\u0005iQo]3s)\u0006\u0014G.\u001a(b[\u0016D\u0001\"\n\u0001\u0003\u0002\u0003\u0006I!G\u0001\u000fkN,'\u000fV1cY\u0016t\u0015-\\3!\u0011!9\u0003A!b\u0001\n\u0003A\u0013AB:dQ\u0016l\u0017-F\u0001*!\tQS&D\u0001,\u0015\tac!A\u0003usB,7/\u0003\u0002/W\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011A\u0002!\u0011!Q\u0001\n%\nqa]2iK6\f\u0007\u0005\u0003\u00053\u0001\t\u0015\r\u0011\"\u00014\u00035)\u0007\u0010^3s]\u0006d7\u000b^8sKV\tA\u0007\u0005\u00026m5\t!!\u0003\u00028\u0005\tiQ\t\u001f;fe:\fGn\u0015;pe\u0016D\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u000fKb$XM\u001d8bYN#xN]3!\u0011!Y\u0004A!b\u0001\n\u0003a\u0014aD2pYVlgNQ1uG\"\u001c\u0016N_3\u0016\u0003u\u0002\"!\u0005 \n\u0005}\u0012\"aA%oi\"A\u0011\t\u0001B\u0001B\u0003%Q(\u0001\td_2,XN\u001c\"bi\u000eD7+\u001b>fA!A1\t\u0001BC\u0002\u0013\u0005A)\u0001\bvg\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0016\u0003\u0015\u0003\"!\u0005$\n\u0005\u001d\u0013\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u000b\u0006yQo]3D_6\u0004(/Z:tS>t\u0007\u0005C\u0003L\u0001\u0011\u0005A*\u0001\u0004=S:LGO\u0010\u000b\b\u001b:{\u0005+\u0015*T!\t)\u0004\u0001C\u0003\u0018\u0015\u0002\u0007\u0011\u0004C\u0003$\u0015\u0002\u0007\u0011\u0004C\u0003(\u0015\u0002\u0007\u0011\u0006C\u00033\u0015\u0002\u0007A\u0007C\u0003<\u0015\u0002\u0007Q\bC\u0003D\u0015\u0002\u0007Q)\u0002\u0003V\u0001\u00011&A\u0004&E\u0005\u000e\u001buN\u001c<feNLwN\u001c\t\u0007#]K\u0016-\u0010:\n\u0005a\u0013\"!\u0003$v]\u000e$\u0018n\u001c84!\tQv,D\u0001\\\u0015\taV,A\u0006fqB\u0014Xm]:j_:\u001c(B\u00010\u0007\u0003!\u0019\u0017\r^1msN$\u0018B\u00011\\\u0005I\u0019\u0006/Z2jM&\u001cW*\u001e;bE2,'k\\<\u0011\u0005\t\u0004X\"A2\u000b\u0005\u0011,\u0017aB3yK\u000e,H/\u001a\u0006\u0003\u000f\u0019T!a\u001a5\u0002\t%\f\u0007/\u001b\u0006\u0003S*\f\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003W2\f\u0011bZ3nM&\u0014X\r\u001f3\u000b\u00055t\u0017a\u00029jm>$\u0018\r\u001c\u0006\u0002_\u0006\u00191m\\7\n\u0005E\u001c'aB#yK\u000e\u0014vn\u001e\t\u0003#ML!\u0001\u001e\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006m\u0002!\ta^\u0001\u0012GJ,\u0017\r^3J]R,'O\\1m%><Hc\u0001=}}B\u0011\u0011P_\u0007\u0002;&\u001110\u0018\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003~k\u0002\u0007\u0011-A\u0004fq\u0016\u001c'k\\<\t\u000b},\b\u0019A-\u0002\u00155,H/\u00192mKJ{w\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002'\r\u0014X-\u0019;f\u0003:$7\u000b^8sK\n\u000bGo\u00195\u0015\u0015\u0005\u001d\u0011QDA\u0019\u0003\u0007\n9\u0006\u0005\u0004\u0002\n\u0005M\u0011qC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u00059Q.\u001e;bE2,'bAA\t%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\b\u0011\u0006\u001c\bnU3u!\r\t\u0012\u0011D\u0005\u0004\u00037\u0011\"aA!os\"A\u0011qDA\u0001\u0001\u0004\t\t#\u0001\u0002tGB!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012AB1dG\u0016\u001c8OC\u0002\u0002,\u0019\fQa\u001d;pe\u0016LA!a\f\u0002&\tq1kY1o\u0007>tGO]8mY\u0016\u0014\b\u0002CA\u001a\u0003\u0003\u0001\r!!\u000e\u0002\u0007I|w\u000f\u0005\u0003\u00028\u0005}RBAA\u001d\u0015\u0011\tY#a\u000f\u000b\u0007\u0005u\u0002.\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003\u0003\nID\u0001\fBEN$(/Y2u\u0007>l\u0007/Y2u\u000bb,7MU8x\u0011!\t)%!\u0001A\u0002\u0005\u001d\u0013a\u00022bi\u000eD\u0017\n\u0012\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002L\t!Q+V%E\u0011\u001d\tI&!\u0001A\u0002u\n\u0001BY;dW\u0016$\u0018\n\u0012")
public class CachedBatchCreator {
    private final String tableName;
    private final String userTableName;
    private final StructType schema;
    private final ExternalStore externalStore;
    private final int columnBatchSize;
    private final boolean useCompression;

    public String tableName() {
        return this.tableName;
    }

    public String userTableName() {
        return this.userTableName;
    }

    public StructType schema() {
        return this.schema;
    }

    public ExternalStore externalStore() {
        return this.externalStore;
    }

    public int columnBatchSize() {
        return this.columnBatchSize;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public InternalRow createInternalRow(ExecRow execRow, SpecificMutableRow mutableRow) {
        for (int i = 0; i < this.schema().length(); ++i) {
            block31: {
                int pos;
                block19: {
                    BoxedUnit boxedUnit;
                    DataType dataType;
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    BoxedUnit boxedUnit2;
                                    block26: {
                                        block25: {
                                            block24: {
                                                BoxedUnit boxedUnit3;
                                                block23: {
                                                    BoxedUnit boxedUnit4;
                                                    block22: {
                                                        block21: {
                                                            BoxedUnit boxedUnit5;
                                                            block20: {
                                                                block18: {
                                                                    pos = i + 1;
                                                                    dataType = this.schema().fields()[i].dataType();
                                                                    StringType$ stringType$ = StringType$.MODULE$;
                                                                    DataType dataType2 = dataType;
                                                                    if (stringType$ != null ? !stringType$.equals(dataType2) : dataType2 != null) break block18;
                                                                    mutableRow.update(i, (Object)UTF8String.fromString((String)execRow.getColumn(pos).getString()));
                                                                    boxedUnit = BoxedUnit.UNIT;
                                                                    break block19;
                                                                }
                                                                IntegerType$ integerType$ = IntegerType$.MODULE$;
                                                                DataType dataType3 = dataType;
                                                                if (integerType$ != null ? !integerType$.equals(dataType3) : dataType3 != null) break block20;
                                                                mutableRow.setInt(i, execRow.getColumn(pos).getInt());
                                                                boxedUnit = BoxedUnit.UNIT;
                                                                break block19;
                                                            }
                                                            LongType$ longType$ = LongType$.MODULE$;
                                                            DataType dataType4 = dataType;
                                                            if (longType$ != null ? !longType$.equals(dataType4) : dataType4 != null) break block21;
                                                            if (this.schema().fields()[i].metadata().contains("binarylong")) {
                                                                byte[] bytes = execRow.getColumn(pos).getBytes();
                                                                long ans = 0L;
                                                                for (int j = 0; j < Predef$.MODULE$.byteArrayOps(bytes).size(); ++j) {
                                                                    ans = 256L * ans + (long)(0xFF & bytes[j]);
                                                                }
                                                                mutableRow.setLong(i, ans);
                                                                boxedUnit5 = BoxedUnit.UNIT;
                                                            } else {
                                                                mutableRow.setLong(i, execRow.getColumn(pos).getLong());
                                                                boxedUnit5 = BoxedUnit.UNIT;
                                                            }
                                                            boxedUnit = boxedUnit5;
                                                            break block19;
                                                        }
                                                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                                        DataType dataType5 = dataType;
                                                        if (booleanType$ != null ? !booleanType$.equals(dataType5) : dataType5 != null) break block22;
                                                        mutableRow.setBoolean(i, execRow.getColumn(pos).getBoolean());
                                                        boxedUnit = BoxedUnit.UNIT;
                                                        break block19;
                                                    }
                                                    DateType$ dateType$ = DateType$.MODULE$;
                                                    DataType dataType6 = dataType;
                                                    if (dateType$ != null ? !dateType$.equals(dataType6) : dataType6 != null) break block23;
                                                    Date dateVal = execRow.getColumn(pos).getDate(null);
                                                    if (dateVal == null) {
                                                        mutableRow.update(i, null);
                                                        boxedUnit4 = BoxedUnit.UNIT;
                                                    } else {
                                                        mutableRow.setInt(i, DateTimeUtils$.MODULE$.fromJavaDate(dateVal));
                                                        boxedUnit4 = BoxedUnit.UNIT;
                                                    }
                                                    boxedUnit = boxedUnit4;
                                                    break block19;
                                                }
                                                if (!(dataType instanceof DecimalType)) break block24;
                                                DecimalType decimalType = (DecimalType)dataType;
                                                DataValueDescriptor dvd = execRow.getColumn(pos);
                                                if (dvd == null || dvd.isNull()) {
                                                    mutableRow.update(i, null);
                                                    boxedUnit3 = BoxedUnit.UNIT;
                                                } else {
                                                    int p = decimalType.precision();
                                                    int s = decimalType.scale();
                                                    int n = dvd.typeToBigDecimal();
                                                    switch (n) {
                                                        default: {
                                                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported typeToBigDecimal result = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                                                        }
                                                        case -5: {
                                                            mutableRow.update(i, (Object)Decimal$.MODULE$.apply(dvd.getLong(), p, s));
                                                            boxedUnit3 = BoxedUnit.UNIT;
                                                            break;
                                                        }
                                                        case 1: {
                                                            mutableRow.update(i, (Object)Decimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(dvd.getString()), p, s));
                                                            boxedUnit3 = BoxedUnit.UNIT;
                                                            break;
                                                        }
                                                        case 3: {
                                                            mutableRow.update(i, (Object)Decimal$.MODULE$.apply((BigDecimal)dvd.getObject(), p, s));
                                                            boxedUnit3 = BoxedUnit.UNIT;
                                                        }
                                                    }
                                                }
                                                boxedUnit = boxedUnit3;
                                                break block19;
                                            }
                                            DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                            DataType dataType7 = dataType;
                                            if (doubleType$ != null ? !doubleType$.equals(dataType7) : dataType7 != null) break block25;
                                            mutableRow.setDouble(i, execRow.getColumn(pos).getDouble());
                                            boxedUnit = BoxedUnit.UNIT;
                                            break block19;
                                        }
                                        FloatType$ floatType$ = FloatType$.MODULE$;
                                        DataType dataType8 = dataType;
                                        if (floatType$ != null ? !floatType$.equals(dataType8) : dataType8 != null) break block26;
                                        mutableRow.setFloat(i, execRow.getColumn(pos).getFloat());
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block19;
                                    }
                                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                                    DataType dataType9 = dataType;
                                    if (timestampType$ != null ? !timestampType$.equals(dataType9) : dataType9 != null) break block27;
                                    Timestamp t = execRow.getColumn(pos).getTimestamp(null);
                                    if (t == null) {
                                        mutableRow.update(i, null);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        mutableRow.setLong(i, DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    boxedUnit = boxedUnit2;
                                    break block19;
                                }
                                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                DataType dataType10 = dataType;
                                if (binaryType$ != null ? !binaryType$.equals(dataType10) : dataType10 != null) break block28;
                                mutableRow.update(i, (Object)execRow.getColumn(pos).getBytes());
                                boxedUnit = BoxedUnit.UNIT;
                                break block19;
                            }
                            if (!(dataType instanceof ArrayType)) break block29;
                            byte[] bytes = execRow.getColumn(pos).getBytes();
                            UnsafeArrayData array = new UnsafeArrayData();
                            array.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, bytes.length);
                            mutableRow.update(i, (Object)array);
                            boxedUnit = BoxedUnit.UNIT;
                            break block19;
                        }
                        if (!(dataType instanceof MapType)) break block30;
                        byte[] bytes = execRow.getColumn(pos).getBytes();
                        UnsafeMapData map = new UnsafeMapData();
                        map.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, bytes.length);
                        mutableRow.update(i, (Object)map);
                        boxedUnit = BoxedUnit.UNIT;
                        break block19;
                    }
                    if (!(dataType instanceof StructType)) break block31;
                    StructType structType = (StructType)dataType;
                    byte[] bytes = execRow.getColumn(pos).getBytes();
                    UnsafeRow row = new UnsafeRow();
                    row.pointTo((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, structType.fields().length, bytes.length);
                    mutableRow.update(i, (Object)row);
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!execRow.getColumn(pos).isNull()) continue;
                mutableRow.setNullAt(i);
                continue;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported field ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.schema().fields()[i]})));
        }
        return mutableRow;
    }

    public HashSet<Object> createAndStoreBatch(ScanController sc, AbstractCompactExecRow row, UUID batchID, int bucketID) {
        CachedBatchHolder<ArrayBuffer> holder = new CachedBatchHolder<ArrayBuffer>((Function0<ColumnBuilder[]>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedBatchCreator $outer;

            public final ColumnBuilder[] apply() {
                return this.$outer.org$apache$spark$sql$execution$columnar$CachedBatchCreator$$columnBuilders$1();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, 0, Integer.MAX_VALUE, this.schema(), new ArrayBuffer(1), (Function2<ArrayBuffer, CachedBatch, ArrayBuffer>)new Serializable(this, batchID, bucketID){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedBatchCreator $outer;
            private final UUID batchID$1;
            private final int bucketID$1;

            public final ArrayBuffer<UUIDRegionKey> apply(ArrayBuffer<UUIDRegionKey> accumulated, CachedBatch batch) {
                return this.$outer.org$apache$spark$sql$execution$columnar$CachedBatchCreator$$uuidBatchAggregate$1(accumulated, batch, this.batchID$1, this.bucketID$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.batchID$1 = batchID$1;
                this.bucketID$1 = bucketID$1;
            }
        });
        MemHeapScanController memHeapScanController = (MemHeapScanController)sc;
        memHeapScanController.setAddRegionAndKey();
        HashSet keySet = new HashSet();
        SpecificMutableRow mutableRow = new SpecificMutableRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$1) {
                return x$1.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
        try {
            while (memHeapScanController.fetchNext((ExecRow)row)) {
                holder.appendRow(BoxedUnit.UNIT, this.createInternalRow((ExecRow)row, mutableRow));
                keySet.add(((RegionAndKey)row.getAllRegionAndKeyInfo().first()).getKey());
            }
            holder.forceEndOfBatch();
            return keySet;
        }
        finally {
            sc.close();
        }
    }

    public final ArrayBuffer org$apache$spark$sql$execution$columnar$CachedBatchCreator$$uuidBatchAggregate$1(ArrayBuffer accumulated, CachedBatch batch, UUID batchID$1, int bucketID$1) {
        UUIDRegionKey uuid = this.externalStore().storeCachedBatch(this.tableName(), batch, bucketID$1, (Option<UUID>)Option$.MODULE$.apply((Object)batchID$1));
        return accumulated.$plus$eq((Object)uuid);
    }

    public final ColumnBuilder[] org$apache$spark$sql$execution$columnar$CachedBatchCreator$$columnBuilders$1() {
        return (ColumnBuilder[])((TraversableOnce)this.schema().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedBatchCreator $outer;

            public final ColumnBuilder apply(StructField attribute) {
                ColumnType columnType = ColumnType$.MODULE$.apply(attribute.dataType());
                int initialBufferSize = columnType.defaultSize() * this.$outer.columnBatchSize();
                return ColumnBuilder$.MODULE$.apply(attribute.dataType(), initialBufferSize, attribute.name(), this.$outer.useCompression());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnBuilder.class));
    }

    public CachedBatchCreator(String tableName, String userTableName, StructType schema, ExternalStore externalStore, int columnBatchSize, boolean useCompression) {
        this.tableName = tableName;
        this.userTableName = userTableName;
        this.schema = schema;
        this.externalStore = externalStore;
        this.columnBatchSize = columnBatchSize;
        this.useCompression = useCompression;
    }
}

