/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.collection;

import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.TaskLocation$;
import org.apache.spark.scheduler.local.LocalBackend;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.collection.ExecutorLocalPartition;
import org.apache.spark.sql.collection.ExecutorLocalRDD;
import org.apache.spark.sql.collection.FixedPartitionRDD;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DDLException;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.sources.CastLongTime$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.storage.BlockManagerId;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Sorting$;
import scala.util.matching.Regex;

public final class Utils$ {
    public static final Utils$ MODULE$;
    private final String WEIGHTAGE_COLUMN_NAME;
    private final double Z95Percent;
    private final double Z95Squared;
    private final Regex timeIntervalSpec;

    static {
        new Utils$();
    }

    public final String WEIGHTAGE_COLUMN_NAME() {
        return "STRATIFIED_SAMPLER_WEIGHTAGE";
    }

    public final double Z95Percent() {
        return this.Z95Percent;
    }

    public final double Z95Squared() {
        return this.Z95Squared;
    }

    public String StringExtensions(String s) {
        return s;
    }

    public <T> void fillArray(Object a, T v, int start, int endP1) {
        for (int index = start; index < endP1; ++index) {
            ScalaRunTime$.MODULE$.array_update(a, index, v);
        }
    }

    public AnalysisException analysisException(String msg) {
        return new AnalysisException(msg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
    }

    public int columnIndex(String col, String[] cols, String module) {
        String colT = this.toUpperCase(col.trim());
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])cols).indices().collectFirst((PartialFunction)new Serializable(col, cols, colT){
            public static final long serialVersionUID = 0L;
            private final String col$1;
            private final String[] cols$1;
            private final String colT$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                switch (A1) {
                    default: 
                }
                String string = this.col$1;
                String string2 = this.cols$1[A1];
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object = BoxesRunTime.boxToInteger(A1);
                } else {
                    String string3 = this.colT$1;
                    String string4 = Utils$.MODULE$.toUpperCase(this.cols$1[A1]);
                    object = !(string3 != null ? !string3.equals(string4) : string4 != null) ? BoxesRunTime.boxToInteger(A1) : function1.apply((Object)BoxesRunTime.boxToInteger(x1));
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(int x1) {
                boolean bl;
                int n = x1;
                switch (n) {
                    default: 
                }
                String string = this.col$1;
                String string2 = this.cols$1[n];
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    bl = true;
                } else {
                    String string3 = this.colT$1;
                    String string4 = Utils$.MODULE$.toUpperCase(this.cols$1[n]);
                    bl = !(string3 != null ? !string3.equals(string4) : string4 != null);
                }
                return bl;
            }
            {
                this.col$1 = col$1;
                this.cols$1 = cols$1;
                this.colT$1 = colT$1;
            }
        }).getOrElse((Function0)new Serializable(col, cols, module){
            public static final long serialVersionUID = 0L;
            private final String col$1;
            private final String[] cols$1;
            private final String module$1;

            public final Nothing$ apply() {
                throw Utils$.MODULE$.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot resolve column name \"", "\" among\n            (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$1, this.col$1, Predef$.MODULE$.refArrayOps((Object[])this.cols$1).mkString(", ")})));
            }
            {
                this.col$1 = col$1;
                this.cols$1 = cols$1;
                this.module$1 = module$1;
            }
        }));
    }

    public StructField[] getFields(String[] cols, StructType schema, String module) {
        return (StructField[])Predef$.MODULE$.refArrayOps((Object[])cols).map((Function1)new Serializable(cols, schema, module){
            public static final long serialVersionUID = 0L;
            public final String[] cols$2;
            private final StructType schema$1;
            public final String module$2;

            public final StructField apply(String col) {
                String colT = Utils$.MODULE$.toUpperCase(col.trim());
                return (StructField)Predef$.MODULE$.refArrayOps((Object[])this.schema$1.fields()).collectFirst((PartialFunction)new Serializable(this, colT){
                    public static final long serialVersionUID = 0L;
                    private final String colT$2;

                    public final <A1 extends StructField, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        String string = this.colT$2;
                        String string2 = Utils$.MODULE$.toUpperCase(A1.name());
                        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? A1 : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(StructField x2) {
                        StructField structField = x2;
                        String string = this.colT$2;
                        String string2 = Utils$.MODULE$.toUpperCase(structField.name());
                        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                        return bl;
                    }
                    {
                        this.colT$2 = colT$2;
                    }
                }).getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getFields.1 $outer;
                    private final String col$2;

                    public final Nothing$ apply() {
                        throw Utils$.MODULE$.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot resolve column name \"", "\" among\n            (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.module$2, this.col$2, Predef$.MODULE$.refArrayOps((Object[])this.$outer.cols$2).mkString(", ")})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.col$2 = col$2;
                    }
                });
            }
            {
                this.cols$2 = cols$2;
                this.schema$1 = schema$1;
                this.module$2 = module$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public String fieldName(StructField f) {
        return f.metadata().contains("name") ? f.metadata().getString("name") : f.name();
    }

    public scala.collection.immutable.Map<BlockManagerId, Tuple2<Object, Object>> getAllExecutorsMemoryStatus(SparkContext sc) {
        scala.collection.immutable.Map memoryStatus = sc.env().blockManager().master().getMemoryStatus();
        return this.isLoner(sc) ? memoryStatus : (scala.collection.immutable.Map)memoryStatus.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x$1) {
                return !((BlockManagerId)x$1._1()).isDriver();
            }
        });
    }

    public String getHostExecutorId(BlockManagerId blockId) {
        return new StringBuilder().append((Object)TaskLocation$.MODULE$.executorLocationTag()).append((Object)blockId.host()).append((Object)BoxesRunTime.boxToCharacter((char)'_')).append((Object)blockId.executorId()).toString();
    }

    public Class<?> classForName(String className2) {
        return org.apache.spark.util.Utils$.MODULE$.classForName(className2);
    }

    public String ERROR_NO_QCS(String module) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": QCS is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module}));
    }

    public Tuple2<int[], String[]> qcsOf(String[] qa, String[] cols, String module) {
        int[] colIndexes = (int[])Predef$.MODULE$.refArrayOps((Object[])qa).map((Function1)new Serializable(cols, module){
            public static final long serialVersionUID = 0L;
            private final String[] cols$3;
            private final String module$3;

            public final int apply(String x$2) {
                return Utils$.MODULE$.columnIndex(x$2, this.cols$3, this.module$3);
            }
            {
                this.cols$3 = cols$3;
                this.module$3 = module$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Sorting$.MODULE$.quickSort(colIndexes);
        return new Tuple2((Object)colIndexes, Predef$.MODULE$.intArrayOps(colIndexes).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])cols), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
    }

    public Tuple2<int[], String[]> resolveQCS(Option<Object> qcsV, String[] fieldNames, String module) {
        return (Tuple2)qcsV.map((Function1)new Serializable(fieldNames, module){
            public static final long serialVersionUID = 0L;
            private final String[] fieldNames$1;
            private final String module$4;

            public final Tuple2<int[], String[]> apply(Object x0$1) {
                Object object;
                block7: {
                    Tuple2 tuple2;
                    block5: {
                        block6: {
                            block4: {
                                object = x0$1;
                                if (!(object instanceof int[])) break block4;
                                int[] nArray = (int[])object;
                                tuple2 = new Tuple2((Object)nArray, Predef$.MODULE$.intArrayOps(nArray).map((Function1)Predef$.MODULE$.wrapRefArray((Object[])this.fieldNames$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                                break block5;
                            }
                            if (!(object instanceof String)) break block6;
                            String string = (String)object;
                            if (string.isEmpty()) {
                                throw Utils$.MODULE$.analysisException(Utils$.MODULE$.ERROR_NO_QCS(this.module$4));
                            }
                            tuple2 = Utils$.MODULE$.qcsOf(string.split(","), this.fieldNames$1, this.module$4);
                            break block5;
                        }
                        if (!(object instanceof String[])) break block7;
                        String[] stringArray = (String[])object;
                        tuple2 = Utils$.MODULE$.qcsOf(stringArray, this.fieldNames$1, this.module$4);
                    }
                    return tuple2;
                }
                throw Utils$.MODULE$.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse 'qcs'='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$4, object})));
            }
            {
                this.fieldNames$1 = fieldNames$1;
                this.module$4 = module$4;
            }
        }).getOrElse((Function0)new Serializable(module){
            public static final long serialVersionUID = 0L;
            private final String module$4;

            public final Nothing$ apply() {
                throw Utils$.MODULE$.analysisException(Utils$.MODULE$.ERROR_NO_QCS(this.module$4));
            }
            {
                this.module$4 = module$4;
            }
        });
    }

    public Option<Tuple2<String, Object>> matchOption(String optName, Map<String, Object> options) {
        String optionName = this.toLowerCase(optName);
        return options.get((Object)optionName).map((Function1)new Serializable(optionName){
            public static final long serialVersionUID = 0L;
            private final String optionName$1;

            public final Tuple2<String, Object> apply(Object x$3) {
                return new Tuple2((Object)this.optionName$1, x$3);
            }
            {
                this.optionName$1 = optionName$1;
            }
        }).orElse((Function0)new Serializable(options, optionName){
            public static final long serialVersionUID = 0L;
            private final Map options$1;
            public final String optionName$1;

            public final Option<Tuple2<String, Object>> apply() {
                return this.options$1.collectFirst((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.matchOption.2 $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Object>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 != null) {
                            String key = (String)A1._1();
                            Object value = A1._2();
                            String string = Utils$.MODULE$.toLowerCase(key);
                            String string2 = this.$outer.optionName$1;
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                object = new Tuple2((Object)key, value);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x3);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<String, Object> x3) {
                        Tuple2<String, Object> tuple2 = x3;
                        if (tuple2 == null) return false;
                        String key = (String)tuple2._1();
                        String string = Utils$.MODULE$.toLowerCase(key);
                        String string2 = this.$outer.optionName$1;
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.options$1 = options$1;
                this.optionName$1 = optionName$1;
            }
        });
    }

    public Tuple2<int[], String[]> resolveQCS(Map<String, Object> options, String[] fieldNames, String module) {
        return this.resolveQCS((Option<Object>)this.matchOption("qcs", options).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<String, Object> x$4) {
                return x$4._2();
            }
        }), fieldNames, module);
    }

    public GenericRow projectColumns(Row row, int[] columnIndices, StructType schema, boolean convertToScalaRow) {
        int index;
        int ncols = columnIndices.length;
        Object[] newRow = new Object[ncols];
        if (convertToScalaRow) {
            for (index = 0; index < ncols; ++index) {
                int colIndex = columnIndices[index];
                newRow[index] = CatalystTypeConverters$.MODULE$.convertToScala(row.apply(colIndex), schema.apply(colIndex).dataType());
            }
        } else {
            while (index < ncols) {
                newRow[index] = row.apply(columnIndices[index]);
                ++index;
            }
        }
        return new GenericRow(newRow);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parseInteger(Object v, String module, String option, int min, int max) {
        long l;
        Object object = v;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            l = n;
        } else if (object instanceof String) {
            String string = (String)object;
            try {
                l = new StringOps(Predef$.MODULE$.augmentString(string)).toLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse int '", "' from string '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, option, string})));
            }
        } else if (object instanceof Long) {
            long l2;
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            l = s;
        } else {
            if (!(object instanceof Byte)) {
                throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse int '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, option, v})));
            }
            byte by = BoxesRunTime.unboxToByte((Object)object);
            l = by;
        }
        long vl = l;
        if (vl >= (long)min && vl <= (long)max) {
            return (int)vl;
        }
        throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Integer value outside of bounds [", "-", "] '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, BoxesRunTime.boxToInteger((int)min), BoxesRunTime.boxToInteger((int)max), option, BoxesRunTime.boxToLong((long)vl)})));
    }

    public int parseInteger$default$4() {
        return 1;
    }

    public int parseInteger$default$5() {
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double parseDouble(Object v, String module, String option, double min, double max, boolean exclusive) {
        double d;
        double d2;
        Object object = v;
        if (object instanceof Double) {
            double d3;
            d2 = d3 = BoxesRunTime.unboxToDouble((Object)object);
        } else if (object instanceof String) {
            String string = (String)object;
            try {
                d2 = new StringOps(Predef$.MODULE$.augmentString(string)).toDouble();
            }
            catch (NumberFormatException numberFormatException) {
                throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse double '", "' from string '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, option, string})));
            }
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            d2 = f;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            d2 = n;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            d2 = l;
        } else {
            if (!(object instanceof Number)) {
                throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse double '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, option, v})));
            }
            Number number = (Number)object;
            d2 = number.doubleValue();
        }
        double vd = d2;
        if (exclusive) {
            if (vd > min && vd < max) {
                d = vd;
                return d;
            }
            throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Double value outside of bounds (", "-", ") '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, BoxesRunTime.boxToDouble((double)min), BoxesRunTime.boxToDouble((double)max), option, BoxesRunTime.boxToDouble((double)vd)})));
        }
        if (vd >= min && vd <= max) {
            d = vd;
            return d;
        }
        throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Double value outside of bounds [", "-", "] '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, BoxesRunTime.boxToDouble((double)min), BoxesRunTime.boxToDouble((double)max), option, BoxesRunTime.boxToDouble((double)vd)})));
    }

    public boolean parseDouble$default$6() {
        return true;
    }

    public int parseColumn(Object cv, String[] cols, String module, String option) {
        block9: {
            long l;
            block5: {
                Object object;
                block8: {
                    block7: {
                        long l2;
                        block6: {
                            block4: {
                                object = cv;
                                if (!(object instanceof String)) break block4;
                                String string = (String)object;
                                l = this.columnIndex(string, cols, module);
                                break block5;
                            }
                            if (!(object instanceof Integer)) break block6;
                            int n = BoxesRunTime.unboxToInt((Object)object);
                            l = n;
                            break block5;
                        }
                        if (!(object instanceof Long)) break block7;
                        l = l2 = BoxesRunTime.unboxToLong((Object)object);
                        break block5;
                    }
                    if (!(object instanceof Short)) break block8;
                    short s = BoxesRunTime.unboxToShort((Object)object);
                    l = s;
                    break block5;
                }
                if (!(object instanceof Byte)) break block9;
                byte by = BoxesRunTime.unboxToByte((Object)object);
                l = by;
            }
            long cl = l;
            if (cl >= 0L && cl < (long)cols.length) {
                return (int)cl;
            }
            throw this.analysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Column index out of bounds "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for '", "'=", " among ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{option, BoxesRunTime.boxToLong((long)cl), Predef$.MODULE$.refArrayOps((Object[])cols).mkString(", ")}))).toString());
        }
        throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, option, cv})));
    }

    public final Regex timeIntervalSpec() {
        return this.timeIntervalSpec;
    }

    public long parseTimeInterval(Object optV, String module) {
        block5: {
            String string;
            block6: {
                String unit;
                block11: {
                    long l;
                    block3: {
                        long l2;
                        long l3;
                        block8: {
                            String string2;
                            String interval;
                            block10: {
                                block9: {
                                    block7: {
                                        Object object;
                                        block4: {
                                            long l4;
                                            block2: {
                                                object = optV;
                                                if (!(object instanceof Integer)) break block2;
                                                int n = BoxesRunTime.unboxToInt((Object)object);
                                                l = n;
                                                break block3;
                                            }
                                            if (!(object instanceof Long)) break block4;
                                            l = l4 = BoxesRunTime.unboxToLong((Object)object);
                                            break block3;
                                        }
                                        if (!(object instanceof String)) break block5;
                                        String string3 = string = (String)object;
                                        Option option = this.timeIntervalSpec().unapplySeq((Object)string3);
                                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block6;
                                        interval = (String)((LinearSeqOptimized)option.get()).apply(0);
                                        String string4 = string2 = (unit = (String)((LinearSeqOptimized)option.get()).apply(1));
                                        if ("ms" != null ? !"ms".equals(string4) : string4 != null) break block7;
                                        l3 = new StringOps(Predef$.MODULE$.augmentString(interval)).toLong();
                                        break block8;
                                    }
                                    String string5 = string2;
                                    if ("s" != null ? !"s".equals(string5) : string5 != null) break block9;
                                    l3 = new StringOps(Predef$.MODULE$.augmentString(interval)).toLong() * 1000L;
                                    break block8;
                                }
                                String string6 = string2;
                                if ("m" != null ? !"m".equals(string6) : string6 != null) break block10;
                                l3 = new StringOps(Predef$.MODULE$.augmentString(interval)).toLong() * 60000L;
                                break block8;
                            }
                            String string7 = string2;
                            if ("h" != null ? !"h".equals(string7) : string7 != null) break block11;
                            l3 = new StringOps(Predef$.MODULE$.augmentString(interval)).toLong() * 3600000L;
                        }
                        l = l2 = l3;
                    }
                    return l;
                }
                throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected regex match 'unit'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unit})));
            }
            throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse 'timeInterval': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, string})));
        }
        throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse 'timeInterval': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, optV})));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long parseTimestamp(String ts, String module, String col) {
        long l;
        try {
            l = new StringOps(Predef$.MODULE$.augmentString(ts)).toLong();
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                l = CastLongTime$.MODULE$.getMillis(Timestamp.valueOf(ts));
                return l;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.analysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Cannot parse timestamp '", "'=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{module, col, ts})));
            }
        }
    }

    public <T> RDD<T> mapExecutors(SQLContext sqlContext, Function0<Iterator<T>> f, ClassTag<T> evidence$1) {
        SparkContext sc = sqlContext.sparkContext();
        Function0 cleanedF = (Function0)sc.clean(f, sc.clean$default$2());
        return new ExecutorLocalRDD<T>(sc, new Serializable(cleanedF){
            public static final long serialVersionUID = 0L;
            private final Function0 cleanedF$1;

            public final Iterator<T> apply(TaskContext context2, ExecutorLocalPartition part) {
                return (Iterator)this.cleanedF$1.apply();
            }
            {
                this.cleanedF$1 = cleanedF$1;
            }
        }, evidence$1);
    }

    public <T> RDD<T> mapExecutors(SparkContext sc, Function2<TaskContext, ExecutorLocalPartition, Iterator<T>> f, ClassTag<T> evidence$2) {
        Function2 cleanedF = (Function2)sc.clean(f, sc.clean$default$2());
        return new ExecutorLocalRDD<T>(sc, cleanedF, evidence$2);
    }

    public <T> RDD<T> getFixedPartitionRDD(SparkContext sc, Function2<TaskContext, Partition, Iterator<T>> f, Partitioner partitioner, int numPartitions, ClassTag<T> evidence$3) {
        Function2 cleanedF = (Function2)sc.clean(f, sc.clean$default$2());
        return new FixedPartitionRDD<T>(sc, cleanedF, numPartitions, (Option<Partitioner>)new Some((Object)partitioner), evidence$3);
    }

    public Class<?> getInternalType(DataType dataType) {
        block11: {
            Class<Object> clazz;
            block3: {
                DataType dataType2;
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block4: {
                                            block2: {
                                                dataType2 = dataType;
                                                ByteType$ byteType$ = ByteType$.MODULE$;
                                                DataType dataType3 = dataType2;
                                                if (byteType$ != null ? !byteType$.equals(dataType3) : dataType3 != null) break block2;
                                                clazz = Byte.TYPE;
                                                break block3;
                                            }
                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                            DataType dataType4 = dataType2;
                                            if (integerType$ != null ? !integerType$.equals(dataType4) : dataType4 != null) break block4;
                                            clazz = Integer.TYPE;
                                            break block3;
                                        }
                                        LongType$ longType$ = LongType$.MODULE$;
                                        DataType dataType5 = dataType2;
                                        if (longType$ != null ? !longType$.equals(dataType5) : dataType5 != null) break block5;
                                        clazz = Long.TYPE;
                                        break block3;
                                    }
                                    FloatType$ floatType$ = FloatType$.MODULE$;
                                    DataType dataType6 = dataType2;
                                    if (floatType$ != null ? !floatType$.equals(dataType6) : dataType6 != null) break block6;
                                    clazz = Float.TYPE;
                                    break block3;
                                }
                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                DataType dataType7 = dataType2;
                                if (doubleType$ != null ? !doubleType$.equals(dataType7) : dataType7 != null) break block7;
                                clazz = Double.TYPE;
                                break block3;
                            }
                            StringType$ stringType$ = StringType$.MODULE$;
                            DataType dataType8 = dataType2;
                            if (stringType$ != null ? !stringType$.equals(dataType8) : dataType8 != null) break block8;
                            clazz = String.class;
                            break block3;
                        }
                        DateType$ dateType$ = DateType$.MODULE$;
                        DataType dataType9 = dataType2;
                        if (dateType$ != null ? !dateType$.equals(dataType9) : dataType9 != null) break block9;
                        clazz = Integer.TYPE;
                        break block3;
                    }
                    TimestampType$ timestampType$ = TimestampType$.MODULE$;
                    DataType dataType10 = dataType2;
                    if (timestampType$ != null ? !timestampType$.equals(dataType10) : dataType10 != null) break block10;
                    clazz = Long.TYPE;
                    break block3;
                }
                if (!(dataType2 instanceof DecimalType)) break block11;
                clazz = Decimal.class;
            }
            return clazz;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public String getClientHostPort(String netServer) {
        String string;
        int addrIdx = netServer.indexOf(47);
        int portEndIndex = netServer.indexOf(93);
        if (addrIdx > 0) {
            int portIndex = netServer.indexOf(91);
            string = new StringBuilder().append((Object)netServer.substring(0, addrIdx)).append((Object)netServer.substring(portIndex, portEndIndex + 1)).toString();
        } else {
            string = netServer.substring(addrIdx + 1, portEndIndex + 1);
        }
        return string;
    }

    public final boolean isLoner(SparkContext sc) {
        return sc.schedulerBackend() instanceof LocalBackend;
    }

    public String toLowerCase(String k) {
        int len = k.length();
        for (int index = 0; index < len; ++index) {
            if (!Character.isUpperCase(k.charAt(index))) continue;
            return k.toLowerCase(Locale.ENGLISH);
        }
        return k;
    }

    public boolean hasLowerCase(String k) {
        int len = k.length();
        for (int index = 0; index < len; ++index) {
            if (!Character.isLowerCase(k.charAt(index))) continue;
            return true;
        }
        return false;
    }

    public String toUpperCase(String k) {
        int len = k.length();
        for (int index = 0; index < len; ++index) {
            if (!Character.isLowerCase(k.charAt(index))) continue;
            return k.toUpperCase(Locale.ENGLISH);
        }
        return k;
    }

    public scala.collection.immutable.Map<String, StructField> schemaFields(StructType schema) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<String, StructField>> apply(StructField f) {
                String name = f.metadata().contains("name") ? f.metadata().getString("name") : f.name();
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)name, (Object)f)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
    }

    public scala.collection.immutable.Map<String, Object> getFields(Object o) {
        Tuple2[] fieldsAsPairs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])o.getClass().getDeclaredFields()).map((Function1)new Serializable(o){
            public static final long serialVersionUID = 0L;
            private final Object o$1;

            public final Tuple2<String, Object> apply(Field field) {
                field.setAccessible(true);
                return new Tuple2((Object)field.getName(), field.get(this.o$1));
            }
            {
                this.o$1 = o$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldsAsPairs));
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<StructType, Option<LogicalPlan>> getSchemaAndPlanFromBase(Option<StructType> schemaOpt, Option<String> baseTableOpt, SnappyStoreHiveCatalog catalog, boolean asSelect, String table, String tableType) {
        String baseTable;
        Tuple2 tuple2;
        Tuple2 tuple22;
        block16: {
            Option<String> option;
            StructType s;
            Option<StructType> option2 = schemaOpt;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                s = (StructType)some.x();
                Option<String> option3 = baseTableOpt;
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    String baseTableName = (String)some2.x();
                    LogicalPlan tablePlan = catalog.lookupRelation(catalog.newQualifiedTableName(baseTableName));
                    StructType tableSchema = tablePlan.schema();
                    if (catalog.compatibleSchema(tableSchema, s)) {
                        tuple22 = new Tuple2((Object)s, (Object)new Some((Object)tablePlan));
                        break block16;
                    }
                    if (!asSelect) throw new DDLException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE ", " TABLE:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)" mismatch of specified schema with that of base table.").append((Object)"\n  Base table schema: ").append((Object)tableSchema).append((Object)"\n  Specified schema: ").append((Object)s).toString());
                    throw new DDLException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE ", " TABLE AS SELECT:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)" mismatch of schema with that of base table.").append((Object)"\n  Base table schema: ").append((Object)tableSchema).append((Object)"\n  AS SELECT schema: ").append((Object)s).toString());
                }
                None$ none$ = None$.MODULE$;
                Option<String> option4 = option3;
                if (none$ == null) {
                    if (option4 != null) {
                        throw new MatchError(option3);
                    }
                } else if (!none$.equals(option4)) throw new MatchError(option3);
                tuple2 = new Tuple2((Object)s, (Object)None$.MODULE$);
                return tuple2;
            }
            None$ none$ = None$.MODULE$;
            Option<StructType> option5 = option2;
            if (none$ == null) {
                if (option5 != null) {
                    throw new MatchError(option2);
                }
            } else if (!none$.equals(option5)) throw new MatchError(option2);
            if ((option = baseTableOpt) instanceof Some) {
                Some some = (Some)option;
                baseTable = (String)some.x();
                LogicalPlan tablePlan = catalog.lookupRelation(catalog.newQualifiedTableName(baseTable));
                Tuple2 tuple23 = new Tuple2((Object)catalog.normalizeSchema(tablePlan.schema()), (Object)new Some((Object)tablePlan));
                return tuple23;
            }
            None$ none$2 = None$.MODULE$;
            Option<String> option6 = option;
            if (none$2 == null) {
                if (option6 == null) throw new DDLException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE ", " TABLE must provide "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)"either column definition or baseTable option.").toString());
                throw new MatchError(option);
            } else {
                if (!none$2.equals(option6)) throw new MatchError(option);
                throw new DDLException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE ", " TABLE must provide "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType}))).append((Object)"either column definition or baseTable option.").toString());
            }
            catch (Throwable throwable) {
                Tuple2 tuple24;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof AnalysisException ? true : throwable2 instanceof DDLException;
                if (!bl) throw throwable;
                tuple22 = tuple24 = new Tuple2((Object)s, (Object)None$.MODULE$);
            }
        }
        tuple2 = tuple22;
        return tuple2;
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            boolean bl = throwable3 instanceof AnalysisException ? true : throwable3 instanceof DDLException;
            if (!bl) throw throwable;
            AnalysisException ae = this.analysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Base table ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseTable}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not found for ", " TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType, table}))).toString());
            ae.initCause(throwable3);
            throw ae;
        }
    }

    public Function1<Object, BoxedUnit> dataTypeStringBuilder(DataType dataType, StringBuilder result) {
        return new Serializable(dataType, result){
            public static final long serialVersionUID = 0L;
            private final DataType dataType$1;
            private final StringBuilder result$1;

            public final void apply(Object value) {
                DataType dataType = this.dataType$1;
                if (dataType instanceof UserDefinedType) {
                    BoxedUnit boxedUnit;
                    UserDefinedType userDefinedType = (UserDefinedType)dataType;
                    if (value == null || userDefinedType.userClass().isInstance(value)) {
                        this.result$1.append(value);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.result$1.append(userDefinedType.deserialize(value));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    Object object = value;
                    if (object instanceof ArrayData) {
                        ArrayData arrayData = (ArrayData)object;
                        this.result$1.append('[');
                        DataType etype = arrayType.elementType();
                        int len = arrayData.numElements();
                        if (len > 0) {
                            Function1<Object, BoxedUnit> ebuilder = Utils$.MODULE$.dataTypeStringBuilder(etype, this.result$1);
                            ebuilder.apply(arrayData.get(0, etype));
                            for (int index = 1; index < len; ++index) {
                                this.result$1.append(',');
                                ebuilder.apply(arrayData.get(index, etype));
                            }
                        }
                        this.result$1.append(']');
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.result$1.append(value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    Object object = value;
                    if (object instanceof MapData) {
                        MapData mapData = (MapData)object;
                        this.result$1.append('[');
                        DataType ktype = mapType.keyType();
                        DataType vtype = mapType.valueType();
                        int len = mapData.numElements();
                        if (len > 0) {
                            Function1<Object, BoxedUnit> kbuilder = Utils$.MODULE$.dataTypeStringBuilder(ktype, this.result$1);
                            Function1<Object, BoxedUnit> vbuilder = Utils$.MODULE$.dataTypeStringBuilder(vtype, this.result$1);
                            ArrayData keys = mapData.keyArray();
                            ArrayData values = mapData.valueArray();
                            kbuilder.apply(keys.get(0, ktype));
                            this.result$1.append('=');
                            vbuilder.apply(values.get(0, ktype));
                            for (int index = 1; index < len; ++index) {
                                this.result$1.append(',');
                                kbuilder.apply(keys.get(index, ktype));
                                this.result$1.append('=');
                                vbuilder.apply(values.get(index, ktype));
                            }
                        }
                        this.result$1.append(']');
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.result$1.append(value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    Object object = value;
                    if (object instanceof InternalRow) {
                        InternalRow internalRow = (InternalRow)object;
                        this.result$1.append('[');
                        int len = internalRow.numFields();
                        if (len > 0) {
                            DataType etype = structType.fields()[0].dataType();
                            Utils$.MODULE$.dataTypeStringBuilder(etype, this.result$1).apply(internalRow.get(0, etype));
                            for (int index = 1; index < len; ++index) {
                                this.result$1.append(',');
                                DataType etype2 = structType.fields()[index].dataType();
                                Utils$.MODULE$.dataTypeStringBuilder(etype2, this.result$1).apply(internalRow.get(index, etype2));
                            }
                        }
                        this.result$1.append(']');
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.result$1.append(value);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.result$1.append(value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.dataType$1 = dataType$1;
                this.result$1 = result$1;
            }
        };
    }

    public String getDriverClassName(String url) {
        String string;
        Driver driver = DriverManager.getDriver(url);
        if (driver instanceof DriverWrapper) {
            DriverWrapper driverWrapper = (DriverWrapper)driver;
            string = driverWrapper.wrapped().getClass().getCanonicalName();
        } else {
            string = driver.getClass().getCanonicalName();
        }
        return string;
    }

    public void registerDriver(String driver) {
        try {
            DriverRegistry$.MODULE$.register(driver);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find driver class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{driver})), classNotFoundException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String registerDriverUrl(String url) {
        void var2_2;
        String driver = this.getDriverClassName(url);
        this.registerDriver(driver);
        return var2_2;
    }

    public <T> T withNewExecutionId(SQLContext ctx, QueryExecution queryExecution, Function0<T> body) {
        return (T)SQLExecution$.MODULE$.withNewExecutionId(ctx, queryExecution, body);
    }

    private Utils$() {
        MODULE$ = this;
        this.Z95Percent = new NormalDistribution().inverseCumulativeProbability(0.975);
        this.Z95Squared = this.Z95Percent() * this.Z95Percent();
        this.timeIntervalSpec = new StringOps(Predef$.MODULE$.augmentString("([0-9]+)(ms|s|m|h)")).r();
    }
}

