/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.collection;

import java.io.Serializable;
import java.util.UUID;

public final class UUIDRegionKey
implements Serializable,
Comparable<UUIDRegionKey> {
    private final UUID uuid;
    private final int bucketId;

    public UUIDRegionKey(int bucketId) {
        this.uuid = UUID.randomUUID();
        this.bucketId = bucketId;
    }

    public UUIDRegionKey(int bucketId, UUID batchID) {
        this.uuid = batchID;
        this.bucketId = bucketId;
    }

    public static Object parseAndGetBucketId(String uuidStr) {
        int colonIdx = uuidStr.lastIndexOf(":");
        if (colonIdx < 0 || uuidStr.split("-").length != 5) {
            return uuidStr;
        }
        return Integer.parseInt(uuidStr.substring(colonIdx + 1));
    }

    @Override
    public int compareTo(UUIDRegionKey other) {
        int uuidCompare = this.uuid.compareTo(other.uuid);
        return uuidCompare != 0 ? uuidCompare : (this.bucketId < other.bucketId ? -1 : (this.bucketId > other.bucketId ? 1 : 0));
    }

    public String toString() {
        return this.uuid.toString() + ":" + this.bucketId;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getBucketId() {
        return this.bucketId;
    }
}

