/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\t!2)\u0019;bYf\u001cH\u000fS1tQ\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0007M\fHN\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$A\u0006d_6\u0004X\u000f^3ICNDGC\u0001\u000e\u001e!\ti1$\u0003\u0002\u001d\u001d\t\u0019\u0011J\u001c;\t\u000by9\u0002\u0019A\u0010\u0002\u0007-,\u0017\u0010\u0005\u0002\u000eA%\u0011\u0011E\u0004\u0002\u0004\u0003:L\b\"B\u0012\u0001\t\u0003!\u0013aD2p[B,H/\u001a%bg\"\u001cu\u000eZ3\u0015\u0005i)\u0003\"\u0002\u0014#\u0001\u00049\u0013AA:e!\tAS&D\u0001*\u0015\tQ3&\u0001\u0003vi&d'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]%\u0012A\u0001R1uK\")1\u0005\u0001C\u0001aQ\u0011!$\r\u0005\u0006e=\u0002\raM\u0001\u0005i&lW\r\u0005\u00025m5\tQG\u0003\u0002\u0004W%\u0011q'\u000e\u0002\n)&lWm\u001d;b[BDQa\t\u0001\u0005\u0002e\"\"A\u0007\u001e\t\u000bmB\u0004\u0019\u0001\u001f\u0002\u0007M$(\u000f\u0005\u0002>\u0001:\u0011QBP\u0005\u0003\u007f9\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qH\u0004\u0005\u0006\t\u0002!\t!R\u0001\nQ\u0006\u001c\bNV1mk\u0016$\"A\u0007$\t\u000by\u0019\u0005\u0019A\u0010\t\u000b\u0011\u0003A\u0011\u0001%\u0015\u0005iI\u0005\"\u0002&H\u0001\u0004Y\u0015\u0001B8cUN\u00042!\u0004'O\u0013\tieBA\u0003BeJ\f\u0017\u0010\u0005\u0002P%6\t\u0001K\u0003\u0002RW\u0005!A.\u00198h\u0013\t\u0019\u0006K\u0001\u0004PE*,7\r\u001e")
public class CatalystHashFunction {
    /*
     * WARNING - void declaration
     */
    public int computeHash(Object key) {
        void var2_16;
        int n;
        if (key == null) {
            n = 0;
        } else {
            int n2;
            Object object = key;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                n2 = bl ? 0 : 1;
            } else if (object instanceof Byte) {
                int n3;
                n2 = n3 = BoxesRunTime.unboxToByte((Object)object);
            } else if (object instanceof Short) {
                int n4;
                n2 = n4 = BoxesRunTime.unboxToShort((Object)object);
            } else if (object instanceof Integer) {
                int n5;
                n2 = n5 = BoxesRunTime.unboxToInt((Object)object);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                n2 = (int)(l ^ l >>> 32);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                n2 = Float.floatToIntBits(f);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                long b = Double.doubleToLongBits(d);
                n2 = (int)(b ^ b >>> 32);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                n2 = Arrays.hashCode(byArray);
            } else if (object instanceof String) {
                String string = (String)object;
                n2 = this.computeHashCode(string);
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                n2 = this.computeHashCode(timestamp);
            } else if (object instanceof Date) {
                Date date = (Date)object;
                n2 = this.computeHashCode(date);
            } else {
                n2 = object.hashCode();
            }
            n = n2;
        }
        int update2 = n;
        return (int)var2_16;
    }

    public int computeHashCode(Date sd) {
        return this.computeHash(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(sd.getTime())));
    }

    public int computeHashCode(Timestamp time) {
        long ht = DateTimeUtils$.MODULE$.fromJavaTimestamp(time);
        return this.computeHash(BoxesRunTime.boxToLong((long)ht));
    }

    public int computeHashCode(String str) {
        IntRef result = new IntRef(1);
        int end = str.length();
        for (int index = 0; index <= end - 1; ++index) {
            char c = str.charAt(index);
            if (c < '\u0080') {
                this.addToHash$1(c, result);
                continue;
            }
            if (c < '\u0800') {
                this.addToHash$1(c >> 6 | 0xC0, result);
                this.addToHash$1(c & 0x3F | 0x80, result);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char low;
                char high = c;
                char c2 = low = index + 1 != end ? str.charAt(index + 1) : (char)'\u0000';
                if (Character.isSurrogatePair(high, low)) {
                    ++index;
                    int sch = Character.toCodePoint(high, low);
                    this.addToHash$1(sch >> 18 | 0xF0, result);
                    this.addToHash$1(sch >> 12 & 0x3F | 0x80, result);
                    this.addToHash$1(sch >> 6 & 0x3F | 0x80, result);
                    this.addToHash$1(sch & 0x3F | 0x80, result);
                    continue;
                }
                throw new RuntimeException("The supplementary unicode is not in proper format");
            }
            this.addToHash$1(c >> 12 | 0xE0, result);
            this.addToHash$1(c >> 6 & 0x3F | 0x80, result);
            this.addToHash$1(c & 0x3F | 0x80, result);
        }
        return result.elem;
    }

    /*
     * WARNING - void declaration
     */
    public int hashValue(Object key) {
        void var2_2;
        int result = 37;
        int update2 = this.computeHash(key);
        result = 37 * result + update2;
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int hashValue(Object[] objs) {
        void var2_2;
        int result = 37;
        int len = objs.length;
        for (int i = 0; i < len; ++i) {
            int update2 = this.computeHash(objs[i]);
            result = 37 * result + update2;
        }
        return (int)var2_2;
    }

    private final void addToHash$1(int value, IntRef result$1) {
        result$1.elem = 31 * result$1.elem + (byte)value;
    }
}

