/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.util.com.clearspring.analytics.stream.membership;

import io.snappydata.util.StringUtils;
import io.snappydata.util.com.clearspring.analytics.hash.MurmurHash;
import io.snappydata.util.com.clearspring.analytics.stream.membership.ICompactSerializer;
import java.lang.reflect.Method;

public abstract class Filter {
    int hashCount;
    static final int seed1 = 1007110753;
    static final int seed2 = -137723950;

    public int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(String key, boolean applyWidth) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets(), applyWidth);
    }

    public int[] getHashBuckets(byte[] key, boolean applyWidth) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets(), applyWidth);
    }

    abstract int buckets();

    public abstract void add(String var1);

    public abstract boolean isPresent(String var1);

    abstract int emptyBuckets();

    ICompactSerializer<Filter> getSerializer() {
        Method method = null;
        try {
            method = this.getClass().getMethod("serializer", new Class[0]);
            return (ICompactSerializer)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] getHashBuckets(String key, int hashCount, int max, boolean applyWidth) {
        byte[] b = key.getBytes(StringUtils.UTF8());
        return Filter.getHashBuckets(b, hashCount, max, applyWidth);
    }

    static int[] getHashBuckets(byte[] b, int hashCount, int max, boolean applyWidth) {
        int[] result = new int[hashCount];
        int hash1 = MurmurHash.hash(b, b.length, 1007110753);
        int hash2 = MurmurHash.hash(b, b.length, hash1 * -137723950);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = applyWidth ? Math.abs((hash1 + i * hash2) % max) : Math.abs(hash1 + i * hash2);
        }
        return result;
    }
}

