/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.impl;

import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.spark.sql.hive.ExternalTableType;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.thrift.TException;

public class SnappyHiveCatalog
implements ExternalCatalog {
    private static final String THREAD_GROUP_NAME = "HiveMetaStore Client Group";
    private ThreadLocal<HiveMetaStoreClient> hmClients = new ThreadLocal();
    private final ThreadLocal<HMSQuery> queries = new ThreadLocal();
    private final ExecutorService hmsQueriesExecutorService;
    private static final String DEFAULT_DB_NAME = "default";
    private final ArrayList<HiveMetaStoreClient> allHMclients = new ArrayList();

    public SnappyHiveCatalog() {
        LogWriterImpl.LoggingThreadGroup hmsThreadGroup = LogWriterImpl.createThreadGroup((String)THREAD_GROUP_NAME, (LogWriterI18n)Misc.getI18NLogWriter());
        ThreadFactory hmsClientThreadFactory = new ThreadFactory((ThreadGroup)hmsThreadGroup){
            private int next = 0;
            final /* synthetic */ ThreadGroup val$hmsThreadGroup;
            {
                this.val$hmsThreadGroup = threadGroup;
            }

            @Override
            public Thread newThread(Runnable command) {
                Thread t = new Thread(this.val$hmsThreadGroup, command, "HiveMetaStore Client-" + this.next++);
                t.setDaemon(true);
                return t;
            }
        };
        this.hmsQueriesExecutorService = Executors.newFixedThreadPool(1, hmsClientThreadFactory);
        HMSQuery q = this.getHMSQuery();
        q.resetValues(0, null, null, true);
        Future<Boolean> ret = this.hmsQueriesExecutorService.submit(q);
        try {
            ret.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isColumnTable(String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(2, tableName, DEFAULT_DB_NAME, skipLocks);
        Future<Boolean> f = this.hmsQueriesExecutorService.submit(q);
        return this.handleFutureResult(f);
    }

    public boolean isRowTable(String tableName, boolean skipLocks) {
        HMSQuery q = this.getHMSQuery();
        q.resetValues(1, tableName, DEFAULT_DB_NAME, skipLocks);
        Future<Boolean> f = this.hmsQueriesExecutorService.submit(q);
        return this.handleFutureResult(f);
    }

    public void stop() {
        for (HiveMetaStoreClient cl : this.allHMclients) {
            cl.close();
        }
        this.hmClients = null;
        this.allHMclients.clear();
        this.hmsQueriesExecutorService.shutdown();
    }

    private HMSQuery getHMSQuery() {
        HMSQuery q = this.queries.get();
        if (q == null) {
            q = new HMSQuery();
            this.queries.set(q);
        }
        return q;
    }

    private boolean handleFutureResult(Future<Boolean> f) {
        try {
            return f.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class HMSQuery
    implements Callable<Boolean> {
        private int qType;
        private String tableName;
        private String dbName;
        private boolean skipLock;
        private static final int INIT = 0;
        private static final int ISROWTABLE_QUERY = 1;
        private static final int ISCOLUMNTABLE_QUERY = 2;

        HMSQuery() {
        }

        public void resetValues(int queryType, String tableName, String dbName, boolean skipLocks) {
            this.qType = queryType;
            this.tableName = tableName;
            this.dbName = dbName;
            this.skipLock = skipLocks;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                if (this.skipLock) {
                    GfxdDataDictionary.SKIP_LOCKS.set(true);
                }
                switch (this.qType) {
                    case 0: {
                        this.initHMC();
                        Boolean bl = true;
                        return bl;
                    }
                    case 1: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        String type = this.getType(hmc);
                        Boolean bl = type.equalsIgnoreCase(ExternalTableType.Row().toString());
                        return bl;
                    }
                    case 2: {
                        HiveMetaStoreClient hmc = (HiveMetaStoreClient)SnappyHiveCatalog.this.hmClients.get();
                        String type = this.getType(hmc);
                        Boolean bl = !type.equalsIgnoreCase(ExternalTableType.Row().toString());
                        return bl;
                    }
                }
                throw new IllegalStateException("HiveMetaStoreClient:unknown query option");
            }
            finally {
                GfxdDataDictionary.SKIP_LOCKS.set(false);
            }
        }

        public String toString() {
            return "HiveMetaStoreQuery:query type = " + this.qType + " tname = " + this.tableName + " db = " + this.dbName;
        }

        private void initHMC() {
            boolean snappyFunSuite = Boolean.getBoolean("scalaTest");
            String url = "jdbc:snappydata:;user=" + SnappyStoreHiveCatalog.HIVE_METASTORE() + ";disable-streaming=true" + (snappyFunSuite ? "" : ";default-persistent=true");
            HiveConf metadataConf = new HiveConf();
            metadataConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, url);
            metadataConf.setVar(HiveConf.ConfVars.METASTORE_CONNECTION_DRIVER, "com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
            try {
                HiveMetaStoreClient hmc = new HiveMetaStoreClient(metadataConf);
                SnappyHiveCatalog.this.hmClients.set(hmc);
                SnappyHiveCatalog.this.allHMclients.add(hmc);
            }
            catch (MetaException me) {
                throw new IllegalStateException(me);
            }
        }

        private String getType(HiveMetaStoreClient hmc) throws SQLException {
            try {
                Table t = hmc.getTable(this.dbName, this.tableName);
                return (String)t.getParameters().get("EXTERNAL");
            }
            catch (NoSuchObjectException nsoe) {
                return ExternalTableType.Row().toString();
            }
            catch (TException te) {
                throw Util.generateCsSQLException((String)"XIE0M.S", (Object)this.tableName, (Object)((Object)te));
            }
        }
    }
}

