/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.snappydata.Constant$;
import io.snappydata.MemoryAnalytics;
import io.snappydata.UIAnalytics;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.execution.ConnectionPool$;
import org.apache.spark.sql.execution.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.columnar.impl.ColumnFormatRelation$;
import org.apache.spark.sql.sources.ConnectionProperties;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ObjectRef;

public final class SnappyAnalyticsService$
implements Logging {
    public static final SnappyAnalyticsService$ MODULE$;
    private volatile TrieMap<String, MemoryAnalytics> tableStats;
    private ScheduledExecutorService analyticsExecutor;
    private ConnectionProperties connProperties;
    private final MemoryAnalytics defaultStats;
    private final int ZERO;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new SnappyAnalyticsService$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private TrieMap<String, MemoryAnalytics> tableStats() {
        return this.tableStats;
    }

    private void tableStats_$eq(TrieMap<String, MemoryAnalytics> x$1) {
        this.tableStats = x$1;
    }

    private ScheduledExecutorService analyticsExecutor() {
        return this.analyticsExecutor;
    }

    private void analyticsExecutor_$eq(ScheduledExecutorService x$1) {
        this.analyticsExecutor = x$1;
    }

    private ConnectionProperties connProperties() {
        return this.connProperties;
    }

    private void connProperties_$eq(ConnectionProperties x$1) {
        this.connProperties = x$1;
    }

    public MemoryAnalytics defaultStats() {
        return this.defaultStats;
    }

    private final int ZERO() {
        return 0;
    }

    public void start(SparkContext sc) {
        String delayInMillisconds = sc.getConf().getOption("spark.snappy.analyticsService.interval").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return Constant$.MODULE$.DEFAULT_ANALYTICS_SERVICE_INTERVAL();
            }
        }).toString();
        this.connProperties_$eq(ExternalStoreUtils$.MODULE$.validateAndGetAllProps(sc, (Map<String, String>)Map$.MODULE$.empty()));
        if (this.analyticsExecutor() == null || this.analyticsExecutor().isShutdown()) {
            this.analyticsExecutor_$eq(this.newDaemonSingleThreadScheduledExecutor("SnappyAnalyticsService"));
            this.analyticsExecutor().scheduleWithFixedDelay(this.getTotalMemoryUsagePerTable(), 0L, new StringOps(Predef$.MODULE$.augmentString(delayInMillisconds)).toLong(), TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (!this.analyticsExecutor().isShutdown()) {
            this.analyticsExecutor().shutdown();
            this.analyticsExecutor().awaitTermination(Constant$.MODULE$.DEFAULT_ANALYTICS_SERVICE_INTERVAL(), TimeUnit.MILLISECONDS);
        }
    }

    private Runnable getTotalMemoryUsagePerTable() {
        return new Runnable(){

            public void run() {
                SnappyAnalyticsService$.MODULE$.tryExecute(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Connection conn) {
                        SnappyAnalyticsService$.MODULE$.io$snappydata$SnappyAnalyticsService$$getMemoryAnalyticsdetails(conn);
                    }
                }, SnappyAnalyticsService$.MODULE$.tryExecute$default$2(), ClassTag$.MODULE$.Unit());
            }
        };
    }

    public void io$snappydata$SnappyAnalyticsService$$getMemoryAnalyticsdetails(Connection conn) {
        TrieMap currentTableStats = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        String stmt = "select TABLE_NAME, SUM(ENTRY_SIZE), SUM(KEY_SIZE), SUM(VALUE_SIZE),SUM(VALUE_SIZE_OFFHEAP),SUM(TOTAL_SIZE)from SYS.MEMORYANALYTICS WHERE table_name not like 'HIVE_METASTORE%'  group by TABLE_NAME";
        ResultSet rs = conn.prepareStatement(stmt).executeQuery();
        while (rs.next()) {
            String name = rs.getString(1);
            long entrySize = this.convertToBytes(rs.getString(2));
            long keySize = this.convertToBytes(rs.getString(3));
            long valueSize = this.convertToBytes(rs.getString(4));
            long valueSizeOffHeap = this.convertToBytes(rs.getString(5));
            long totalSize = this.convertToBytes(rs.getString(6));
            currentTableStats.put((Object)name, (Object)new MemoryAnalytics(entrySize, keySize, valueSize, valueSizeOffHeap, totalSize));
        }
        this.tableStats_$eq((TrieMap<String, MemoryAnalytics>)currentTableStats);
    }

    private long convertToBytes(String value) {
        return value == null ? 0L : (long)(new StringOps(Predef$.MODULE$.augmentString(value)).toDouble() * (double)1024);
    }

    public String io$snappydata$SnappyAnalyticsService$$getRowBufferName(String columnStoreName) {
        return new StringBuilder().append((Object)Constant$.MODULE$.DEFAULT_SCHEMA()).append((Object)columnStoreName.replace("_COLUMN_STORE_", "").replace("SNAPPYSYS_INTERNAL", "").trim()).toString();
    }

    public boolean io$snappydata$SnappyAnalyticsService$$isColumnTable(String tablename) {
        return tablename.startsWith("SNAPPYSYS_INTERNAL") && tablename.endsWith("_COLUMN_STORE_");
    }

    public long getTableSize(String tableName, boolean isColumnTable) {
        long l;
        TrieMap<String, MemoryAnalytics> currentTableStats = this.tableStats();
        if (currentTableStats != null && currentTableStats.contains((Object)tableName)) {
            if (isColumnTable) {
                ((MemoryAnalytics)currentTableStats.get((Object)ColumnFormatRelation$.MODULE$.cachedBatchTableName(tableName)).getOrElse((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final MemoryAnalytics apply() {
                        return SnappyAnalyticsService$.MODULE$.defaultStats();
                    }
                })).valueSize();
                l = ((MemoryAnalytics)currentTableStats.get((Object)tableName).get()).valueSize();
            } else {
                l = ((MemoryAnalytics)currentTableStats.get((Object)tableName).get()).valueSize();
            }
        } else {
            l = this.defaultStats().valueSize();
        }
        return l;
    }

    public boolean getTableSize$default$2() {
        return false;
    }

    public Seq<UIAnalytics> getUIInfo() {
        TrieMap<String, MemoryAnalytics> currentTableStats = this.tableStats();
        if (currentTableStats == null) {
            return (Seq)scala.collection.Seq$.MODULE$.empty();
        }
        TrieMap internalColumnTables = (TrieMap)currentTableStats.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, MemoryAnalytics> entry) {
                return SnappyAnalyticsService$.MODULE$.io$snappydata$SnappyAnalyticsService$$isColumnTable((String)entry._1());
            }
        });
        ObjectRef columnTableNames = new ObjectRef((Object)((scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        return ((TraversableOnce)((TraversableLike)internalColumnTables.map((Function1)new Serializable(currentTableStats, columnTableNames){
            public static final long serialVersionUID = 0L;
            private final TrieMap currentTableStats$1;
            private final ObjectRef columnTableNames$1;

            public final UIAnalytics apply(Tuple2<String, MemoryAnalytics> entry) {
                String rowBuffer = SnappyAnalyticsService$.MODULE$.io$snappydata$SnappyAnalyticsService$$getRowBufferName((String)entry._1());
                long rowBufferSize = ((MemoryAnalytics)this.currentTableStats$1.get((Object)rowBuffer).get()).totalSize();
                this.columnTableNames$1.elem = (scala.collection.mutable.Seq)((SeqLike)((scala.collection.mutable.Seq)this.columnTableNames$1.elem).$plus$colon((Object)rowBuffer, Seq$.MODULE$.canBuildFrom())).$plus$colon(entry._1(), Seq$.MODULE$.canBuildFrom());
                return new UIAnalytics(rowBuffer, rowBufferSize, ((MemoryAnalytics)entry._2()).totalSize(), true);
            }
            {
                this.currentTableStats$1 = currentTableStats$1;
                this.columnTableNames$1 = columnTableNames$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableLike)currentTableStats.filter((Function1)new Serializable(columnTableNames){
            public static final long serialVersionUID = 0L;
            private final ObjectRef columnTableNames$1;

            public final boolean apply(Tuple2<String, MemoryAnalytics> entry) {
                return !((scala.collection.mutable.Seq)this.columnTableNames$1.elem).contains(entry._1());
            }
            {
                this.columnTableNames$1 = columnTableNames$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UIAnalytics apply(Tuple2<String, MemoryAnalytics> rowEntry) {
                return new UIAnalytics((String)rowEntry._1(), ((MemoryAnalytics)rowEntry._2()).totalSize(), 0L, false);
            }
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final <T> T tryExecute(Function1<Connection, T> f, boolean closeOnSuccess, ClassTag<T> evidence$1) {
        Object object;
        block5: {
            Connection conn = ConnectionPool$.MODULE$.getPoolConnection("SYS.MEMORYANALYTICS", this.connProperties().dialect(), this.connProperties().poolProps(), this.connProperties().connProps(), this.connProperties().hikariCP());
            boolean isClosed = false;
            try {
                object = f.apply((Object)conn);
                if (!closeOnSuccess || isClosed) break block5;
            }
            catch (Throwable throwable) {
                try {
                    conn.close();
                    isClosed = true;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    if (closeOnSuccess && !isClosed) {
                        conn.close();
                    }
                    throw throwable2;
                }
            }
            conn.close();
        }
        return (T)object;
    }

    public final <T> boolean tryExecute$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private ScheduledExecutorService newDaemonSingleThreadScheduledExecutor(String threadName) {
        void var3_3;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadName).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        return var3_3;
    }

    private SnappyAnalyticsService$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.tableStats = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.analyticsExecutor = null;
        this.connProperties = null;
        this.defaultStats = new MemoryAnalytics(0L, 0L, 0L, 0L, 0L);
    }
}

