/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.columnar.ConnectionProperties;
import org.apache.spark.sql.columnar.DefaultSource;
import org.apache.spark.sql.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.columnar.JDBCAppendableRelation;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.row.GemFireXDBaseDialect;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.store.ExternalStore;
import org.apache.spark.sql.store.JDBCSourceAsStore;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001b\tA2i\u001c7v[:\f'OU3mCRLwN\u001c)s_ZLG-\u001a:\u000b\u0005\r!\u0011\u0001C2pYVlg.\u0019:\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qAC\u0007\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]!\u0011aB:pkJ\u001cWm]\u0005\u00033Y\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003+mI!\u0001\b\f\u00033\r\u0013X-\u0019;bE2,'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003\tAQa\t\u0001\u0005\u0002\u0011\nab\u0019:fCR,'+\u001a7bi&|g\u000eF\u0003&Q9\u001at\b\u0005\u0002\"M%\u0011qE\u0001\u0002\u0017\u0015\u0012\u00135)\u00119qK:$\u0017M\u00197f%\u0016d\u0017\r^5p]\")\u0011F\ta\u0001U\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005-bS\"\u0001\u0003\n\u00055\"!AC*R\u0019\u000e{g\u000e^3yi\")qF\ta\u0001a\u0005!Qn\u001c3f!\tY\u0013'\u0003\u00023\t\tA1+\u0019<f\u001b>$W\rC\u00035E\u0001\u0007Q'A\u0004paRLwN\\:\u0011\tYJD\b\u0010\b\u0003\u001f]J!\u0001\u000f\t\u0002\rA\u0013X\rZ3g\u0013\tQ4HA\u0002NCBT!\u0001\u000f\t\u0011\u0005Yj\u0014B\u0001 <\u0005\u0019\u0019FO]5oO\")\u0001I\ta\u0001\u0003\u000611o\u00195f[\u0006\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0003\u0002\u000bQL\b/Z:\n\u0005\u0019\u001b%AC*ueV\u001cG\u000fV=qK\")1\u0005\u0001C!\u0011R!Q%\u0013&L\u0011\u0015Is\t1\u0001+\u0011\u0015!t\t1\u00016\u0011\u0015\u0001u\t1\u0001B\u0011\u0015\u0019\u0003\u0001\"\u0011N)\u0015q\u0015KU*U!\t)r*\u0003\u0002Q-\ta!)Y:f%\u0016d\u0017\r^5p]\")\u0011\u0006\u0014a\u0001U!)q\u0006\u0014a\u0001a!)A\u0007\u0014a\u0001k!)Q\u000b\u0014a\u0001-\u0006!A-\u0019;b!\tYs+\u0003\u0002Y\t\tIA)\u0019;b\rJ\fW.\u001a\u0005\u00065\u0002!\taW\u0001\fO\u0016$(+\u001a7bi&|g\u000eF\u0002!9vCQ!K-A\u0002)BQ\u0001N-A\u0002UBQa\u0018\u0001\u0005\u0002\u0001\f\u0011cZ3u\u000bb$XM\u001d8bYN{WO]2f)\u0011\tw\r[7\u0011\u0005\t,W\"A2\u000b\u0005\u0011$\u0011!B:u_J,\u0017B\u00014d\u00055)\u0005\u0010^3s]\u0006d7\u000b^8sK\")\u0011F\u0018a\u0001U!)\u0011N\u0018a\u0001U\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u0004\"!I6\n\u00051\u0014!\u0001F\"p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000fC\u0003o=\u0002\u0007q.A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003\u001fAL!!\u001d\t\u0003\u0007%sG\u000f")
public class ColumnarRelationProvider
implements SchemaRelationProvider,
CreatableRelationProvider {
    public JDBCAppendableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, StructType schema) {
        HashMap parameters = new HashMap();
        parameters.$plus$plus$eq(options);
        String table = ExternalStoreUtils$.MODULE$.removeInternalProps((scala.collection.mutable.Map<String, String>)parameters);
        SparkContext sc = sqlContext.sparkContext();
        ConnectionProperties connectionProperties = ExternalStoreUtils$.MODULE$.validateAndGetAllProps(sc, (scala.collection.mutable.Map<String, String>)parameters);
        int partitions = ExternalStoreUtils$.MODULE$.getTotalPartitions(sc, (scala.collection.mutable.Map<String, String>)parameters, false, ExternalStoreUtils$.MODULE$.getTotalPartitions$default$4(), ExternalStoreUtils$.MODULE$.getTotalPartitions$default$5());
        ExternalStore externalStore = this.getExternalSource(sqlContext, connectionProperties, partitions);
        boolean success = false;
        JDBCAppendableRelation relation = new JDBCAppendableRelation(SnappyStoreHiveCatalog$.MODULE$.processTableIdentifier(table, sqlContext.conf()), this.getClass().getCanonicalName(), mode, schema, options, externalStore, sqlContext);
        try {
            relation.createTable(mode);
            success = true;
            return relation;
        }
        finally {
            if (!success) {
                relation.destroy(true);
            }
        }
    }

    public JDBCAppendableRelation createRelation(SQLContext sqlContext, Map<String, String> options, StructType schema) {
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        ColumnarRelationProvider rel = this.getRelation(sqlContext, options);
        return rel.createRelation(sqlContext, mode, options, schema);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, DataFrame data) {
        ColumnarRelationProvider rel = this.getRelation(sqlContext, options);
        JDBCAppendableRelation relation = rel.createRelation(sqlContext, mode, options, data.schema());
        boolean success = false;
        try {
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            relation.insert(data, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
            success = true;
            return relation;
        }
        finally {
            if (!success) {
                relation.destroy(true);
            }
        }
    }

    public ColumnarRelationProvider getRelation(SQLContext sqlContext, Map<String, String> options) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL(this.sqlContext$1.sparkContext());
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
        JdbcDialect jdbcDialect = JdbcDialects$.MODULE$.get(url);
        Class clazz = jdbcDialect instanceof GemFireXDBaseDialect ? ResolvedDataSource$.MODULE$.lookupDataSource("org.apache.spark.sql.columntable.DefaultSource") : DefaultSource.class;
        Class clazz2 = clazz;
        return (ColumnarRelationProvider)clazz2.newInstance();
    }

    public ExternalStore getExternalSource(SQLContext sqlContext, ConnectionProperties connectionProperties, int numPartitions) {
        return new JDBCSourceAsStore(connectionProperties, numPartitions);
    }
}

