/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.Logging;
import org.apache.spark.rdd.EmptyRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.DDLException;
import org.apache.spark.sql.hive.QualifiedTableName;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DependencyCatalog$;
import org.apache.spark.sql.sources.DependentRelation;
import org.apache.spark.sql.sources.DestroyRelation;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.ParentRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.streaming.SnappyStreamingContext;
import org.apache.spark.sql.streaming.SnappyStreamingContext$;
import org.apache.spark.sql.streaming.StreamBaseRelation$;
import org.apache.spark.sql.streaming.StreamPlan;
import org.apache.spark.sql.streaming.StreamToRowsConverter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t}a!B\u0001\u0003\u0003\u0003i!AE*ue\u0016\fWNQ1tKJ+G.\u0019;j_:T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0003\u0001\u000f)]Yb$I\u0014\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011aB:pkJ\u001cWm]\u0005\u0003'A\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"aD\u000b\n\u0005Y\u0001\"A\u0004)be\u0016tGOU3mCRLwN\u001c\t\u00031ei\u0011AA\u0005\u00035\t\u0011!b\u0015;sK\u0006l\u0007\u000b\\1o!\tyA$\u0003\u0002\u001e!\tIA+\u00192mKN\u001b\u0017M\u001c\t\u0003\u001f}I!\u0001\t\t\u0003\u001f\u0011+7\u000f\u001e:psJ+G.\u0019;j_:\u0004\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001K\u0015\u000e\u0003\u0019I!A\u000b\u0004\u0003\u000f1{wmZ5oO\"AA\u0006\u0001B\u0001B\u0003%Q&A\u0004paRLwN\\:\u0011\t9\nD\u0007\u000e\b\u0003E=J!\u0001M\u0012\u0002\rA\u0013X\rZ3g\u0013\t\u00114GA\u0002NCBT!\u0001M\u0012\u0011\u00059*\u0014B\u0001\u001c4\u0005\u0019\u0019FO]5oO\")\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"\"AO\u001e\u0011\u0005a\u0001\u0001\"\u0002\u00178\u0001\u0004i\u0003\"B\u001f\u0001\t\u000bq\u0014aB2p]R,\u0007\u0010^\u000b\u0002\u007fA\u0011\u0001\u0004Q\u0005\u0003\u0003\n\u0011ac\u00158baBL8\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001E\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u00015\u0011\u00191\u0005\u0001)A\u0005i\u0005QA/\u00192mK:\u000bW.\u001a\u0011)\u0005\u0015C\u0005C\u0001\u0012J\u0013\tQ5EA\u0005ue\u0006t7/[3oi\")A\n\u0001C!\u001b\u0006a\u0011\r\u001a3EKB,g\u000eZ3oiR\u0019a*\u0015,\u0011\u0005\tz\u0015B\u0001)$\u0005\u001d\u0011un\u001c7fC:DQAU&A\u0002M\u000b\u0011\u0002Z3qK:$WM\u001c;\u0011\u0005=!\u0016BA+\u0011\u0005E!U\r]3oI\u0016tGOU3mCRLwN\u001c\u0005\u0006/.\u0003\r\u0001W\u0001\bG\u0006$\u0018\r\\8h!\tIF,D\u0001[\u0015\tYF!\u0001\u0003iSZ,\u0017BA/[\u0005Y\u0019f.\u00199qsN#xN]3ISZ,7)\u0019;bY><\u0007\"B0\u0001\t\u0003\u0002\u0017a\u0004:f[>4X\rR3qK:$WM\u001c;\u0015\u00079\u000b'\rC\u0003S=\u0002\u00071\u000bC\u0003X=\u0002\u0007\u0001\fC\u0003e\u0001\u0011\u0005S-A\u0007hKR$U\r]3oI\u0016tGo\u001d\u000b\u0003MJ\u00042aZ85\u001d\tAWN\u0004\u0002jY6\t!N\u0003\u0002l\u0019\u00051AH]8pizJ\u0011\u0001J\u0005\u0003]\u000e\nq\u0001]1dW\u0006<W-\u0003\u0002qc\n\u00191+Z9\u000b\u00059\u001c\u0003\"B,d\u0001\u0004A\u0006b\u0002;\u0001\u0005\u0004%\t!^\u0001\rgR|'/Y4f\u0019\u00164X\r\\\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011PB\u0001\bgR|'/Y4f\u0013\tY\bP\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0004~\u0001\u0001\u0006IA^\u0001\u000egR|'/Y4f\u0019\u00164X\r\u001c\u0011\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003\tAB]8x\u0007>tg/\u001a:uKJ,\"!a\u0001\u0011\u0007a\t)!C\u0002\u0002\b\t\u0011Qc\u0015;sK\u0006lGk\u001c*poN\u001cuN\u001c<feR,'\u000f\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0002\u00035\u0011xn^\"p]Z,'\u000f^3sA!9\u0011q\u0002\u0001\u0007\u0012\u0005E\u0011aD2sK\u0006$XMU8x'R\u0014X-Y7\u0015\u0005\u0005M\u0001CBA\u000b\u0003;\t\t#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u001d!7\u000f\u001e:fC6T!a\u0001\u0004\n\t\u0005}\u0011q\u0003\u0002\b\tN#(/Z1n!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\t\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002,\u0005\u0015\"aC%oi\u0016\u0014h.\u00197S_^D!\"a\f\u0001\u0011\u000b\u0007IQIA\u0019\u0003%\u0011xn^*ue\u0016\fW.\u0006\u0002\u0002\u0014!Q\u0011Q\u0007\u0001\t\u0002\u0003\u0006k!a\u0005\u0002\u0015I|wo\u0015;sK\u0006l\u0007\u0005K\u0002\u00024!Cq!a\u000f\u0001\t\u0003\ni$A\u0005ck&dGmU2b]R\u0011\u0011q\b\t\u0007\u0003\u0003\n9%a\u0013\u000e\u0005\u0005\r#bAA#\r\u0005\u0019!\u000f\u001a3\n\t\u0005%\u00131\t\u0002\u0004%\u0012#\u0005\u0003BA'\u0003\u001fj\u0011\u0001B\u0005\u0004\u0003#\"!a\u0001*po\"9\u0011Q\u000b\u0001\u0005B\u0005]\u0013a\u00023fgR\u0014x.\u001f\u000b\u0005\u00033\ny\u0006E\u0002#\u00037J1!!\u0018$\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005\u00141\u000ba\u0001\u001d\u0006A\u0011NZ#ySN$8\u000fC\u0004\u0002f\u0001!\t!a\u001a\u0002\u0011Q\u0014XO\\2bi\u0016$\"!!\u0017\b\u000f\u0005-$\u0001#\u0003\u0002n\u0005\u00112\u000b\u001e:fC6\u0014\u0015m]3SK2\fG/[8o!\rA\u0012q\u000e\u0004\u0007\u0003\tAI!!\u001d\u0014\r\u0005=\u00141O\u0014\"!\r\u0011\u0013QO\u0005\u0004\u0003o\u001a#AB!osJ+g\rC\u00049\u0003_\"\t!a\u001f\u0015\u0005\u00055\u0004\"CA@\u0003_\u0002\u000b\u0011BAA\u00035!\u0018M\u00197f)>\u001cFO]3b[B9\u00111QAGi\u0005MQBAAC\u0015\u0011\t9)!#\u0002\u000f5,H/\u00192mK*\u0019\u00111R\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0006\u0015%a\u0002%bg\"l\u0015\r\u001d\u0005\n\u0003'\u000by\u0007)A\u0005\u0003+\u000bA\u0001T(D\u0017B!\u0011qSAQ\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006u\u0015\u0001\u00027b]\u001eT!!a(\u0002\t)\fg/Y\u0005\u0005\u0003G\u000bIJ\u0001\u0004PE*,7\r\u001e\u0005\u000b\u0003O\u000by\u00071A\u0005\u0002\u0005%\u0016!\u0003<bY&$G+[7f+\t\tY\u000b\u0005\u0003\u0002.\u0006=VBAA\u000e\u0013\u0011\t\t,a\u0007\u0003\tQKW.\u001a\u0005\u000b\u0003k\u000by\u00071A\u0005\u0002\u0005]\u0016!\u0004<bY&$G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0005e\u0006BCA^\u0003g\u000b\t\u00111\u0001\u0002,\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005}\u0016q\u000eQ!\n\u0005-\u0016A\u0003<bY&$G+[7fA!A\u00111YA8\t\u0003\t)-\u0001\u0007tKR4\u0016\r\\5e)&lW\r\u0006\u0003\u0002Z\u0005\u001d\u0007\u0002CAe\u0003\u0003\u0004\r!a+\u0002\tQLW.\u001a\u0005\t\u0003\u001b\fy\u0007\"\u0003\u0002P\u0006!r-\u001a;Pe\u000e\u0013X-\u0019;f%><8\u000b\u001e:fC6$b!a\u0005\u0002R\u0006M\u0007BB\"\u0002L\u0002\u0007A\u0007\u0003\u0005\u0002V\u0006-\u0007\u0019AAl\u00031\u0019'/Z1uKN#(/Z1n!\u0015\u0011\u0013\u0011\\Ao\u0013\r\tYn\t\u0002\n\rVt7\r^5p]B\u0002bAIAp\u0003'1\u0017bAAqG\t1A+\u001e9mKJB\u0001\"!:\u0002p\u0011%\u0011q]\u0001\re\u0016lwN^3TiJ,\u0017-\u001c\u000b\u0005\u0003S\fy\u000fE\u0003#\u0003W\f\u0019\"C\u0002\u0002n\u000e\u0012aa\u00149uS>t\u0007BB\"\u0002d\u0002\u0007A\u0007\u0003\u0005\u0002t\u0006=D\u0011AA{\u0003)\u0019Ho\u001c9TiJ,\u0017-\u001c\u000b\u0005\u00033\n9\u0010\u0003\u0005\u0002z\u0006E\b\u0019AA~\u0003\u0019\u0019HO]3b[B\"\u0011Q B\u0002!\u0019\t)\"!\b\u0002\u0000B!!\u0011\u0001B\u0002\u0019\u0001!AB!\u0002\u0002x\u0006\u0005\t\u0011!B\u0001\u0005\u000f\u00111a\u0018\u00132#\u0011\u0011IAa\u0004\u0011\u0007\t\u0012Y!C\u0002\u0003\u000e\r\u0012qAT8uQ&tw\rE\u0002#\u0005#I1Aa\u0005$\u0005\r\te.\u001f\u0005\n\u0005/\ty\u0007\"\u0001\u0003\u0003O\nAb\u00197fCJ\u001cFO]3b[ND!Ba\u0007\u0002p\u0005\u0005I\u0011\u0002B\u000f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0005")
public abstract class StreamBaseRelation
extends BaseRelation
implements ParentRelation,
StreamPlan,
TableScan,
DestroyRelation,
Serializable,
Logging {
    private final Map<String, String> options;
    private final transient String tableName;
    private final StorageLevel storageLevel;
    private final StreamToRowsConverter rowConverter;
    private transient DStream<InternalRow> rowStream;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile transient boolean bitmap$trans$0;

    public static void stopStream(DStream<?> dStream) {
        StreamBaseRelation$.MODULE$.stopStream(dStream);
    }

    public static void setValidTime(Time time) {
        StreamBaseRelation$.MODULE$.setValidTime(time);
    }

    public static void validTime_$eq(Time time) {
        StreamBaseRelation$.MODULE$.validTime_$eq(time);
    }

    public static Time validTime() {
        return StreamBaseRelation$.MODULE$.validTime();
    }

    private DStream rowStream$lzycompute() {
        StreamBaseRelation streamBaseRelation = this;
        synchronized (streamBaseRelation) {
            if (!this.bitmap$trans$0) {
                this.rowStream = StreamBaseRelation$.MODULE$.org$apache$spark$sql$streaming$StreamBaseRelation$$getOrCreateRowStream(this.tableName(), (Function0<Tuple2<DStream<InternalRow>, Seq<String>>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StreamBaseRelation $outer;

                    public final Tuple2<DStream<InternalRow>, Seq<String>> apply() {
                        DStream<InternalRow> stream = this.$outer.createRowStream();
                        SnappyStoreHiveCatalog catalog = this.$outer.context().snappyContext().catalog();
                        Seq initDependents = (Seq)catalog.getDataSourceTables((Seq<Enumeration.Value>)((Seq)Seq$.MODULE$.empty()), (Option<String>)new Some((Object)this.$outer.tableName())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(QualifiedTableName x$1) {
                                return x$1.toString();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Tuple2(stream, (Object)initDependents);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$trans$0 = true;
            }
            return this.rowStream;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public final SnappyStreamingContext context() {
        return (SnappyStreamingContext)((Object)SnappyStreamingContext$.MODULE$.getActive().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("No active streaming context");
            }
        }));
    }

    public String tableName() {
        return this.tableName;
    }

    @Override
    public boolean addDependent(DependentRelation dependent, SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.addDependent(this.tableName(), dependent.name());
    }

    @Override
    public boolean removeDependent(DependentRelation dependent, SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.removeDependent(this.tableName(), dependent.name());
    }

    @Override
    public Seq<String> getDependents(SnappyStoreHiveCatalog catalog) {
        return DependencyCatalog$.MODULE$.getDependents(this.tableName());
    }

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public StreamToRowsConverter rowConverter() {
        return this.rowConverter;
    }

    public abstract DStream<InternalRow> createRowStream();

    @Override
    public final DStream<InternalRow> rowStream() {
        return this.bitmap$trans$0 ? this.rowStream : this.rowStream$lzycompute();
    }

    public RDD<Row> buildScan() {
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)this.schema());
        return this.rowStream().generatedRDDs().isEmpty() ? new EmptyRDD(this.sqlContext().sparkContext(), ClassTag$.MODULE$.apply(Row.class)) : ((RDD)((Tuple2)this.rowStream().generatedRDDs().maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Time apply(Tuple2<Time, RDD<InternalRow>> x$2) {
                return (Time)x$2._1();
            }
        }, Time$.MODULE$.ordering()))._2()).map((Function1)new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final Function1 converter$1;

            public final Object apply(InternalRow x$3) {
                return this.converter$1.apply((Object)x$3);
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.Any());
    }

    @Override
    public void destroy(boolean ifExists) {
        StreamBaseRelation$.MODULE$.org$apache$spark$sql$streaming$StreamBaseRelation$$removeStream(this.tableName()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DStream<?> stream) {
                StreamBaseRelation$.MODULE$.stopStream(stream);
            }
        });
        DependencyCatalog$.MODULE$.removeAllDependents(this.tableName());
    }

    @Override
    public void truncate() {
        throw new DDLException("Stream tables cannot be truncated");
    }

    private final StreamToRowsConverter liftedTree1$1() {
        try {
            Class<?> clz = Utils$.MODULE$.getContextOrSparkClassLoader().loadClass((String)this.options.apply((Object)"rowConverter"));
            return (StreamToRowsConverter)clz.newInstance();
        }
        catch (Exception exception) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load class : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.toString()})));
        }
    }

    public StreamBaseRelation(Map<String, String> options) {
        this.options = options;
        Logging.class.$init$((Logging)this);
        this.tableName = (String)options.apply((Object)JdbcExtendedUtils$.MODULE$.DBTABLE_PROPERTY());
        this.storageLevel = (StorageLevel)options.get((Object)"storageLevel").map((Function1)new $anonfun$1(this)).getOrElse((Function0)new $anonfun$2(this));
        this.rowConverter = this.liftedTree1$1();
    }
}

