/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.columnar.ConnectionProperties;
import org.apache.spark.sql.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.hive.SnappyStoreHiveCatalog$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.row.JDBCMutableRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.ExternalSchemaRelationProvider;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0001\u0002\u0002\u00025\u0011q#T;uC\ndWMU3mCRLwN\u001c)s_ZLG-\u001a:\u000b\u0005\r!\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0007\u00019!\u0002d\u0007\u0010\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0010FqR,'O\\1m'\u000eDW-\\1SK2\fG/[8o!J|g/\u001b3feB\u0011Q#G\u0005\u00035\t\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003+qI!!\b\u0002\u0003!I+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\bCA\u000b \u0013\t\u0001#AA\rDe\u0016\fG/\u00192mKJ+G.\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\bF\u0001%!\t)\u0002\u0001C\u0003'\u0001\u0011\u0005s%\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\u000b!rC'O#\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\"\u0011a\u0001:po&\u0011QF\u000b\u0002\u0014\u0015\u0012\u00135)T;uC\ndWMU3mCRLwN\u001c\u0005\u0006_\u0015\u0002\r\u0001M\u0001\u000bgFd7i\u001c8uKb$\bCA\u00193\u001b\u0005!\u0011BA\u001a\u0005\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006k\u0015\u0002\rAN\u0001\u0005[>$W\r\u0005\u00022o%\u0011\u0001\b\u0002\u0002\t'\u00064X-T8eK\")!(\na\u0001w\u00059q\u000e\u001d;j_:\u001c\b\u0003\u0002\u001f@\u0005\ns!aD\u001f\n\u0005y\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n\u0019Q*\u00199\u000b\u0005y\u0002\u0002C\u0001\u001fD\u0013\t!\u0015I\u0001\u0004TiJLgn\u001a\u0005\u0006\r\u0016\u0002\rAQ\u0001\u0007g\u000eDW-\\1\t\u000b\u0019\u0002A\u0011\t%\u0015\t!J%j\u0013\u0005\u0006_\u001d\u0003\r\u0001\r\u0005\u0006u\u001d\u0003\ra\u000f\u0005\u0006\r\u001e\u0003\r\u0001\u0014\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u0012\tQ\u0001^=qKNL!!\u0015(\u0003\u0015M#(/^2u)f\u0004X\rC\u0003'\u0001\u0011\u00053\u000bF\u0002))VCQa\f*A\u0002ABQA\u000f*A\u0002mBQA\n\u0001\u0005B]#R\u0001W.];z\u0003\"!F-\n\u0005i\u0013!\u0001\u0004\"bg\u0016\u0014V\r\\1uS>t\u0007\"B\u0018W\u0001\u0004\u0001\u0004\"B\u001bW\u0001\u00041\u0004\"\u0002\u001eW\u0001\u0004Y\u0004\"B0W\u0001\u0004\u0001\u0017\u0001\u00023bi\u0006\u0004\"!M1\n\u0005\t$!!\u0003#bi\u00064%/Y7f\u0001")
public abstract class MutableRelationProvider
implements ExternalSchemaRelationProvider,
SchemaRelationProvider,
RelationProvider,
CreatableRelationProvider {
    @Override
    public JDBCMutableRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, String schema) {
        JDBCPartitioningInfo jDBCPartitioningInfo;
        HashMap parameters = new HashMap();
        parameters.$plus$plus$eq(options);
        Option partitionColumn = parameters.remove((Object)"partitioncolumn");
        Option lowerBound = parameters.remove((Object)"lowerbound");
        Option upperBound = parameters.remove((Object)"upperbound");
        Option numPartitions = parameters.remove((Object)"numpartitions");
        String table = ExternalStoreUtils$.MODULE$.removeInternalProps((scala.collection.mutable.Map<String, String>)parameters);
        SparkContext sc = sqlContext.sparkContext();
        ConnectionProperties connProperties = ExternalStoreUtils$.MODULE$.validateAndGetAllProps(sc, (scala.collection.mutable.Map<String, String>)parameters);
        if (partitionColumn.isEmpty()) {
            jDBCPartitioningInfo = null;
        } else {
            if (lowerBound.isEmpty() || upperBound.isEmpty() || numPartitions.isEmpty()) {
                throw new IllegalArgumentException("JDBCUpdatableRelation: incomplete partitioning specified");
            }
            jDBCPartitioningInfo = new JDBCPartitioningInfo((String)partitionColumn.get(), new StringOps(Predef$.MODULE$.augmentString((String)lowerBound.get())).toLong(), new StringOps(Predef$.MODULE$.augmentString((String)upperBound.get())).toLong(), new StringOps(Predef$.MODULE$.augmentString((String)numPartitions.get())).toInt());
        }
        JDBCPartitioningInfo partitionInfo = jDBCPartitioningInfo;
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitionInfo);
        boolean success = false;
        JDBCMutableRelation relation = new JDBCMutableRelation(connProperties.url(), SnappyStoreHiveCatalog$.MODULE$.processTableIdentifier(table, sqlContext.conf()), this.getClass().getCanonicalName(), mode, schema, parts, connProperties.poolProps(), connProperties.connProps(), connProperties.hikariCP(), options, sqlContext);
        try {
            relation.tableSchema_$eq(relation.createTable(mode));
            success = true;
            return relation;
        }
        finally {
            if (!success) {
                relation.destroy(true);
            }
        }
    }

    public JDBCMutableRelation createRelation(SQLContext sqlContext, Map<String, String> options, StructType schema) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$1;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL(this.sqlContext$1.sparkContext());
            }
            {
                this.sqlContext$1 = sqlContext$1;
            }
        });
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String schemaString2 = JdbcExtendedUtils$.MODULE$.schemaString(schema, dialect);
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        return this.createRelation(sqlContext, mode, (Map)options, schemaString2);
    }

    public JDBCMutableRelation createRelation(SQLContext sqlContext, Map<String, String> options) {
        boolean allowExisting = options.get((Object)JdbcExtendedUtils$.MODULE$.ALLOW_EXISTING_PROPERTY()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
            }
        });
        SaveMode mode = allowExisting ? SaveMode.Ignore : SaveMode.ErrorIfExists;
        return this.createRelation(sqlContext, mode, (Map)options, "");
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> options, DataFrame data) {
        String url = (String)options.getOrElse((Object)"url", (Function0)new Serializable(this, sqlContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext sqlContext$2;

            public final String apply() {
                return ExternalStoreUtils$.MODULE$.defaultStoreURL(this.sqlContext$2.sparkContext());
            }
            {
                this.sqlContext$2 = sqlContext$2;
            }
        });
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String schemaString2 = JdbcExtendedUtils$.MODULE$.schemaString(data.schema(), dialect);
        BaseRelation relation = this.createRelation(sqlContext, mode, (Map)options, schemaString2);
        boolean success = false;
        try {
            relation.insert(data);
            success = true;
            return relation;
        }
        finally {
            if (!success) {
                relation.destroy(true);
            }
        }
    }
}

