/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.sql.Connection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.row.GemFireXDClientDialect$;
import org.apache.spark.sql.row.GemFireXDDialect$;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConnectionPool$ {
    public static final ConnectionPool$ MODULE$;
    private final ConcurrentHashMap<String, Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>> idToPoolMap;
    private final Map<Tuple3<Properties, Properties, Object>, Tuple2<javax.sql.DataSource, Set<String>>> pools;
    private final Properties EMPTY_PROPS;

    static {
        new ConnectionPool$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.sql.DataSource getPoolDataSource(String id, scala.collection.immutable.Map<String, String> props, Properties connectionProps, boolean hikariCP) {
        Object object;
        javax.sql.DataSource dataSource;
        Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> dsKey = this.idToPoolMap.get(id);
        if (dsKey != null) {
            dataSource = (javax.sql.DataSource)dsKey._1();
            return dataSource;
        }
        Map<Tuple3<Properties, Properties, Object>, Tuple2<javax.sql.DataSource, Set<String>>> map = this.pools;
        synchronized (map) {
            Object object2;
            Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> dsKey2 = this.idToPoolMap.get(id);
            if (dsKey2 == null) {
                javax.sql.DataSource dataSource2;
                Some some;
                Tuple2 tuple2;
                Properties poolProps = new Properties();
                props.withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                        Tuple2<String, String> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(poolProps){
                    public static final long serialVersionUID = 0L;
                    private final Properties poolProps$1;

                    public final Object apply(Tuple2<String, String> x$1) {
                        Tuple2<String, String> tuple2 = x$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            Object object = this.poolProps$1.setProperty(k, v);
                            return object;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.poolProps$1 = poolProps$1;
                    }
                });
                Tuple3 poolKey = new Tuple3((Object)poolProps, (Object)connectionProps, (Object)BoxesRunTime.boxToBoolean((boolean)hikariCP));
                Option option = this.pools.get((Object)poolKey);
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).x()) != null) {
                    javax.sql.DataSource newDS = (javax.sql.DataSource)tuple2._1();
                    Set ids = (Set)tuple2._2();
                    ids.$plus$eq((Object)id);
                    Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> err = this.idToPoolMap.putIfAbsent(id, (Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>)new Tuple2((Object)newDS, (Object)poolKey));
                    Predef$.MODULE$.require(err == null, (Function0)new Serializable(id, err){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;
                        private final Tuple2 err$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected existing pool for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1, this.err$1}));
                        }
                        {
                            this.id$1 = id$1;
                            this.err$1 = err$1;
                        }
                    });
                    dataSource2 = newDS;
                } else {
                    HikariDataSource hikariDataSource;
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ == null) {
                        if (option2 != null) {
                            throw new MatchError((Object)option);
                        }
                    } else if (!none$.equals(option2)) throw new MatchError((Object)option);
                    if (hikariCP) {
                        HikariConfig hconf = new HikariConfig(poolProps);
                        if (connectionProps != null) {
                            hconf.setDataSourceProperties(connectionProps);
                        }
                        hikariDataSource = new HikariDataSource(hconf);
                    } else {
                        PoolProperties tconf = new PoolProperties();
                        PropertyBeanSetter.setTargetFromProperties((Object)tconf, (Properties)poolProps);
                        if (connectionProps != null) {
                            tconf.setDbProperties(connectionProps);
                        }
                        hikariDataSource = new DataSource((PoolConfiguration)tconf);
                    }
                    HikariDataSource newDS = hikariDataSource;
                    this.pools.update((Object)poolKey, (Object)new Tuple2((Object)newDS, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{id}))));
                    Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> err = this.idToPoolMap.putIfAbsent(id, (Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>)new Tuple2((Object)newDS, (Object)poolKey));
                    Predef$.MODULE$.require(err == null, (Function0)new Serializable(id, err){
                        public static final long serialVersionUID = 0L;
                        private final String id$1;
                        private final Tuple2 err$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unexpected existing pool for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1, this.err$2}));
                        }
                        {
                            this.id$1 = id$1;
                            this.err$2 = err$2;
                        }
                    });
                    dataSource2 = newDS;
                }
                object2 = dataSource2;
            } else {
                object2 = dsKey2._1();
            }
            object = object2;
        }
        dataSource = (javax.sql.DataSource)object;
        return dataSource;
    }

    public Properties getPoolDataSource$default$3() {
        return this.EMPTY_PROPS;
    }

    public boolean getPoolDataSource$default$4() {
        return false;
    }

    public Connection getPoolConnection(String id, Option<String> driver, JdbcDialect dialect, scala.collection.immutable.Map<String, String> poolProps, Properties connProps, boolean hikariCP) {
        boolean bl;
        JdbcDialect jdbcDialect;
        GemFireXDDialect$ gemFireXDDialect$;
        JdbcDialect jdbcDialect2;
        Connection conn;
        try {
            driver.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String className2) {
                    DriverRegistry$.MODULE$.register(className2);
                }
            });
            javax.sql.DataSource ds = this.getPoolDataSource(id, poolProps, connProps, hikariCP);
            conn = ds.getConnection();
            jdbcDialect2 = dialect;
            gemFireXDDialect$ = GemFireXDDialect$.MODULE$;
            jdbcDialect = jdbcDialect2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find driver class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{driver})), classNotFoundException);
        }
        if (!(gemFireXDDialect$ != null ? !((Object)((Object)gemFireXDDialect$)).equals(jdbcDialect) : jdbcDialect != null)) {
            bl = true;
        } else {
            GemFireXDClientDialect$ gemFireXDClientDialect$ = GemFireXDClientDialect$.MODULE$;
            JdbcDialect jdbcDialect3 = jdbcDialect2;
            bl = !(gemFireXDClientDialect$ != null ? !((Object)((Object)gemFireXDClientDialect$)).equals(jdbcDialect3) : jdbcDialect3 != null);
        }
        if (bl) {
            conn.setTransactionIsolation(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return conn;
    }

    public Properties getPoolConnection$default$5() {
        return this.EMPTY_PROPS;
    }

    public boolean getPoolConnection$default$6() {
        return false;
    }

    public boolean org$apache$spark$sql$execution$ConnectionPool$$removePoolKey(String id, Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> dsKey) {
        boolean bl;
        Tuple3 poolKey = (Tuple3)dsKey._2();
        Set ids = (Set)((Tuple2)this.pools.apply((Object)poolKey))._2();
        ids.$minus$eq((Object)id);
        if (ids.isEmpty()) {
            this.pools.$minus$eq((Object)poolKey);
            if (BoxesRunTime.unboxToBoolean((Object)poolKey._3())) {
                ((HikariDataSource)dsKey._1()).shutdown();
            } else {
                ((DataSource)dsKey._1()).close(true);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removePoolReference(String id) {
        Boolean bl2;
        Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>> dsKey = this.idToPoolMap.remove(id);
        if (dsKey == null) {
            return false;
        }
        Map<Tuple3<Properties, Properties, Object>, Tuple2<javax.sql.DataSource, Set<String>>> map = this.pools;
        synchronized (map) {
            bl2 = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$execution$ConnectionPool$$removePoolKey(id, dsKey));
        }
        boolean bl = BoxesRunTime.unboxToBoolean((Object)bl2);
        return bl;
    }

    public void clear() {
        Map<Tuple3<Properties, Properties, Object>, Tuple2<javax.sql.DataSource, Set<String>>> map = this.pools;
        synchronized (map) {
            JavaConversions$.MODULE$.mapAsScalaMap(this.idToPoolMap).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>> x0$1) {
                    Tuple2<String, Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String id = (String)tuple2._1();
                        Tuple2 dsKey = (Tuple2)tuple2._2();
                        boolean bl = ConnectionPool$.MODULE$.org$apache$spark$sql$execution$ConnectionPool$$removePoolKey(id, (Tuple2<javax.sql.DataSource, Tuple3<Properties, Properties, Object>>)dsKey);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.pools.clear();
            this.idToPoolMap.clear();
            return;
        }
    }

    private ConnectionPool$() {
        MODULE$ = this;
        this.idToPoolMap = new ConcurrentHashMap(8, 0.75f, 1);
        this.pools = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.EMPTY_PROPS = new Properties();
    }
}

