/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.columnar;

import java.sql.Connection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.collection.UUIDRegionKey;
import org.apache.spark.sql.collection.Utils$;
import org.apache.spark.sql.columnar.CachedBatch;
import org.apache.spark.sql.columnar.CachedBatchHolder;
import org.apache.spark.sql.columnar.ColumnBuilder;
import org.apache.spark.sql.columnar.ColumnBuilder$;
import org.apache.spark.sql.columnar.ColumnType;
import org.apache.spark.sql.columnar.ColumnType$;
import org.apache.spark.sql.columnar.ExternalStoreUtils$;
import org.apache.spark.sql.columnar.JDBCAppendableRelation$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.snappy;
import org.apache.spark.sql.snappy$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DestroyRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.JdbcExtendedDialect;
import org.apache.spark.sql.sources.JdbcExtendedUtils$;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.store.ExternalStore;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rUe\u0001B\u0001\u0003\u00016\u0011aC\u0013#C\u0007\u0006\u0003\b/\u001a8eC\ndWMU3mCRLwN\u001c\u0006\u0003\u0007\u0011\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\t\u00019!rCG\u000f\"OA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\bg>,(oY3t\u0013\t\u0019\u0002C\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\u0013!J,h.\u001a3GS2$XM]3e'\u000e\fg\u000e\u0005\u0002\u00101%\u0011\u0011\u0004\u0005\u0002\u0013\u0013:\u001cXM\u001d;bE2,'+\u001a7bi&|g\u000e\u0005\u0002\u00107%\u0011A\u0004\u0005\u0002\u0010\t\u0016\u001cHO]8z%\u0016d\u0017\r^5p]B\u0011adH\u0007\u0002\r%\u0011\u0001E\u0002\u0002\b\u0019><w-\u001b8h!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u00051\u0019VM]5bY&T\u0018M\u00197f!\t\u0011\u0003&\u0003\u0002*G\t9\u0001K]8ek\u000e$\b\u0002C\u0016\u0001\u0005+\u0007I\u0011\u0001\u0017\u0002\u000bQ\f'\r\\3\u0016\u00035\u0002\"AL\u0019\u000f\u0005\tz\u0013B\u0001\u0019$\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u001a\u0003\u0002C\u001b\u0001\u0005#\u0005\u000b\u0011B\u0017\u0002\rQ\f'\r\\3!\u0011!9\u0004A!f\u0001\n\u0003a\u0013\u0001\u00039s_ZLG-\u001a:\t\u0011e\u0002!\u0011#Q\u0001\n5\n\u0011\u0002\u001d:pm&$WM\u001d\u0011\t\u0011m\u0002!Q3A\u0005\u0002q\nA!\\8eKV\tQ\b\u0005\u0002?\u007f5\tA!\u0003\u0002A\t\tA1+\u0019<f\u001b>$W\r\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0003\u0015iw\u000eZ3!\u0011!!\u0005A!f\u0001\n\u0003)\u0015AC;tKJ\u001c6\r[3nCV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\t\u0005)A/\u001f9fg&\u00111\n\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C'\u0001\u0005#\u0005\u000b\u0011\u0002$\u0002\u0017U\u001cXM]*dQ\u0016l\u0017\r\t\u0005\t\u001f\u0002\u0011)\u001a!C\u0001!\u0006YqN]5h\u001fB$\u0018n\u001c8t+\u0005\t\u0006\u0003\u0002\u0018S[5J!aU\u001a\u0003\u00075\u000b\u0007\u000f\u0003\u0005V\u0001\tE\t\u0015!\u0003R\u00031y'/[4PaRLwN\\:!\u0011!9\u0006A!f\u0001\n\u0003A\u0016!D3yi\u0016\u0014h.\u00197Ti>\u0014X-F\u0001Z!\tQV,D\u0001\\\u0015\taF!A\u0003ti>\u0014X-\u0003\u0002_7\niQ\t\u001f;fe:\fGn\u0015;pe\u0016D\u0001\u0002\u0019\u0001\u0003\u0012\u0003\u0006I!W\u0001\u000fKb$XM\u001d8bYN#xN]3!\u0011!\u0011\u0007A!f\u0001\n\u0003\u001a\u0017AC:rY\u000e{g\u000e^3yiV\tA\r\u0005\u0002?K&\u0011a\r\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\u0002\u00035\u0001\u0005#\u0005\u000b\u0011\u00023\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0015\u0003O*\u0004\"AI6\n\u00051\u001c#!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0015q\u0007\u0001\"\u0001p\u0003\u0019a\u0014N\\5u}QA\u0001O]:ukZ<\b\u0010\u0005\u0002r\u00015\t!\u0001C\u0003,[\u0002\u0007Q\u0006C\u00038[\u0002\u0007Q\u0006C\u0003<[\u0002\u0007Q\bC\u0003E[\u0002\u0007a\tC\u0003P[\u0002\u0007\u0011\u000bC\u0003X[\u0002\u0007\u0011\fC\u0003c[\u0002\u0007A\rC\u0004{\u0001\t\u0007I\u0011I>\u0002\u001d9,W\rZ\"p]Z,'o]5p]V\tA\u0010\u0005\u0002#{&\u0011ap\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0001\u0001Q\u0001\nq\fqB\\3fI\u000e{gN^3sg&|g\u000e\t\u0005\t\u0003\u000b\u0001!\u0019!C\u0001Y\u00051AM]5wKJDq!!\u0003\u0001A\u0003%Q&A\u0004ee&4XM\u001d\u0011\t\u0013\u00055\u0001A1A\u0005\u0006\u0005=\u0011a\u00023jC2,7\r^\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/!\u0011\u0001\u00026eE\u000eLA!a\u0007\u0002\u0016\tY!\n\u001a2d\t&\fG.Z2u\u0011!\ty\u0002\u0001Q\u0001\u000e\u0005E\u0011\u0001\u00033jC2,7\r\u001e\u0011\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005\u0015\u0012\u0001D:dQ\u0016l\u0017MR5fY\u0012\u001cXCAA\u0014!\u001d\tI#a\r.\u0003ki!!a\u000b\u000b\t\u00055\u0012qF\u0001\nS6lW\u000f^1cY\u0016T1!!\r$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004'\u0006-\u0002cA$\u00028%\u0019\u0011\u0011\b%\u0003\u0017M#(/^2u\r&,G\u000e\u001a\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002(\u0005i1o\u00195f[\u00064\u0015.\u001a7eg\u0002B!\"!\u0011\u0001\u0011\u000b\u0007IQAA\"\u0003%\u0019wN\u001c8fGR|'/\u0006\u0002\u0002FA)!%a\u0012\u0002L%\u0019\u0011\u0011J\u0012\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA'\u0003+j!!a\u0014\u000b\u0007\u0015\t\tF\u0003\u0002\u0002T\u0005!!.\u0019<b\u0013\u0011\t9&a\u0014\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0006\u0002\\\u0001A\t\u0011)Q\u0007\u0003\u000b\n!bY8o]\u0016\u001cGo\u001c:!\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t'\u0001\u0006ck\u001a4WM\u001d'pG.,\"!a\u0019\u0011\t\u0005\u0015\u00141O\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005)An\\2lg*!\u0011QNA8\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003c\n\t&\u0001\u0003vi&d\u0017\u0002BA;\u0003O\u0012aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0005\t\u0003s\u0002\u0001\u0015!\u0003\u0002d\u0005Y!-\u001e4gKJdunY6!\u0011!\ti\b\u0001C\u0001\t\u0005}\u0014\u0001\u0003:fC\u0012dunY6\u0016\t\u0005\u0005\u0015q\u0011\u000b\u0005\u0003\u0007\u000bI\n\u0005\u0003\u0002\u0006\u0006\u001dE\u0002\u0001\u0003\t\u0003\u0013\u000bYH1\u0001\u0002\f\n\t\u0011)\u0005\u0003\u0002\u000e\u0006M\u0005c\u0001\u0012\u0002\u0010&\u0019\u0011\u0011S\u0012\u0003\u000f9{G\u000f[5oOB\u0019!%!&\n\u0007\u0005]5EA\u0002B]fD\u0011\"a'\u0002|\u0011\u0005\r!!(\u0002\u0003\u0019\u0004RAIAP\u0003\u0007K1!!)$\u0005!a$-\u001f8b[\u0016t\u0004\u0002CAS\u0001\u0011\u0005A!a*\u0002\u0013]\u0014\u0018\u000e^3M_\u000e\\W\u0003BAU\u0003[#B!a+\u00020B!\u0011QQAW\t!\tI)a)C\u0002\u0005-\u0005\"CAN\u0003G#\t\u0019AAY!\u0015\u0011\u0013qTAV\u0011\u0019\t)\f\u0001C!\u000b\u000611o\u00195f[\u0006Dq!!/\u0001\t\u0003\nY,A\u0005ck&dGmU2b]R1\u0011QXAh\u00033\u0004b!a0\u0002F\u0006%WBAAa\u0015\r\t\u0019MB\u0001\u0004e\u0012$\u0017\u0002BAd\u0003\u0003\u00141A\u0015#E!\rq\u00141Z\u0005\u0004\u0003\u001b$!a\u0001*po\"A\u0011\u0011[A\\\u0001\u0004\t\u0019.A\bsKF,\u0018N]3e\u0007>dW/\u001c8t!\u0011\u0011\u0013Q[\u0017\n\u0007\u0005]7EA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002\\\u0006]\u0006\u0019AAo\u0003\u001d1\u0017\u000e\u001c;feN\u0004RAIAk\u0003?\u00042aDAq\u0013\r\t\u0019\u000f\u0005\u0002\u0007\r&dG/\u001a:\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\u0006I1oY1o)\u0006\u0014G.\u001a\u000b\t\u0003{\u000bY/a<\u0002r\"9\u0011Q^As\u0001\u0004i\u0013!\u0003;bE2,g*Y7f\u0011!\t\t.!:A\u0002\u0005M\u0007\u0002CAn\u0003K\u0004\r!!8\t\u000f\u0005U\b\u0001\"\u0011\u0002x\u00061\u0011N\\:feR$b!!?\u0002\u0000\n%\u0001c\u0001\u0012\u0002|&\u0019\u0011Q`\u0012\u0003\tUs\u0017\u000e\u001e\u0005\t\u0005\u0003\t\u0019\u00101\u0001\u0003\u0004\u0005\u0011AM\u001a\t\u0004}\t\u0015\u0011b\u0001B\u0004\t\tIA)\u0019;b\rJ\fW.\u001a\u0005\n\u0005\u0017\t\u0019\u0010%AA\u0002q\f\u0011b\u001c<fe^\u0014\u0018\u000e^3\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u0005\u0011R/^5e\u0005\u0006$8\r[!hOJ,w-\u0019;f)\u0019\u0011\u0019B!\u000b\u0003.A1!Q\u0003B\u000e\u0005?i!Aa\u0006\u000b\t\te\u0011qF\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iBa\u0006\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0005\u0005C\u0011)#\u0004\u0002\u0003$)\u0019\u0011\u0011\u0007\u0003\n\t\t\u001d\"1\u0005\u0002\u000e+VKEIU3hS>t7*Z=\t\u0011\t-\"Q\u0002a\u0001\u0005'\t1\"Y2dk6,H.\u0019;fI\"A!q\u0006B\u0007\u0001\u0004\u0011\t$A\u0003cCR\u001c\u0007\u000eE\u0002r\u0005gI1A!\u000e\u0003\u0005-\u0019\u0015m\u00195fI\n\u000bGo\u00195\t\u000f\u0005U\b\u0001\"\u0005\u0003:QA\u0011\u0011 B\u001e\u0005{\u0011y\u0004\u0003\u0005\u0002D\n]\u0002\u0019AA_\u0011!\u0011\tAa\u000eA\u0002\t\r\u0001b\u0002B\u0006\u0005o\u0001\r\u0001 \u0005\b\u0005\u0007\u0002A\u0011\u0001B#\u0003!!(/\u001e8dCR,GCAA}\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017\n1b\u0019:fCR,G+\u00192mKR!\u0011\u0011 B'\u0011\u0019Y$q\ta\u0001{!9!\u0011\u000b\u0001\u0005\u0012\tM\u0013aI2sK\u0006$X-\u0012=uKJt\u0017\r\u001c+bE2,gi\u001c:DC\u000eDW\r\u001a\"bi\u000eDWm\u001d\u000b\u0007\u0003s\u0014)Fa\u0016\t\u000f\u00055(q\na\u0001[!1qKa\u0014A\u0002eCqA!\u0013\u0001\t\u0003\u0011Y\u0006\u0006\u0006\u0002z\nu#q\fB2\u0005KBaa\u0016B-\u0001\u0004I\u0006b\u0002B1\u00053\u0002\r!L\u0001\ti\u0006\u0014G.Z*ue\"9\u0011Q\u001eB-\u0001\u0004i\u0003b\u0002B4\u00053\u0002\r\u0001`\u0001\rIJ|\u0007/\u00134Fq&\u001cHo\u001d\u0005\b\u0005W\u0002A\u0011\tB7\u0003\u001d!Wm\u001d;s_f$B!!?\u0003p!9!\u0011\u000fB5\u0001\u0004a\u0018\u0001C5g\u000bbL7\u000f^:\t\u000f\tU\u0004\u0001\"\u0001\u0003F\u0005qa\r\\;tQJ{wOQ;gM\u0016\u0014\b\"\u0003B=\u0001\u0005\u0005I\u0011\u0001B>\u0003\u0011\u0019w\u000e]=\u0015\u001fA\u0014iHa \u0003\u0002\n\r%Q\u0011BD\u0005\u0013C\u0001b\u000bB<!\u0003\u0005\r!\f\u0005\to\t]\u0004\u0013!a\u0001[!A1Ha\u001e\u0011\u0002\u0003\u0007Q\b\u0003\u0005E\u0005o\u0002\n\u00111\u0001G\u0011!y%q\u000fI\u0001\u0002\u0004\t\u0006\u0002C,\u0003xA\u0005\t\u0019A-\t\u0011\t\u00149\b%AA\u0002\u0011D\u0011B!$\u0001#\u0003%\tAa$\u0002!%t7/\u001a:uI\u0011,g-Y;mi\u0012\u0012TC\u0001BIU\ra(1S\u0016\u0003\u0005+\u0003BAa&\u0003\"6\u0011!\u0011\u0014\u0006\u0005\u00057\u0013i*A\u0005v]\u000eDWmY6fI*\u0019!qT\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003$\ne%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!q\u0015\u0001\u0012\u0002\u0013\u0005!\u0011V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YKK\u0002.\u0005'C\u0011Ba,\u0001#\u0003%\tA!+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I!1\u0017\u0001\u0012\u0002\u0013\u0005!QW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119LK\u0002>\u0005'C\u0011Ba/\u0001#\u0003%\tA!0\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0018\u0016\u0004\r\nM\u0005\"\u0003Bb\u0001E\u0005I\u0011\u0001Bc\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa2+\u0007E\u0013\u0019\nC\u0005\u0003L\u0002\t\n\u0011\"\u0001\u0003N\u0006q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001BhU\rI&1\u0013\u0005\n\u0005'\u0004\u0011\u0013!C\u0001\u0005+\fabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0003X*\u001aAMa%\t\u0013\tm\u0007!!A\u0005B\tu\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003`B!!\u0011\u001dBt\u001b\t\u0011\u0019O\u0003\u0003\u0003f\u0006E\u0013\u0001\u00027b]\u001eL1A\rBr\u0011%\u0011Y\u000fAA\u0001\n\u0003\u0011i/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003pB\u0019!E!=\n\u0007\tM8EA\u0002J]RD\u0011Ba>\u0001\u0003\u0003%\tA!?\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\u0013B~\u0011)\u0011iP!>\u0002\u0002\u0003\u0007!q^\u0001\u0004q\u0012\n\u0004\"CB\u0001\u0001\u0005\u0005I\u0011IB\u0002\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0003!\u0019\u00199a!\u0003\u0002\u00146\u0011\u0011qF\u0005\u0005\u0007\u0017\tyC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0019y\u0001AA\u0001\n\u0003\u0019\t\"\u0001\u0005dC:,\u0015/^1m)\ra81\u0003\u0005\u000b\u0005{\u001ci!!AA\u0002\u0005M\u0005\"CB\f\u0001\u0005\u0005I\u0011IB\r\u0003!A\u0017m\u001d5D_\u0012,GC\u0001Bx\u0011%\u0019i\u0002AA\u0001\n\u0003\u001ay\"\u0001\u0005u_N#(/\u001b8h)\t\u0011y\u000eC\u0005\u0004$\u0001\t\t\u0011\"\u0011\u0004&\u00051Q-];bYN$2\u0001`B\u0014\u0011)\u0011ip!\t\u0002\u0002\u0003\u0007\u00111S\u0004\b\u0007W\u0011\u0001\u0012AB\u0017\u0003YQEIQ\"BaB,g\u000eZ1cY\u0016\u0014V\r\\1uS>t\u0007cA9\u00040\u00191\u0011A\u0001E\u0001\u0007c\u0019baa\f\u00044u\t\u0003c\u0001\u0012\u00046%\u00191qG\u0012\u0003\r\u0005s\u0017PU3g\u0011\u001dq7q\u0006C\u0001\u0007w!\"a!\f\t\u0011\r}2q\u0006C\u0005\u0007\u0003\n!B]3n_Z,\u0007k\\8m)\u0011\u0019\u0019ea\u0017\u0011\u000b\t\n9e!\u0012\u0011\r\r\u001d3qKA}\u001d\u0011\u0019Iea\u0015\u000f\t\r-3\u0011K\u0007\u0003\u0007\u001bR1aa\u0014\r\u0003\u0019a$o\\8u}%\tA%C\u0002\u0004V\r\nq\u0001]1dW\u0006<W-\u0003\u0003\u0004\f\re#bAB+G!11f!\u0010A\u00025B!ba\u0018\u00040\u0005\u0005I\u0011QB1\u0003\u0015\t\u0007\u000f\u001d7z)=\u000181MB3\u0007O\u001aIga\u001b\u0004n\r=\u0004BB\u0016\u0004^\u0001\u0007Q\u0006\u0003\u00048\u0007;\u0002\r!\f\u0005\u0007w\ru\u0003\u0019A\u001f\t\r\u0011\u001bi\u00061\u0001G\u0011\u0019y5Q\fa\u0001#\"1qk!\u0018A\u0002eCaAYB/\u0001\u0004!\u0007fAB8U\"Q1QOB\u0018\u0003\u0003%\tia\u001e\u0002\u000fUt\u0017\r\u001d9msR!1\u0011PBC!\u0015\u001131PB@\u0013\r\u0019ih\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0015\t\u001a\t)L\u0017>\rFKF-C\u0002\u0004\u0004\u000e\u0012a\u0001V;qY\u0016<\u0004\"CBD\u0007g\n\t\u00111\u0001q\u0003\rAH\u0005\r\u0005\u000b\u0007\u0017\u001by#!A\u0005\n\r5\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa$\u0011\t\t\u00058\u0011S\u0005\u0005\u0007'\u0013\u0019O\u0001\u0004PE*,7\r\u001e")
public class JDBCAppendableRelation
extends BaseRelation
implements PrunedFilteredScan,
InsertableRelation,
DestroyRelation,
Logging,
Serializable,
Product {
    private final String table;
    private final String provider;
    private final SaveMode mode;
    private final StructType userSchema;
    private final Map<String, String> origOptions;
    private final ExternalStore externalStore;
    private final transient SQLContext sqlContext;
    private final boolean needConversion;
    private final String driver;
    private final JdbcDialect dialect;
    private final Map<String, StructField> schemaFields;
    private Function0<Connection> connector;
    private final ReentrantReadWriteLock bufferLock;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private Function0 connector$lzycompute() {
        JDBCAppendableRelation jDBCAppendableRelation = this;
        synchronized (jDBCAppendableRelation) {
            if (!this.bitmap$0) {
                this.connector = ExternalStoreUtils$.MODULE$.getConnector(this.table(), this.driver(), this.dialect(), this.externalStore().connProperties().poolProps(), this.externalStore().connProperties().connProps(), this.externalStore().connProperties().hikariCP());
                this.bitmap$0 = true;
            }
            return this.connector;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String table() {
        return this.table;
    }

    public String provider() {
        return this.provider;
    }

    public SaveMode mode() {
        return this.mode;
    }

    public StructType userSchema() {
        return this.userSchema;
    }

    public Map<String, String> origOptions() {
        return this.origOptions;
    }

    public ExternalStore externalStore() {
        return this.externalStore;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public boolean needConversion() {
        return this.needConversion;
    }

    public String driver() {
        return this.driver;
    }

    public final JdbcDialect dialect() {
        return this.dialect;
    }

    public Map<String, StructField> schemaFields() {
        return this.schemaFields;
    }

    public final Function0<Connection> connector() {
        return this.bitmap$0 ? this.connector : this.connector$lzycompute();
    }

    private ReentrantReadWriteLock bufferLock() {
        return this.bufferLock;
    }

    public <A> A readLock(Function0<A> f) {
        ReentrantReadWriteLock.ReadLock lock = this.bufferLock().readLock();
        lock.lock();
        try {
            return (A)f.apply();
        }
        finally {
            lock.unlock();
        }
    }

    public <A> A writeLock(Function0<A> f) {
        ReentrantReadWriteLock.WriteLock lock = this.bufferLock().writeLock();
        lock.lock();
        try {
            return (A)f.apply();
        }
        finally {
            lock.unlock();
        }
    }

    public StructType schema() {
        return this.userSchema();
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        return this.scanTable(this.table(), requiredColumns, filters);
    }

    public RDD<Row> scanTable(String tableName, String[] requiredColumns, Filter[] filters) {
        String[] stringArray;
        if (Predef$.MODULE$.refArrayOps((Object[])requiredColumns).isEmpty()) {
            StructField narrowField = (StructField)Predef$.MODULE$.refArrayOps((Object[])this.schema().fields()).minBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(StructField a) {
                    return ColumnType$.MODULE$.apply(a.dataType()).defaultSize();
                }
            }, (Ordering)Ordering.Int$.MODULE$);
            stringArray = (String[])((Object[])new String[]{narrowField.name()});
        } else {
            stringArray = requiredColumns;
        }
        String[] requestedColumns = stringArray;
        RDD cachedColumnBuffers2 = (RDD)this.readLock((Function0)new Serializable(this, tableName, requestedColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCAppendableRelation $outer;
            private final String tableName$1;
            private final String[] requestedColumns$1;

            public final RDD<CachedBatch> apply() {
                return this.$outer.externalStore().getCachedBatchRDD(this.tableName$1, (String[])Predef$.MODULE$.refArrayOps((Object[])this.requestedColumns$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String column) {
                        return new StringBuilder().append((Object)"Col_").append((Object)column).toString();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), this.$outer.sqlContext().sparkContext());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.requestedColumns$1 = requestedColumns$1;
            }
        });
        snappy.RDDExtensions qual$1 = snappy$.MODULE$.RDDExtensions(cachedColumnBuffers2, ClassTag$.MODULE$.apply(CachedBatch.class));
        Serializable x$5 = new Serializable(this, requestedColumns){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCAppendableRelation $outer;
            private final String[] requestedColumns$1;

            public final Iterator<InternalRow> apply(Iterator<CachedBatch> cachedBatchIterator) {
                return ExternalStoreUtils$.MODULE$.cachedBatchesToRows(cachedBatchIterator, this.requestedColumns$1, this.$outer.schema());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.requestedColumns$1 = requestedColumns$1;
            }
        };
        boolean x$6 = qual$1.mapPartitionsPreserve$default$2();
        return qual$1.mapPartitionsPreserve(x$5, x$6, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public void insert(DataFrame df, boolean overwrite) {
        this.insert((RDD<Row>)df.rdd(), df, overwrite);
    }

    public ArrayBuffer<UUIDRegionKey> uuidBatchAggregate(ArrayBuffer<UUIDRegionKey> accumulated, CachedBatch batch) {
        UUIDRegionKey uuid = this.externalStore().storeCachedBatch(this.table(), batch, this.externalStore().storeCachedBatch$default$3(), this.externalStore().storeCachedBatch$default$4(), this.externalStore().storeCachedBatch$default$5());
        return accumulated.$plus$eq((Object)uuid);
    }

    public void insert(RDD<Row> rdd, DataFrame df, boolean overwrite) {
        Predef$.MODULE$.assert(df.schema().equals((Object)this.schema()));
        if (overwrite) {
            this.truncate();
        }
        boolean useCompression = this.sqlContext().conf().useCompression();
        int columnBatchSize = this.sqlContext().conf().columnBatchSize();
        Seq output = df.logicalPlan().output();
        RDD cached = snappy$.MODULE$.RDDExtensions(rdd, ClassTag$.MODULE$.apply(Row.class)).mapPartitionsPreserve(new Serializable(this, useCompression, columnBatchSize, output){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCAppendableRelation $outer;
            public final boolean useCompression$1;
            public final int columnBatchSize$1;
            private final Seq output$1;

            public final Iterator<Nothing$> apply(Iterator<Row> rowIterator) {
                CachedBatchHolder<ArrayBuffer> holder = new CachedBatchHolder<ArrayBuffer>((Function0<ColumnBuilder[]>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final ColumnBuilder[] apply() {
                        return this.$outer.org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$columnBuilders$1();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, 0, this.columnBatchSize$1, this.$outer.schema(), new ArrayBuffer(1), (Function2<ArrayBuffer, CachedBatch, ArrayBuffer>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final ArrayBuffer<UUIDRegionKey> apply(ArrayBuffer<UUIDRegionKey> accumulated, CachedBatch batch) {
                        return this.$outer.org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$$outer().uuidBatchAggregate(accumulated, batch);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Function1 converter = CatalystTypeConverters$.MODULE$.createToCatalystConverter((DataType)this.$outer.schema());
                rowIterator.map((Function1)new Serializable(this, converter){
                    public static final long serialVersionUID = 0L;
                    private final Function1 converter$1;

                    public final InternalRow apply(Row x$1) {
                        return (InternalRow)this.converter$1.apply((Object)x$1);
                    }
                    {
                        this.converter$1 = converter$1;
                    }
                }).foreach((Function1)new Serializable(this, holder){
                    public static final long serialVersionUID = 0L;
                    private final CachedBatchHolder holder$1;

                    public final void apply(InternalRow x$2) {
                        this.holder$1.appendRow(BoxedUnit.UNIT, x$2);
                    }
                    {
                        this.holder$1 = holder$1;
                    }
                });
                holder.forceEndOfBatch();
                return package$.MODULE$.Iterator().empty();
            }

            public /* synthetic */ JDBCAppendableRelation org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$$outer() {
                return this.$outer;
            }

            public final ColumnBuilder[] org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$columnBuilders$1() {
                return (ColumnBuilder[])((TraversableOnce)this.output$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final ColumnBuilder apply(Attribute attribute) {
                        ColumnType columnType = ColumnType$.MODULE$.apply(attribute.dataType());
                        int initialBufferSize = columnType.defaultSize() * this.$outer.columnBatchSize$1;
                        return ColumnBuilder$.MODULE$.apply(attribute.dataType(), initialBufferSize, attribute.name(), this.$outer.useCompression$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnBuilder.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.useCompression$1 = useCompression$1;
                this.columnBatchSize$1 = columnBatchSize$1;
                this.output$1 = output$1;
            }
        }, true, ClassTag$.MODULE$.Nothing());
        cached.count();
    }

    public boolean insert$default$2() {
        return true;
    }

    @Override
    public void truncate() {
        this.writeLock((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCAppendableRelation $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JdbcDialect dialect = JdbcDialects$.MODULE$.get(this.$outer.externalStore().connProperties().url());
                this.$outer.externalStore().tryExecute(this.$outer.table(), new Serializable(this, dialect){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$truncate$1 $outer;
                    private final JdbcDialect dialect$1;

                    public final <A1 extends Connection, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        JdbcExtendedUtils$.MODULE$.truncateTable(A1, this.$outer.org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$$outer().table(), this.dialect$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Connection x1) {
                        Connection connection = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dialect$1 = dialect$1;
                    }
                }, this.$outer.externalStore().tryExecute$default$3(), ClassTag$.MODULE$.Unit());
            }

            public /* synthetic */ JDBCAppendableRelation org$apache$spark$sql$columnar$JDBCAppendableRelation$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void createTable(SaveMode mode) {
        Connection conn = null;
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(this.externalStore().connProperties().url());
        conn = ExternalStoreUtils$.MODULE$.getConnection(this.externalStore().connProperties().url(), this.externalStore().connProperties().connProps(), dialect, Utils$.MODULE$.isLoner(this.sqlContext().sparkContext()));
        boolean tableExists2 = JdbcExtendedUtils$.MODULE$.tableExists(this.table(), conn, dialect, this.sqlContext());
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Ignore;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && tableExists2) {
            JdbcDialect jdbcDialect = dialect;
            if (jdbcDialect instanceof JdbcExtendedDialect) {
                JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
                jdbcExtendedDialect.initializeTable(this.table(), this.sqlContext().conf().caseSensitiveAnalysis(), conn);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.ErrorIfExists;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && tableExists2) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table()})));
        }
        this.createExternalTableForCachedBatches(this.table(), this.externalStore());
    }

    public void createExternalTableForCachedBatches(String tableName, ExternalStore externalStore) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(tableName != null && tableName.length() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "createExternalTableForCachedBatches: expected non-empty table name";
            }
        });
        JdbcDialect jdbcDialect = this.dialect();
        if (jdbcDialect instanceof JdbcExtendedDialect) {
            JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
            tuple2 = new Tuple2((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"constraint ", "_bucketCheck check (bucketId != -1), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)"primary key (uuid, bucketId)").toString(), (Object)jdbcExtendedDialect.getPartitionByClause("bucketId"));
        } else {
            tuple2 = new Tuple2((Object)"primary key (uuid)", (Object)"");
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2 tuple23;
            String primarykey = (String)tuple22._1();
            String partitionStrategy = (String)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)primarykey, (Object)partitionStrategy);
            String primarykey2 = (String)tuple24._1();
            String partitionStrategy2 = (String)tuple24._2();
            this.createTable(externalStore, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create table ", " (uuid varchar(36) "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).append((Object)"not null, bucketId integer not null, numRows integer not null, ").append((Object)"stats blob, ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.userSchema().fields()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField structField) {
                    return new StringBuilder().append((Object)"Col_").append((Object)structField.name()).append((Object)" blob").toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" ", ",", " ")).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", ", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{primarykey2, partitionStrategy2}))).toString(), tableName, false);
            return;
        }
        throw new MatchError((Object)tuple22);
    }

    public void createTable(ExternalStore externalStore, String tableStr, String tableName, boolean dropIfExists) {
        externalStore.tryExecute(tableName, new Serializable(this, tableStr, tableName, dropIfExists){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCAppendableRelation $outer;
            private final String tableStr$1;
            private final String tableName$2;
            private final boolean dropIfExists$1;

            public final <A1 extends Connection, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                boolean tableExists2;
                A1 A1 = x2;
                if (this.dropIfExists$1) {
                    JdbcExtendedUtils$.MODULE$.dropTable(A1, this.tableName$2, this.$outer.dialect(), this.$outer.sqlContext(), true);
                }
                if (tableExists2 = JdbcExtendedUtils$.MODULE$.tableExists(this.tableName$2, A1, this.$outer.dialect(), this.$outer.sqlContext())) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    JdbcExtendedUtils$.MODULE$.executeUpdate(this.tableStr$1, A1);
                    JdbcDialect jdbcDialect = this.$outer.dialect();
                    if (jdbcDialect instanceof JdbcExtendedDialect) {
                        JdbcExtendedDialect jdbcExtendedDialect = (JdbcExtendedDialect)jdbcDialect;
                        jdbcExtendedDialect.initializeTable(this.tableName$2, this.$outer.sqlContext().conf().caseSensitiveAnalysis(), A1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit4 = boxedUnit;
                return (B1)boxedUnit4;
            }

            public final boolean isDefinedAt(Connection x2) {
                Connection connection = x2;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tableStr$1 = tableStr$1;
                this.tableName$2 = tableName$2;
                this.dropIfExists$1 = dropIfExists$1;
            }
        }, externalStore.tryExecute$default$3(), ClassTag$.MODULE$.Unit());
    }

    @Override
    public void destroy(boolean ifExists) {
        Connection conn = ExternalStoreUtils$.MODULE$.getConnection(this.externalStore().connProperties().url(), this.externalStore().connProperties().connProps(), this.dialect(), Utils$.MODULE$.isLoner(this.sqlContext().sparkContext()));
        try {
            Utils$.MODULE$.mapExecutors(this.sqlContext(), JDBCAppendableRelation$.MODULE$.org$apache$spark$sql$columnar$JDBCAppendableRelation$$removePool(this.table()), ClassTag$.MODULE$.Unit()).count();
            JDBCAppendableRelation$.MODULE$.org$apache$spark$sql$columnar$JDBCAppendableRelation$$removePool(this.table());
        }
        catch (Throwable throwable) {
            try {
                JdbcExtendedUtils$.MODULE$.dropTable(conn, this.table(), this.dialect(), this.sqlContext(), ifExists);
                throw throwable;
            }
            finally {
                conn.close();
            }
        }
        try {
            JdbcExtendedUtils$.MODULE$.dropTable(conn, this.table(), this.dialect(), this.sqlContext(), ifExists);
            return;
        }
        finally {
            conn.close();
        }
    }

    public void flushRowBuffer() {
    }

    public JDBCAppendableRelation copy(String table, String provider, SaveMode mode, StructType userSchema, Map<String, String> origOptions, ExternalStore externalStore, SQLContext sqlContext) {
        return new JDBCAppendableRelation(table, provider, mode, userSchema, origOptions, externalStore, sqlContext);
    }

    public String copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.provider();
    }

    public SaveMode copy$default$3() {
        return this.mode();
    }

    public StructType copy$default$4() {
        return this.userSchema();
    }

    public Map<String, String> copy$default$5() {
        return this.origOptions();
    }

    public ExternalStore copy$default$6() {
        return this.externalStore();
    }

    public SQLContext copy$default$7() {
        return this.sqlContext();
    }

    public String productPrefix() {
        return "JDBCAppendableRelation";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 6: {
                object = this.sqlContext();
                break;
            }
            case 5: {
                object = this.externalStore();
                break;
            }
            case 4: {
                object = this.origOptions();
                break;
            }
            case 3: {
                object = this.userSchema();
                break;
            }
            case 2: {
                object = this.mode();
                break;
            }
            case 1: {
                object = this.provider();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JDBCAppendableRelation;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JDBCAppendableRelation)) return false;
        boolean bl = true;
        if (!bl) return false;
        JDBCAppendableRelation jDBCAppendableRelation = (JDBCAppendableRelation)x$1;
        String string = this.table();
        String string2 = jDBCAppendableRelation.table();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.provider();
        String string4 = jDBCAppendableRelation.provider();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = jDBCAppendableRelation.mode();
        if (saveMode == null) {
            if (saveMode2 != null) {
                return false;
            }
        } else if (!saveMode.equals(saveMode2)) return false;
        StructType structType = this.userSchema();
        StructType structType2 = jDBCAppendableRelation.userSchema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.origOptions();
        Map<String, String> map2 = jDBCAppendableRelation.origOptions();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        ExternalStore externalStore = this.externalStore();
        ExternalStore externalStore2 = jDBCAppendableRelation.externalStore();
        if (externalStore == null) {
            if (externalStore2 != null) {
                return false;
            }
        } else if (!externalStore.equals(externalStore2)) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = jDBCAppendableRelation.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        if (!jDBCAppendableRelation.canEqual(this)) return false;
        return true;
    }

    public JDBCAppendableRelation(String table, String provider, SaveMode mode, StructType userSchema, Map<String, String> origOptions, ExternalStore externalStore, SQLContext sqlContext) {
        this.table = table;
        this.provider = provider;
        this.mode = mode;
        this.userSchema = userSchema;
        this.origOptions = origOptions;
        this.externalStore = externalStore;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.needConversion = false;
        this.driver = DriverRegistry$.MODULE$.getDriverClassName(externalStore.connProperties().url());
        this.dialect = JdbcDialects$.MODULE$.get(externalStore.connProperties().url());
        this.schemaFields = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])userSchema.fields()).flatMap((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        this.bufferLock = new ReentrantReadWriteLock();
    }
}

