/*
 * Decompiled with CFR 0.152.
 */
package udtexamples;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Random;

public class UDTPrice
implements Serializable,
Comparable<UDTPrice> {
    public BigDecimal highPrice;
    public BigDecimal lowPrice;

    public static UDTPrice setPrice(BigDecimal low, BigDecimal high) {
        return new UDTPrice(low, high);
    }

    public static UDTPrice setPrice(UDTPrice price, BigDecimal currAmount) {
        if (currAmount.compareTo(price.highPrice) > 0) {
            return new UDTPrice(UDTPrice.getLowPrice(price), currAmount);
        }
        if (currAmount.compareTo(price.lowPrice) < 0) {
            return new UDTPrice(currAmount, UDTPrice.getHighPrice(price));
        }
        return price;
    }

    public static BigDecimal getLowPrice(UDTPrice price) {
        return price.lowPrice;
    }

    public static BigDecimal getHighPrice(UDTPrice price) {
        return price.highPrice;
    }

    public UDTPrice() {
    }

    public UDTPrice(BigDecimal low, BigDecimal high) {
        this.highPrice = high;
        this.lowPrice = low;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.highPrice.hashCode();
        result = 37 * result + this.lowPrice.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        return ((UDTPrice)obj).highPrice.compareTo(this.highPrice) == 0 && ((UDTPrice)obj).lowPrice.compareTo(this.lowPrice) == 0;
    }

    @Override
    public int compareTo(UDTPrice o) {
        if (o != null) {
            int cmp = this.highPrice.compareTo(o.highPrice);
            if (cmp != 0) {
                return cmp;
            }
            return this.lowPrice.compareTo(o.lowPrice);
        }
        return 1;
    }

    public String toString() {
        return "highPrice is " + this.highPrice + " low price is " + this.lowPrice;
    }

    public static UDTPrice toUDTPrice(String s) {
        String[] ele = s.split(" ");
        UDTPrice udt = new UDTPrice(BigDecimal.valueOf(Double.parseDouble(ele[2])), BigDecimal.valueOf(Double.parseDouble(ele[6])));
        return udt;
    }

    public static UDTPrice getRandomUDTPrice() {
        BigDecimal low = new BigDecimal(Double.toString((double)(new Random().nextInt(3000) + 1) * 0.01)).add(new BigDecimal("20"));
        BigDecimal high = new BigDecimal("10").add(low);
        return new UDTPrice(low, high);
    }
}

