/*
 * Decompiled with CFR 0.152.
 */
package toursdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class insertMaps {
    public static final String CSdriver = new String("com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
    public static final String dbURLCS = new String("jdbc:gemfirexd:;mcast-port=0");

    public static void main(String[] args) throws Exception {
        try {
            Connection connCS = null;
            System.out.println("Loading the Derby jdbc driver...");
            Class.forName(CSdriver).newInstance();
            System.out.println("Getting Derby database connection...");
            connCS = DriverManager.getConnection(dbURLCS);
            System.out.println("Successfully got the Derby database connection...");
            System.out.println("Inserted " + insertMaps.insertRows(null, connCS) + " rows into the ToursDB");
            connCS.close();
        }
        catch (SQLException e) {
            System.out.println("FAIL -- unexpected exception: " + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("FAIL -- unexpected exception: " + e.toString());
            e.printStackTrace();
        }
    }

    public static int insertRows(String path, Connection conn) throws SQLException, FileNotFoundException, IOException {
        PreparedStatement ps = null;
        ps = conn.prepareStatement("insert into maps (map_name, region, area, photo_format, picture) values (?,?,?,?,?)");
        ps.setString(1, "North Ocean");
        ps.setString(2, "Cup Island");
        ps.setBigDecimal(3, new BigDecimal("1776.11"));
        ps.setString(4, "gif");
        String fileName = path == null ? "cupisle.gif" : path + File.separator + "cupisle.gif";
        File file = new File(fileName);
        FileInputStream fileIn = new FileInputStream(file);
        ps.setBinaryStream(5, (InputStream)fileIn, (int)file.length());
        int numrows = ps.executeUpdate();
        ((InputStream)fileIn).close();
        ps.setString(1, "Middle Ocean");
        ps.setString(2, "Small Island");
        ps.setBigDecimal(3, new BigDecimal("1166.77"));
        ps.setString(4, "gif");
        fileName = path == null ? "smallisle.gif" : path + File.separator + "smallisle.gif";
        file = new File(fileName);
        fileIn = new FileInputStream(file);
        ps.setBinaryStream(5, (InputStream)fileIn, (int)file.length());
        numrows += ps.executeUpdate();
        ((InputStream)fileIn).close();
        ps.setString(1, "South Ocean");
        ps.setString(2, "Witch Island");
        ps.setBigDecimal(3, new BigDecimal("9117.90"));
        ps.setString(4, "gif");
        fileName = path == null ? "witchisle.gif" : path + File.separator + "witchisle.gif";
        file = new File(fileName);
        fileIn = new FileInputStream(file);
        ps.setBinaryStream(5, (InputStream)fileIn, (int)file.length());
        ((InputStream)fileIn).close();
        ps.close();
        return numrows += ps.executeUpdate();
    }
}

