/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.util;

public class BitUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] set(byte[] bytes, int position) {
        int bytepos;
        if (position >= 0 && (bytepos = position >> 3) < bytes.length) {
            int bitpos = 7 - position % 8;
            int n = bytepos;
            bytes[n] = (byte)(bytes[n] | 1 << bitpos);
            return bytes;
        }
        throw new IndexOutOfBoundsException(Integer.toString(position));
    }

    public static byte[] clear(byte[] bytes, int position) {
        int bytepos;
        if (position >= 0 && (bytepos = position >> 3) < bytes.length) {
            int bitpos = 7 - position % 8;
            int n = bytepos;
            bytes[n] = (byte)(bytes[n] & ~(1 << bitpos));
            return bytes;
        }
        throw new IndexOutOfBoundsException(Integer.toString(position));
    }

    public static boolean get(byte[] bytes, int position) {
        int bytepos;
        if (position >= 0 && (bytepos = position >> 3) < bytes.length) {
            int bitpos = 7 - position % 8;
            return (bytes[bytepos] & 1 << bitpos) != 0;
        }
        throw new IndexOutOfBoundsException(Integer.toString(position));
    }

    public static String hexDump(byte[] data) {
        StringBuilder str = new StringBuilder(data.length * 3);
        str.append("Hex dump:\n");
        for (int i = 0; i < data.length; i += 16) {
            int j;
            String offset = Integer.toHexString(i);
            for (int offlen = offset.length(); offlen < 8; ++offlen) {
                str.append("0");
            }
            str.append(offset);
            str.append(":");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                byte byte_value = data[i + j];
                if (j % 2 == 0) {
                    str.append(" ");
                }
                byte high_nibble = (byte)((byte_value & 0xF0) >>> 4);
                byte low_nibble = (byte)(byte_value & 0xF);
                str.append(hex_table[high_nibble]);
                str.append(hex_table[low_nibble]);
            }
            str.append("  ");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                char char_value = (char)data[i + j];
                if (Character.isLetterOrDigit(char_value)) {
                    str.append(String.valueOf(char_value));
                    continue;
                }
                str.append(".");
            }
            str.append("\n");
        }
        return str.toString();
    }
}

