/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.GlobalTransactionId;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;

public class T_TWC {
    protected Transaction tran;
    protected ContextManager cm;
    protected ContextService contextService;
    protected LockFactory lf;
    protected RawStoreFactory rawStore;

    public T_TWC(ContextService contextService, LockFactory lockFactory, RawStoreFactory rawStoreFactory) {
        this.contextService = contextService;
        this.lf = lockFactory;
        this.rawStore = rawStoreFactory;
        this.tran = null;
        this.cm = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T_TWC startUserTransaction() throws StandardException {
        this.cm = this.contextService.newContextManager();
        this.contextService.setCurrentContextManager(this.cm);
        try {
            this.tran = this.rawStore.startTransaction(this.cm, "UserTransaction");
            SanityManager.ASSERT((this.tran != null ? 1 : 0) != 0);
            this.checkNullLockCount();
        }
        finally {
            this.contextService.resetCurrentContextManager(this.cm);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNullLockCount() {
        this.switchTransactionContext();
        try {
            SanityManager.ASSERT((!this.lf.areLocksHeld(this.tran.getCompatibilitySpace()) ? 1 : 0) != 0, (String)"Transaction holds locks.");
        }
        finally {
            this.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSavePoint(String sp, Object kindOfSavepoint) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.setSavePoint(sp, null);
        }
        finally {
            this.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackToSavePoint(String sp, Object kindOfSavepoint) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.rollbackToSavePoint(sp, null);
        }
        finally {
            this.resetContext();
        }
    }

    public void switchTransactionContext() {
        this.contextService.setCurrentContextManager(this.cm);
    }

    public void resetContext() {
        this.contextService.resetCurrentContextManager(this.cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAndDo(Loggable l) throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.logAndDo(l);
        }
        finally {
            this.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.commit();
        }
        finally {
            this.resetContext();
        }
        this.checkNullLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws StandardException {
        this.switchTransactionContext();
        try {
            this.tran.abort();
        }
        finally {
            this.resetContext();
        }
        this.checkNullLockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalTransactionId getId() throws StandardException {
        this.switchTransactionContext();
        try {
            GlobalTransactionId globalTransactionId = this.tran.getGlobalId();
            return globalTransactionId;
        }
        finally {
            this.resetContext();
        }
    }
}

