/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;

public class T_RowSource
implements RowSource {
    public static final int INTEGER_ROW_TYPE = 1;
    public static final int STRING_ROW_TYPE = 2;
    protected static final String REC_001 = "McLaren";
    protected static final String REC_002 = "Ferrari";
    protected static final String REC_003 = "Benetton";
    protected static final String REC_004 = "Prost";
    protected static final String REC_005 = "Tyrell";
    protected static final String REC_006 = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
    protected static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    protected static final String REC_008 = "z";
    protected static final int DEFAULT_ROW_COUNT = 500000;
    protected static final int DEFAULT_COLUMN_COUNT = 13;
    protected static final int DEFAULT_SEED = 53;
    private int rowCount;
    private int columnCount;
    private DataValueDescriptor[] row;
    private FormatableBitSet validColumns;
    private boolean forceAbort;
    private Transaction t;

    public T_RowSource() {
        this.rowCount = 500000;
        this.columnCount = 13;
        this.row = new DataValueDescriptor[13];
        this.row = this.setStringRow();
    }

    public T_RowSource(int count, int columnCount, int rowType, boolean forceAbort, Transaction t) {
        this.rowCount = count;
        this.columnCount = columnCount;
        this.validColumns = new FormatableBitSet(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.validColumns.set(i);
        }
        this.row = new DataValueDescriptor[columnCount];
        if (rowType == 1) {
            this.setIntegerRow();
        } else {
            this.row = this.setStringRow();
        }
        this.forceAbort = forceAbort;
        this.t = t;
    }

    public T_RowSource(int count, int columnCount, int rowType, FormatableBitSet validColumns) {
        this.rowCount = count;
        this.columnCount = columnCount;
        this.validColumns = validColumns;
        this.row = new DataValueDescriptor[columnCount];
        if (rowType == 1) {
            this.setIntegerRow();
        } else {
            this.row = this.setStringRow();
        }
    }

    public boolean hasMoreRows() throws StandardException {
        return this.rowCount > 0;
    }

    public ExecRow getNextRowFromRowSource() throws StandardException {
        if (this.rowCount <= 0) {
            return null;
        }
        if (this.forceAbort && this.rowCount < 3) {
            this.t.abort();
        }
        --this.rowCount;
        ValueRow v = new ValueRow(this.row.length);
        v.setRowArray(this.row);
        return v;
    }

    public FormatableBitSet getValidColumns() {
        return this.validColumns;
    }

    public void closeRowSource() {
        this.rowCount = 0;
    }

    public boolean needsRowLocation() {
        return false;
    }

    public boolean needsToClone() {
        return true;
    }

    public void rowLocation(RowLocation rl) {
        rl = null;
    }

    public DataValueDescriptor[] getTemplate() throws StandardException {
        return this.row;
    }

    private void setIntegerRow() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.row[i] = new SQLInteger(i + 53);
        }
    }

    private DataValueDescriptor[] setStringRow() {
        T_RawStoreRow row = new T_RawStoreRow(this.columnCount);
        block15: for (int i = 0; i < this.columnCount; ++i) {
            switch (i % 13) {
                case 0: {
                    row.setColumn(i, (String)null);
                    continue block15;
                }
                case 1: {
                    row.setColumn(i, REC_001);
                    continue block15;
                }
                case 2: {
                    row.setColumn(i, REC_002);
                    continue block15;
                }
                case 3: {
                    row.setColumn(i, REC_003);
                    continue block15;
                }
                case 4: {
                    row.setColumn(i, REC_004);
                    continue block15;
                }
                case 5: {
                    row.setColumn(i, REC_005);
                    continue block15;
                }
                case 6: {
                    row.setColumn(i, REC_006);
                    continue block15;
                }
                case 7: {
                    row.setColumn(i, REC_007);
                    continue block15;
                }
                case 8: {
                    row.setColumn(i, (String)null);
                    continue block15;
                }
                case 9: {
                    row.setColumn(i, REC_008);
                    continue block15;
                }
                case 10: {
                    row.setColumn(i, REC_007);
                    continue block15;
                }
                case 11: {
                    row.setColumn(i, (String)null);
                    continue block15;
                }
                case 12: {
                    row.setColumn(i, REC_006);
                    continue block15;
                }
                default: {
                    row.setColumn(i, REC_008);
                }
            }
        }
        return row.getRow();
    }
}

