/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;

public class T_AccessRow {
    protected DataValueDescriptor[] column;

    public T_AccessRow(int ncols) {
        this.column = new DataValueDescriptor[ncols];
        for (int i = 0; i < ncols; ++i) {
            this.column[i] = new SQLInteger(0);
        }
    }

    public T_AccessRow(int col0value, int col1value, int col2value) {
        this.column = new DataValueDescriptor[3];
        this.column[0] = new SQLInteger(col0value);
        this.column[1] = new SQLInteger(col1value);
        this.column[2] = new SQLInteger(col2value);
    }

    public DataValueDescriptor getCol(int colid) {
        if (colid >= this.column.length) {
            return null;
        }
        return this.column[colid];
    }

    public void setCol(int colid, DataValueDescriptor val) {
        if (colid >= this.column.length) {
            this.realloc(colid + 1);
        }
        this.column[colid] = val;
    }

    public boolean equals(T_AccessRow other) throws StandardException {
        if (other == null) {
            return false;
        }
        if (other.column.length != this.column.length) {
            return false;
        }
        for (int i = 0; i < this.column.length; ++i) {
            if (this.column[i].compare(other.column[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String s = "{ ";
        for (int i = 0; i < this.column.length; ++i) {
            s = s + this.column[i].toString();
            if (i >= this.column.length - 1) continue;
            s = s + ", ";
        }
        s = s + " }";
        return s;
    }

    protected void realloc(int ncols) {
        DataValueDescriptor[] newcol = new DataValueDescriptor[ncols];
        for (int i = 0; i < this.column.length; ++i) {
            newcol[i] = this.column[i];
        }
        this.column = newcol;
    }

    public Storable getStorableColumn(int colid) {
        return this.column[colid];
    }

    public void setStorableColumn(int colid, Storable value) {
        this.column[colid] = (DataValueDescriptor)value;
    }

    public int nColumns() {
        return this.column.length;
    }

    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    public DataValueDescriptor[] getRowArrayClone() {
        DataValueDescriptor[] retval = new DataValueDescriptor[this.column.length];
        for (int index = 0; index < this.column.length; ++index) {
            retval[index] = this.column[index].getClone();
        }
        return retval;
    }
}

