/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonFactory;
import com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.services.T_CacheException;
import org.apache.derbyTesting.unitTests.services.T_CacheUser;
import org.apache.derbyTesting.unitTests.services.T_CachedInteger;
import org.apache.derbyTesting.unitTests.services.T_Key;

public class T_CacheService
extends T_Generic
implements CacheableFactory {
    protected CacheFactory cf;
    protected T_Fail threadFail;

    public Cacheable newCacheable(CacheManager cm) {
        return new T_CachedInteger();
    }

    @Override
    protected void runTests() throws T_Fail {
        DaemonFactory df;
        try {
            this.cf = (CacheFactory)Monitor.startSystemModule((String)this.getModuleToTestProtocolName());
            df = (DaemonFactory)Monitor.startSystemModule((String)"com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonFactory");
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (this.cf == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " module not started.");
        }
        if (df == null) {
            throw T_Fail.testFailMsg("com.pivotal.gemfirexd.internal.iapi.services.daemon.DaemonFactory module not started.");
        }
        try {
            DaemonService ds = df.createNewDaemon("CacheTester");
            if (ds == null) {
                throw T_Fail.testFailMsg("Can't create deamon service");
            }
            CacheManager cm1 = this.cf.newCacheManager((CacheableFactory)this, "testCache1", 20, 40);
            if (cm1 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cm1, 40);
            cm1.useDaemonService(ds);
            this.thrashCache(cm1, 10, 1000);
            cm1.shutdown();
            cm1 = null;
            CacheManager cm2 = this.cf.newCacheManager((CacheableFactory)this, "testCache2", 0, 1);
            if (cm2 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cm2, 1);
            cm2.useDaemonService(ds);
            this.thrashCache(cm2, 10, 1000);
            cm2.shutdown();
            cm2 = null;
            CacheManager cm3 = this.cf.newCacheManager((CacheableFactory)this, "testCache3", 2000, 40);
            if (cm3 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cm3, 40);
            cm3.useDaemonService(ds);
            this.thrashCache(cm3, 10, 1000);
            cm3.shutdown();
            cm3 = null;
            CacheManager cm4 = this.cf.newCacheManager((CacheableFactory)this, "testCache4", 2000, 40);
            if (cm4 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cm4, 40);
            this.thrashCache(cm4, 10, 1000);
            cm4.shutdown();
            cm4 = null;
            CacheManager cm5 = this.cf.newCacheManager((CacheableFactory)this, "testCache5", 0, 40);
            if (cm5 == null) {
                throw T_Fail.testFailMsg("unable to create cache manager");
            }
            this.T001(cm5, 40);
            this.thrashCache(cm5, 10, 1000);
            cm5.shutdown();
            cm5 = null;
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw T_Fail.exceptionFail(t);
        }
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "com.pivotal.gemfirexd.internal.iapi.services.cache.CacheFactory";
    }

    protected void T001(CacheManager cm, int cacheSize) throws T_Fail, StandardException {
        T_Key tkey1 = T_Key.simpleInt(1);
        this.t_findCachedFail(cm, tkey1);
        cm.release(this.t_findSucceed(cm, tkey1));
        cm.release(this.t_findCachedSucceed(cm, tkey1));
        T_Key tkey2 = T_Key.dontFindInt(2);
        this.t_findCachedFail(cm, tkey2);
        this.t_findFail(cm, tkey2);
        cm.release(this.t_findSucceed(cm, tkey1));
        tkey2 = T_Key.simpleInt(2);
        cm.release(this.t_findSucceed(cm, tkey2));
        cm.release(this.t_findSucceed(cm, tkey1));
        T_Key tkey3 = T_Key.exceptionInt(3);
        this.t_findCachedFail(cm, tkey3);
        try {
            this.t_findFail(cm, tkey3);
            throw T_Fail.testFailMsg("find call lost user exception");
        }
        catch (StandardException se) {
            Cacheable e2;
            T_Key tkeyi;
            int i;
            if (!(se instanceof T_CacheException)) {
                throw se;
            }
            if (((T_CacheException)se).getType() != 2) {
                throw se;
            }
            tkey3 = T_Key.simpleInt(3);
            cm.release(this.t_findSucceed(cm, tkey3));
            cm.release(this.t_findSucceed(cm, tkey2));
            cm.release(this.t_findSucceed(cm, tkey1));
            cm.cleanAll();
            cm.ageOut();
            this.t_findCachedFail(cm, tkey1);
            this.t_findCachedFail(cm, tkey2);
            this.t_findCachedFail(cm, tkey3);
            for (i = 0; i < 4 * cacheSize; ++i) {
                tkeyi = T_Key.simpleInt(i);
                cm.release(this.t_findSucceed(cm, tkeyi));
                cm.release(this.t_findCachedSucceed(cm, tkeyi));
            }
            cm.cleanAll();
            cm.ageOut();
            for (i = 0; i < 4 * cacheSize; ++i) {
                tkeyi = T_Key.simpleInt(i);
                this.t_findCachedFail(cm, tkeyi);
            }
            Cacheable e1 = this.t_findSucceed(cm, tkey1);
            if (e1 == (e2 = this.t_findSucceed(cm, tkey2))) {
                throw T_Fail.testFailMsg("same object returned for two different keys");
            }
            if (this.t_findSucceed(cm, tkey1) != e1) {
                throw T_Fail.testFailMsg("different object returned for same key");
            }
            if (this.t_findSucceed(cm, tkey2) != e2) {
                throw T_Fail.testFailMsg("different object returned for same key");
            }
            cm.release(e1);
            cm.release(e1);
            e1 = null;
            cm.release(e2);
            cm.release(e2);
            e2 = null;
            this.PASS("T001");
            return;
        }
    }

    protected void thrashCache(CacheManager cm, int threads, int iterations) throws T_Fail {
        int i;
        Thread[] children = new Thread[threads];
        for (i = 0; i < threads; ++i) {
            children[i] = new Thread(new T_CacheUser(cm, iterations, this, this.out));
        }
        for (i = 0; i < threads; ++i) {
            children[i].start();
        }
        try {
            for (i = 0; i < threads; ++i) {
                if (this.threadFail != null) {
                    throw this.threadFail;
                }
                children[i].join();
                if (this.threadFail == null) continue;
                throw this.threadFail;
            }
        }
        catch (InterruptedException ie) {
            throw T_Fail.exceptionFail(ie);
        }
        this.PASS("thrashCache");
    }

    public synchronized void setChildException(T_Fail tf) {
        if (this.threadFail == null) {
            this.threadFail = tf;
        }
    }

    protected void t_findCachedFail(CacheManager cm, Object key) throws StandardException, T_Fail {
        Cacheable entry = cm.findCached(key);
        if (entry != null) {
            throw T_Fail.testFailMsg("found cached item unexpectedly");
        }
    }

    protected Cacheable t_findCachedSucceed(CacheManager cm, Object key) throws StandardException, T_Fail {
        Cacheable entry = cm.findCached(key);
        if (entry == null) {
            throw T_Fail.testFailMsg("expected item to be in cache");
        }
        if (!entry.getIdentity().equals(key)) {
            throw T_Fail.testFailMsg("item returned does not match key");
        }
        return entry;
    }

    protected void t_findFail(CacheManager cm, Object key) throws T_Fail, StandardException {
        Cacheable entry = cm.find(key);
        if (entry != null) {
            throw T_Fail.testFailMsg("found item unexpectedly");
        }
    }

    protected Cacheable t_findSucceed(CacheManager cm, Object key) throws T_Fail, StandardException {
        Cacheable entry = cm.find(key);
        if (entry == null) {
            throw T_Fail.testFailMsg("expected item to be found");
        }
        if (!entry.getIdentity().equals(key)) {
            throw T_Fail.testFailMsg("item returned does not match key");
        }
        return entry;
    }
}

