/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import com.pivotal.gemfirexd.internal.iapi.services.io.LimitInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkedLimitInputStream
extends LimitInputStream {
    protected boolean isLastBlock;
    protected int blockLength;

    public MarkedLimitInputStream(DataInputStream in) throws IOException {
        super((InputStream)in);
        this.start();
    }

    private void start() throws IOException {
        this.isLastBlock = ((DataInputStream)this.in).readBoolean();
        this.blockLength = ((DataInputStream)this.in).readInt();
        if (!this.isLastBlock) {
            SanityManager.ASSERT((this.blockLength > 0 ? 1 : 0) != 0);
        } else {
            SanityManager.ASSERT((this.blockLength >= 0 ? 1 : 0) != 0, (String)("blockLength " + this.blockLength + " is negative"));
        }
        this.setLimit(this.blockLength);
    }

    public int read() throws IOException {
        int i = super.read();
        if (i == -1) {
            if (this.isLastBlock) {
                return -1;
            }
            this.start();
            return this.read();
        }
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        int count;
        if (this.isLastBlock) {
            int m;
            int count2;
            for (m = 0; m < len && (count2 = super.read(b, off + m, len - m)) >= 0; m += count2) {
            }
            return m;
        }
        for (n = 0; n < len && (count = super.read(b, off + n, len - n)) >= 0; n += count) {
        }
        SanityManager.ASSERT((n <= len ? 1 : 0) != 0);
        if (n == len) {
            return n;
        }
        this.start();
        if (n < 0) {
            return this.read(b, off, len);
        }
        return n + this.read(b, off + n, len - n);
    }

    public long skip(long count) throws IOException {
        long n;
        long c;
        if (this.isLastBlock) {
            return super.skip(count);
        }
        for (n = 0L; n < count && (c = super.skip(count - n)) > 0L; n += c) {
        }
        SanityManager.ASSERT((n <= count ? 1 : 0) != 0);
        if (n == count) {
            return n;
        }
        this.start();
        if (n < 0L) {
            return this.skip(count);
        }
        return n + this.skip(count - n);
    }
}

