/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import com.pivotal.gemfirexd.internal.authentication.SystemPrincipal;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.security.SystemPermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashSet;
import javax.security.auth.Subject;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class SystemPrivilegesPermissionTest
extends BaseTestCase {
    private static String POLICY_FILE_NAME;
    private static final String[] dirPaths;
    private static final String[] relDirPaths;
    private static final String[] relDirPathAliases;
    private static final String[] absDirPaths;
    private static final String[] absDirPathAliases;
    private static final boolean[][] dirPathImpls;

    public SystemPrivilegesPermissionTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SystemPrivilegesPermissionTest.class, "SystemPrivilegesPermissionTest");
        if (SecurityManagerSetup.JVM_HAS_SUBJECT_AUTHORIZATION) {
            suite.addTest((Test)new SecurityManagerSetup((Test)new SystemPrivilegesPermissionTest("policyTestSystemGrants"), POLICY_FILE_NAME));
        }
        return suite;
    }

    public void testSystemPrincipal() {
        try {
            new SystemPrincipal(null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPrincipal("");
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSystemPermission() {
        int a;
        try {
            new SystemPermission(null, null);
            SystemPrivilegesPermissionTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new SystemPermission("", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new SystemPermission("illegal_name", null);
            SystemPrivilegesPermissionTest.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String[] validNames = new String[]{"engine", "jmx", "server"};
        String[] validActions = new String[]{"control", "monitor", "shutdown"};
        Permission[] all = new Permission[validNames.length * validActions.length];
        int c = 0;
        for (int tn = 0; tn < validNames.length; ++tn) {
            for (a = 0; a < validActions.length; ++a) {
                SystemPermission p = new SystemPermission(validNames[tn], validActions[a]);
                SystemPrivilegesPermissionTest.assertEquals((String)validNames[tn], (String)p.getName());
                SystemPrivilegesPermissionTest.assertEquals((String)validActions[a], (String)p.getActions());
                SystemPrivilegesPermissionTest.assertFalse((boolean)p.equals(null));
                SystemPrivilegesPermissionTest.assertFalse((boolean)p.equals(new Object()));
                this.assertEquivalentPermissions((Permission)p, (Permission)p);
                all[c++] = p;
            }
        }
        this.checkDistinctPermissions(all);
        for (int n = 0; n < validNames.length; ++n) {
            for (a = 0; a < validActions.length; ++a) {
                SystemPermission base = new SystemPermission(validNames[n], validActions[a]);
                for (int oa = 0; oa < validActions.length; ++oa) {
                    int s;
                    int f;
                    SystemPermission p = new SystemPermission(validNames[n], validActions[a] + "," + validActions[oa]);
                    if (oa == a) {
                        this.assertEquivalentPermissions((Permission)base, (Permission)p);
                        SystemPrivilegesPermissionTest.assertEquals((String)validActions[a], (String)p.getActions());
                        continue;
                    }
                    SystemPrivilegesPermissionTest.assertTrue((boolean)p.implies((Permission)base));
                    SystemPrivilegesPermissionTest.assertFalse((boolean)base.implies((Permission)p));
                    if (oa < a) {
                        f = oa;
                        s = a;
                    } else {
                        f = a;
                        s = oa;
                    }
                    if (oa >= a) continue;
                    SystemPrivilegesPermissionTest.assertEquals((String)(validActions[f] + "," + validActions[s]), (String)p.getActions());
                }
            }
        }
    }

    public void policyTestSystemGrants() {
        SystemPermission shutdown2 = new SystemPermission("server", "shutdown");
        SystemPrincipal authorizedUser = new SystemPrincipal("authorizedSystemUser");
        this.execute(authorizedUser, new ShutdownAction((Permission)shutdown2), true);
        SystemPrincipal unAuthorizedUser = new SystemPrincipal("unAuthorizedSystemUser");
        this.execute(unAuthorizedUser, new ShutdownAction((Permission)shutdown2), false);
    }

    public void XXtestDatabasePermission() throws IOException {
    }

    private void execute(SystemPrincipal principal, PrivilegedAction action, boolean isGrantExpected) {
        block3: {
            RunAsPrivilegedUserAction runAsPrivilegedUserAction = new RunAsPrivilegedUserAction(principal, action);
            try {
                AccessController.doPrivileged(runAsPrivilegedUserAction);
                if (!isGrantExpected) {
                    SystemPrivilegesPermissionTest.fail((String)"expected AccessControlException");
                }
            }
            catch (AccessControlException ace) {
                if (!isGrantExpected) break block3;
                throw ace;
            }
        }
    }

    private void checkHashCodeAndEquals(Permission[] dbp0, Permission[] dbp1) throws IOException {
        for (int i = 0; i < dbp0.length; ++i) {
            Permission p0 = dbp0[i];
            for (int j = 0; j < dbp0.length; ++j) {
                Permission p1 = dbp1[j];
                if (i == j) {
                    SystemPrivilegesPermissionTest.assertTrue((p0.hashCode() == p1.hashCode() ? 1 : 0) != 0);
                    SystemPrivilegesPermissionTest.assertTrue((boolean)p0.equals(p1));
                    continue;
                }
                SystemPrivilegesPermissionTest.assertTrue((p0.hashCode() != p1.hashCode() ? 1 : 0) != 0);
                SystemPrivilegesPermissionTest.assertTrue((!p0.equals(p1) ? 1 : 0) != 0);
            }
        }
    }

    private void checkImplies(Permission[] dbp0, Permission[] dbp1, boolean[][] impls) throws IOException {
        for (int i = 0; i < dbp0.length; ++i) {
            Permission p0 = dbp0[i];
            for (int j = 0; j < dbp1.length; ++j) {
                Permission p1 = dbp1[j];
                SystemPrivilegesPermissionTest.assertEquals((String)("test: " + p0 + ".implies" + p1), (boolean)impls[i][j], (boolean)p0.implies(p1));
            }
        }
    }

    private void checkDistinctPermissions(Permission[] set) {
        for (int i = 0; i < set.length; ++i) {
            Permission pi = set[i];
            for (int j = 0; j < set.length; ++j) {
                Permission pj = set[j];
                if (i == j) {
                    this.assertEquivalentPermissions(pi, pj);
                    continue;
                }
                SystemPrivilegesPermissionTest.assertFalse((boolean)pi.equals(pj));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pj.equals(pi));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pi.implies(pj));
                SystemPrivilegesPermissionTest.assertFalse((boolean)pj.implies(pi));
            }
        }
    }

    private void assertEquivalentPermissions(Permission p1, Permission p2) {
        SystemPrivilegesPermissionTest.assertTrue((boolean)p1.equals(p2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)p2.equals(p1));
        SystemPrivilegesPermissionTest.assertEquals((int)p1.hashCode(), (int)p2.hashCode());
        SystemPrivilegesPermissionTest.assertTrue((boolean)p1.implies(p2));
        SystemPrivilegesPermissionTest.assertTrue((boolean)p1.implies(p2));
    }

    private static String getAuthorizationId(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId((String)name);
        }
        catch (StandardException se) {
            throw new IllegalArgumentException(se.getMessage());
        }
    }

    static {
        int i;
        POLICY_FILE_NAME = "org/apache/derbyTesting/unitTests/junit/SystemPrivilegesPermissionTest.policy";
        dirPaths = new String[]{"-", "*", "level0", "level0a", "level0/-", "level0/*", "level0/level1", "level0/level1/level2"};
        relDirPaths = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.relDirPaths[i] = "directory:" + dirPaths[i];
        }
        relDirPathAliases = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.relDirPathAliases[i] = "directory:./" + dirPaths[i];
        }
        absDirPaths = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.absDirPaths[i] = "directory:/" + dirPaths[i];
        }
        absDirPathAliases = new String[dirPaths.length];
        for (i = 0; i < relDirPaths.length; ++i) {
            SystemPrivilegesPermissionTest.absDirPathAliases[i] = "directory:/dummy/../" + dirPaths[i];
        }
        dirPathImpls = new boolean[][]{{true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, false}, {false, false, true, false, false, false, false, false}, {false, false, false, true, false, false, false, false}, {false, false, false, false, true, true, true, true}, {false, false, false, false, false, true, true, false}, {false, false, false, false, false, false, true, false}, {false, false, false, false, false, false, false, true}};
    }

    public static class RunAsPrivilegedUserAction
    implements PrivilegedAction {
        private final SystemPrincipal principal;
        private final PrivilegedAction action;

        public RunAsPrivilegedUserAction(SystemPrincipal principal, PrivilegedAction action) {
            this.principal = principal;
            this.action = action;
        }

        public Object run() {
            boolean readOnly = true;
            HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
            HashSet publicCredentials = new HashSet();
            HashSet privateCredentials = new HashSet();
            principals.add(this.principal);
            String normalized = SystemPrivilegesPermissionTest.getAuthorizationId(this.principal.getName());
            principals.add(new SystemPrincipal(normalized));
            Subject subject = new Subject(true, principals, publicCredentials, privateCredentials);
            Subject.doAsPrivileged(subject, this.action, null);
            return null;
        }
    }

    public class CreateDatabaseAction
    implements PrivilegedAction {
        protected final Permission permission;

        public CreateDatabaseAction(Permission permission) {
            this.permission = permission;
        }

        public Object run() {
            AccessController.checkPermission(this.permission);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }

    public class ShutdownAction
    implements PrivilegedAction {
        protected final Permission permission;

        public ShutdownAction(Permission permission) {
            this.permission = permission;
        }

        public Object run() {
            AccessController.checkPermission(this.permission);
            return null;
        }

        public String toString() {
            return this.permission.toString();
        }
    }
}

