/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKey;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKeyFactory;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementKeyFactoryTest
extends BaseTestCase {
    public StatementKeyFactoryTest(String name) {
        super(name);
    }

    public void testCreationBasicWithNulls() {
        try {
            StatementKeyFactory.newPrepared(null, null, (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StatementKeyFactory.newPrepared(null, (String)"app", (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StatementKeyFactory.newPrepared((String)"values 1", null, (int)0);
            StatementKeyFactoryTest.fail((String)"Creation with <null> should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreationBasic() {
        StatementKey stdKey = StatementKeyFactory.newPrepared((String)"values 1", (String)"APP", (int)1);
        StatementKey key = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKeyFactoryTest.assertFalse((boolean)key.equals((Object)stdKey));
        StatementKeyFactoryTest.assertFalse((boolean)stdKey.equals((Object)key));
    }

    public void testEqualityBasic() {
        StatementKey key1 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKey key2 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKey key3 = StatementKeyFactory.newPrepared((String)"select * from sys.systables", (String)"APP", (int)1);
        StatementKeyFactoryTest.assertTrue((boolean)key1.equals((Object)key2));
        StatementKeyFactoryTest.assertTrue((boolean)key2.equals((Object)key1));
        StatementKeyFactoryTest.assertTrue((boolean)key2.equals((Object)key3));
        StatementKeyFactoryTest.assertTrue((boolean)key1.equals((Object)key3));
    }

    public void testEqualityDefaultNoAutoGenKey() {
        int holdability = 1;
        StatementKey basicKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)holdability);
        StatementKey simplifiedKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)holdability, (int)2);
        StatementKeyFactoryTest.assertTrue((boolean)basicKey.equals((Object)simplifiedKey));
        StatementKeyFactoryTest.assertTrue((boolean)simplifiedKey.equals((Object)basicKey));
    }

    public void testEqualityNoAutoVsAutoGenKey() {
        int holdability = 1;
        StatementKey basicKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)holdability);
        StatementKey autoKey = StatementKeyFactory.newPrepared((String)"values 2", (String)"APP", (int)holdability, (int)1);
        StatementKeyFactoryTest.assertFalse((boolean)basicKey.equals((Object)autoKey));
        StatementKeyFactoryTest.assertFalse((boolean)autoKey.equals((Object)basicKey));
    }

    public void testUnequalityVarious() {
        String sql = "select * from sys.systables";
        String schema = "APP";
        int rsh = 1;
        int rst = 1004;
        int rsc = 1008;
        int auto = 1;
        StatementKey[] keys = new StatementKey[]{StatementKeyFactory.newPrepared((String)sql, (String)schema, (int)rsh), StatementKeyFactory.newPrepared((String)sql, (String)schema, (int)rsh, (int)auto), StatementKeyFactory.newPrepared((String)sql, (String)schema, (int)rst, (int)rsc, (int)rsh), StatementKeyFactory.newCallable((String)sql, (String)schema, (int)rsh), StatementKeyFactory.newCallable((String)sql, (String)schema, (int)rst, (int)rsc, (int)rsh)};
        for (int outer = 0; outer < keys.length; ++outer) {
            StatementKey current = keys[outer];
            for (int inner = 0; inner < keys.length; ++inner) {
                if (outer != inner) {
                    if (!current.equals((Object)keys[inner])) continue;
                    StatementKeyFactoryTest.fail((String)("[" + current.toString() + "] should not equal [" + keys[inner].toString() + "]"));
                    continue;
                }
                StatementKeyFactoryTest.assertTrue((boolean)current.equals((Object)keys[inner]));
            }
        }
    }

    public void testCallableVsPrepared() {
        String sql = "select colA, colB from mytable";
        String schema = "SOMEAPP";
        int holdability = 1;
        StatementKey callable = StatementKeyFactory.newCallable((String)sql, (String)schema, (int)holdability);
        StatementKey prepared = StatementKeyFactory.newPrepared((String)sql, (String)schema, (int)holdability);
        StatementKeyFactoryTest.assertFalse((boolean)callable.equals((Object)prepared));
        StatementKeyFactoryTest.assertFalse((boolean)prepared.equals((Object)callable));
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(StatementKeyFactoryTest.class);
    }
}

