/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import com.pivotal.gemfirexd.internal.client.am.stmtcache.JDBCStatementCache;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKey;
import com.pivotal.gemfirexd.internal.client.am.stmtcache.StatementKeyFactory;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCStatementCacheTest
extends BaseJDBCTestCase {
    public JDBCStatementCacheTest(String name) {
        super(name);
    }

    public void testCreateCacheWithZeroOrNegativeMaxSize() {
        try {
            new JDBCStatementCache(-10);
            JDBCStatementCacheTest.fail((String)"Negative max size should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JDBCStatementCache(0);
            JDBCStatementCacheTest.fail((String)"Zero max size should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBasicInsertion() throws SQLException {
        String sql = "values 1";
        JDBCStatementCache cache = new JDBCStatementCache(10);
        PreparedStatement ps = this.prepareStatement(sql);
        StatementKey key = StatementKeyFactory.newPrepared((String)sql, (String)"app", (int)1);
        JDBCStatementCacheTest.assertTrue((boolean)cache.cacheStatement(key, ps));
        JDBCStatementCacheTest.assertEquals((Object)ps, (Object)cache.getCached(key));
    }

    public void testBasicDuplicateKeyInsertion() throws SQLException {
        String sql = "values 1";
        JDBCStatementCache cache = new JDBCStatementCache(10);
        PreparedStatement ps = this.prepareStatement(sql);
        StatementKey key = StatementKeyFactory.newPrepared((String)sql, (String)"app", (int)1);
        JDBCStatementCacheTest.assertTrue((boolean)cache.cacheStatement(key, ps));
        JDBCStatementCacheTest.assertFalse((boolean)cache.cacheStatement(key, ps));
        JDBCStatementCacheTest.assertEquals((Object)ps, (Object)cache.getCached(key));
    }

    public void testBasicCallableVsPrepared() throws SQLException {
        String sql = "values 7";
        String schema = "MYAPP";
        int rsh = 1;
        JDBCStatementCache cache = new JDBCStatementCache(10);
        PreparedStatement ps = this.prepareStatement(sql);
        StatementKey key = StatementKeyFactory.newPrepared((String)sql, (String)schema, (int)rsh);
        JDBCStatementCacheTest.assertTrue((boolean)cache.cacheStatement(key, ps));
        StatementKey callKey = StatementKeyFactory.newCallable((String)sql, (String)schema, (int)rsh);
        JDBCStatementCacheTest.assertNotSame((Object)ps, (Object)cache.getCached(callKey));
        CallableStatement cs = this.prepareCall(sql);
        JDBCStatementCacheTest.assertNull((Object)cache.getCached(callKey));
        JDBCStatementCacheTest.assertTrue((boolean)cache.cacheStatement(callKey, (PreparedStatement)cs));
        JDBCStatementCacheTest.assertSame((Object)cs, (Object)cache.getCached(callKey));
        JDBCStatementCacheTest.assertNotSame((Object)cs, (Object)cache.getCached(key));
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(JDBCStatementCacheTest.class);
    }
}

