/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestCase;

public class FormatableBitSetTest
extends BaseTestCase {
    private byte[] bits24;
    private byte[] bits24C;
    private FormatableBitSet empty;
    private FormatableBitSet bitset18;
    private FormatableBitSet bitset18C;
    private static final Method bitCount;

    public FormatableBitSetTest(String name) {
        super(name);
    }

    public void setUp() {
        this.bits24 = new byte[]{-50, 60, 0};
        this.bits24C = new byte[]{49, -61, -64};
        this.empty = new FormatableBitSet();
        this.bitset18 = new FormatableBitSet(this.bits24);
        this.bitset18.shrink(18);
        this.bitset18C = new FormatableBitSet(this.bits24C);
        this.bitset18C.shrink(18);
    }

    public void tearDown() throws Exception {
        this.empty = null;
        this.bits24 = null;
        this.bits24C = null;
        this.bitset18 = null;
        this.bitset18C = null;
        super.tearDown();
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(FormatableBitSetTest.class, "FormatableBitSetTest suite");
        if (bitCount != null) {
            ts.addTest((Test)new FormatableBitSetTest("numBitsSetInOneByte"));
            ts.addTest((Test)new FormatableBitSetTest("numBitsSetInTwoBytes"));
        }
        return ts;
    }

    public void testSetup() {
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getByteArray().length);
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((Object)this.bits24, (Object)this.bitset18.getByteArray());
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18C.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18C.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18C.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.invariantHolds());
        FormatableBitSetTest.assertEquals((Object)this.bits24C, (Object)this.bitset18C.getByteArray());
    }

    public void testIntCtor0() {
        FormatableBitSet zeroBits = new FormatableBitSet(0);
        FormatableBitSetTest.assertEquals((int)0, (int)zeroBits.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)zeroBits.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)zeroBits.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)zeroBits.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)zeroBits.getByteArray().length);
    }

    public void testIntCtor1() {
        FormatableBitSet oneBit = new FormatableBitSet(1);
        FormatableBitSetTest.assertEquals((int)1, (int)oneBit.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)oneBit.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)oneBit.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)oneBit.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)oneBit.getByteArray().length);
    }

    public void testIntCtor8() {
        FormatableBitSet eightBits = new FormatableBitSet(8);
        FormatableBitSetTest.assertEquals((int)8, (int)eightBits.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)eightBits.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)eightBits.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)eightBits.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)eightBits.getByteArray().length);
    }

    public void testIntCtor9() {
        FormatableBitSet nineBits = new FormatableBitSet(9);
        FormatableBitSetTest.assertEquals((int)9, (int)nineBits.getLength());
        FormatableBitSetTest.assertEquals((int)2, (int)nineBits.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)nineBits.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)nineBits.invariantHolds());
        FormatableBitSetTest.assertEquals((int)2, (int)nineBits.getByteArray().length);
    }

    public void testIntCtorNeg() {
        try {
            FormatableBitSet negBits = new FormatableBitSet(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyCpyCtor() {
        FormatableBitSet emptyCpy = new FormatableBitSet(this.empty);
        FormatableBitSetTest.assertEquals((int)0, (int)emptyCpy.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)emptyCpy.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)emptyCpy.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)emptyCpy.invariantHolds());
    }

    public void testCpyCtor() {
        FormatableBitSet cpy = new FormatableBitSet(this.bitset18);
        FormatableBitSetTest.assertEquals((int)18, (int)cpy.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)cpy.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)cpy.getNumBitsSet());
        FormatableBitSetTest.assertEquals((int)0, (int)cpy.compare(this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)cpy.equals((Object)this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)cpy.invariantHolds());
        FormatableBitSetTest.assertEquals((int)3, (int)cpy.getByteArray().length);
    }

    public void testGrowEmpty() {
        this.empty.grow(18);
        FormatableBitSetTest.assertEquals((int)18, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)3, (int)this.empty.getByteArray().length);
    }

    public void testGrow() {
        this.bitset18.grow(25);
        FormatableBitSetTest.assertEquals((int)25, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)4, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)4, (int)this.bitset18.getByteArray().length);
    }

    public void testGrowSmaller() {
        this.bitset18.grow(9);
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getByteArray().length);
    }

    public void testGrowNeg() {
        try {
            this.bitset18.grow(-9);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGrow0() {
        this.empty.grow(0);
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getByteArray().length);
    }

    public void testGrow1() {
        this.empty.grow(1);
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow2() {
        this.empty.grow(2);
        FormatableBitSetTest.assertEquals((int)2, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow3() {
        this.empty.grow(3);
        FormatableBitSetTest.assertEquals((int)3, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow4() {
        this.empty.grow(4);
        FormatableBitSetTest.assertEquals((int)4, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow5() {
        this.empty.grow(5);
        FormatableBitSetTest.assertEquals((int)5, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow6() {
        this.empty.grow(6);
        FormatableBitSetTest.assertEquals((int)6, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow7() {
        this.empty.grow(7);
        FormatableBitSetTest.assertEquals((int)7, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow8() {
        this.empty.grow(8);
        FormatableBitSetTest.assertEquals((int)8, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.empty.getByteArray().length);
    }

    public void testGrow9() {
        this.empty.grow(9);
        FormatableBitSetTest.assertEquals((int)9, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)2, (int)this.empty.getByteArray().length);
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)2, (int)this.empty.getLengthInBytes());
    }

    public void testShrinkEmpty() {
        this.empty.shrink(0);
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.getByteArray().length);
    }

    public void testShrink() {
        this.bitset18.shrink(9);
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getByteArray().length);
    }

    public void testShrinkLarger() {
        try {
            this.bitset18.shrink(25);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShrinkNeg() {
        try {
            this.bitset18.shrink(-9);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testShrink0() {
        this.bitset18.shrink(0);
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink1() {
        this.bitset18.shrink(1);
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink2() {
        this.bitset18.shrink(2);
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink3() {
        this.bitset18.shrink(3);
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink4() {
        this.bitset18.shrink(4);
        FormatableBitSetTest.assertEquals((int)4, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink5() {
        this.bitset18.shrink(5);
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink6() {
        this.bitset18.shrink(6);
        FormatableBitSetTest.assertEquals((int)6, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)4, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink7() {
        this.bitset18.shrink(7);
        FormatableBitSetTest.assertEquals((int)7, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink8() {
        this.bitset18.shrink(8);
        FormatableBitSetTest.assertEquals((int)8, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink9() {
        this.bitset18.shrink(9);
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getByteArray().length);
    }

    public void testShrink10() {
        this.bitset18.shrink(10);
        FormatableBitSetTest.assertEquals((int)10, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)5, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18.getByteArray().length);
    }

    public void testCompareSameEmpty() {
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.compare(this.empty));
    }

    public void testCompareAnotherEmpty() {
        FormatableBitSetTest.assertEquals((int)0, (int)this.empty.compare(new FormatableBitSet()));
    }

    public void testCompare18Empty() {
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.compare(new FormatableBitSet()));
    }

    public void testCompareEmpty18() {
        FormatableBitSetTest.assertEquals((int)-1, (int)this.empty.compare(this.bitset18));
    }

    public void testCompareToComplement() {
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.compare(this.bitset18C));
    }

    public void testCompareDifferentArray() {
        FormatableBitSet small = new FormatableBitSet(this.bitset18);
        small.shrink(9);
        FormatableBitSetTest.assertTrue((boolean)small.invariantHolds());
        FormatableBitSet large = new FormatableBitSet(this.bitset18);
        large.grow(100);
        FormatableBitSetTest.assertTrue((boolean)large.invariantHolds());
        large.shrink(9);
        FormatableBitSetTest.assertTrue((boolean)large.invariantHolds());
        FormatableBitSetTest.assertEquals((int)0, (int)small.compare(large));
    }

    public void testIsSetEmpty() {
        try {
            this.empty.isSet(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.isSet(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.isSet(0);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsSet() {
        try {
            this.bitset18C.isSet(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.bitset18C.isSet(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(0));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(1));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(2));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(3));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(4));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(5));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(6));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(7));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(8));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(9));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(10));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(11));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(12));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18C.isSet(13));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(14));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(15));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(16));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18C.isSet(17));
        try {
            this.bitset18C.isSet(18);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetEmpty() {
        try {
            this.empty.set(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.set(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.set(0);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSet() {
        try {
            this.bitset18.set(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.bitset18.set(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bitset18.set(0);
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        this.bitset18.set(1);
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        try {
            this.bitset18.set(18);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClearEmpty() {
        try {
            this.empty.clear(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.clear(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.empty.clear(0);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testClear() {
        try {
            this.bitset18.clear(-8);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.bitset18.clear(-1);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bitset18.clear(0);
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        this.bitset18.clear(1);
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        try {
            this.bitset18.clear(18);
            FormatableBitSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAnySetBitEmpty() {
        FormatableBitSetTest.assertEquals((int)this.empty.anySetBit(), (int)-1);
    }

    public void testAnySetBit() {
        FormatableBitSetTest.assertEquals((int)2, (int)this.bitset18C.anySetBit());
        this.bitset18C.clear(2);
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18C.anySetBit());
    }

    public void testAnySetBitBeyondBit() {
        FormatableBitSetTest.assertEquals((int)4, (int)this.bitset18.anySetBit(1));
    }

    public void testAnySetBitBeyondBitNeg() {
        FormatableBitSetTest.assertEquals((int)1, (int)this.bitset18.anySetBit(0));
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.anySetBit(-1));
        try {
            this.bitset18.anySetBit(-2);
            FormatableBitSetTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.bitset18.anySetBit(-3);
            FormatableBitSetTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testAnySetBitBeyondBitPastEnd() {
        FormatableBitSetTest.assertEquals((int)-1, (int)this.bitset18.anySetBit(18));
    }

    public void testORWithNull() {
        FormatableBitSet cpy = new FormatableBitSet(this.bitset18);
        FormatableBitSetTest.assertTrue((boolean)cpy.invariantHolds());
        this.bitset18.or(null);
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)cpy.equals((Object)this.bitset18));
    }

    public void testORWithEmpty() {
        FormatableBitSet cpy = new FormatableBitSet(this.bitset18);
        this.bitset18.or(this.empty);
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)cpy.equals((Object)this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testORWithComplement() {
        this.bitset18.or(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)this.bitset18.getNumBitsSet(), (int)18);
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testORWithSmaller() {
        this.bitset18C.shrink(9);
        this.bitset18.or(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)13, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testORWithLarger() {
        this.bitset18.shrink(9);
        this.bitset18.or(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)14, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testANDWithNull() {
        this.bitset18.and(null);
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getByteArray().length);
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testANDWithEmpty() {
        this.bitset18.and(new FormatableBitSet());
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testANDWithComplement() {
        this.bitset18.and(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testANDWithSmaller() {
        this.bitset18C.shrink(9);
        this.bitset18.and(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testANDWithLarger() {
        this.bitset18.shrink(9);
        this.bitset18.and(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)0, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testXORWithNull() {
        FormatableBitSet cpy = new FormatableBitSet(this.bitset18);
        this.bitset18.xor(null);
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)cpy.equals((Object)this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testXORWithEmpty() {
        FormatableBitSet cpy = new FormatableBitSet(this.bitset18);
        this.bitset18.xor(this.empty);
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)9, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)cpy.equals((Object)this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getByteArray().length);
    }

    public void testXORWithComplement() {
        this.bitset18.set(2);
        this.bitset18.set(3);
        this.bitset18.xor(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)16, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertFalse((boolean)this.bitset18.isSet(2));
        FormatableBitSetTest.assertFalse((boolean)this.bitset18.isSet(3));
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    public void testXORWithSmaller() {
        this.bitset18C.shrink(9);
        this.bitset18.xor(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)18, (int)this.bitset18.getLength());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getLengthInBytes());
        FormatableBitSetTest.assertEquals((int)13, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
        FormatableBitSetTest.assertEquals((int)3, (int)this.bitset18.getByteArray().length);
    }

    public void testXORWithLarger() {
        this.bitset18.shrink(9);
        this.bitset18.xor(this.bitset18C);
        FormatableBitSetTest.assertEquals((int)14, (int)this.bitset18.getNumBitsSet());
        FormatableBitSetTest.assertTrue((boolean)this.bitset18.invariantHolds());
    }

    private static int bitsInByte(byte b) throws Exception {
        Integer arg = new Integer(b & 0xFF);
        Integer ret = (Integer)bitCount.invoke(null, arg);
        return ret;
    }

    public void numBitsSetInOneByte() throws Exception {
        for (int i = -128; i <= 127; ++i) {
            byte b = (byte)i;
            FormatableBitSet bs = new FormatableBitSet(new byte[]{b});
            FormatableBitSetTest.assertEquals((String)("invalid bit count for b=" + b), (int)FormatableBitSetTest.bitsInByte(b), (int)bs.getNumBitsSet());
        }
    }

    public void numBitsSetInTwoBytes() throws Exception {
        for (int i = -128; i <= 127; ++i) {
            byte b1 = (byte)i;
            int bits1 = FormatableBitSetTest.bitsInByte(b1);
            for (int j = -128; j <= 127; ++j) {
                byte b2 = (byte)j;
                FormatableBitSet bs = new FormatableBitSet(new byte[]{b1, b2});
                FormatableBitSetTest.assertEquals((String)("invalid bit count for b1=" + b1 + " and b2=" + b2), (int)(bits1 + FormatableBitSetTest.bitsInByte(b2)), (int)bs.getNumBitsSet());
            }
        }
    }

    public void testExternal() throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buf);
        this.bitset18.writeExternal((ObjectOutput)oos);
        oos.flush();
        this.empty.readExternal((ObjectInput)new ObjectInputStream(new ByteArrayInputStream(buf.toByteArray())));
        FormatableBitSetTest.assertTrue((boolean)this.empty.equals((Object)this.bitset18));
        FormatableBitSetTest.assertTrue((boolean)this.empty.invariantHolds());
    }

    static {
        Method m = null;
        try {
            m = Integer.class.getMethod("bitCount", Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        bitCount = m;
    }
}

