/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.harness;

import com.pivotal.gemfirexd.internal.iapi.services.context.Context;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derbyTesting.unitTests.harness.T_Bombable;

public class T_Bomb
implements Runnable {
    public static String BOMB_DELAY_PN = "derby.testing.BombDelay";
    private static int DEFAULT_BOMB_DELAY = 3600000;
    private static T_Bomb me;
    private Thread t;
    private Vector v;
    private long delay = PropertyUtil.getSystemInt((String)BOMB_DELAY_PN, (int)0, (int)Integer.MAX_VALUE, (int)DEFAULT_BOMB_DELAY);
    private boolean armed = false;

    private T_Bomb() {
        this.v = new Vector();
        this.t = new Thread(this);
        this.t.setDaemon(true);
        this.t.start();
    }

    public static synchronized void makeBomb() {
        if (me == null) {
            me = new T_Bomb();
        }
        me.armBomb();
    }

    public synchronized void armBomb() {
        if (me == null) {
            me = new T_Bomb();
        }
        T_Bomb.me.armed = true;
    }

    public static synchronized void explodeBomb() {
        if (me == null) {
            me = new T_Bomb();
        }
        T_Bomb.me.armed = true;
        me.blowUp();
    }

    public static synchronized void registerBombable(T_Bombable b) {
        if (me == null) {
            me = new T_Bomb();
        }
        T_Bomb.me.v.addElement(b);
    }

    public static synchronized void unRegisterBombable(T_Bombable b) {
        if (null == me || null == b) {
            return;
        }
        T_Bomb.me.v.removeElement(b);
        if (T_Bomb.me.v.isEmpty()) {
            T_Bomb.me.armed = false;
            T_Bomb.me.t.interrupt();
            me = null;
        }
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.armed) {
            me.blowUp();
        }
    }

    private void blowUp() {
        this.performLastGasp();
        ContextService csf = ContextService.getFactory();
        if (csf != null) {
            System.out.println("ran out of time");
            csf.notifyAllActiveThreads((Context)null);
        }
        try {
            Thread.currentThread();
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Exit due to time bomb");
        Runtime.getRuntime().exit(1234);
    }

    private void performLastGasp() {
        Enumeration e = this.v.elements();
        while (e.hasMoreElements()) {
            try {
                T_Bombable b = (T_Bombable)e.nextElement();
                b.lastChance();
            }
            catch (Exception exc) {
                System.out.println("Last Gasp exception");
                exc.printStackTrace();
            }
        }
    }
}

